/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.io.simple;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.io.DataStagingCredentials;
import de.fzj.unicore.xnjs.io.IFileTransfer;
import de.fzj.unicore.xnjs.io.simple.AsyncFilemover;
import de.fzj.unicore.xnjs.io.simple.UsernamePassword;
import de.fzj.unicore.xnjs.tsi.TSI;
import de.fzj.unicore.xnjs.util.IOUtils;
import de.fzj.unicore.xnjs.util.LogUtil;
import eu.unicore.security.Client;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.apache.log4j.Logger;

public class FTPDownload
extends AsyncFilemover {
    private static final Logger logger = LogUtil.getLogger("unicore.xnjs.io", FTPDownload.class);
    private final UsernamePassword credentials;
    public static final String CURL = "curl";

    public FTPDownload(Client client, String workingDirectory, URI source, String target, Configuration config, DataStagingCredentials credentials) {
        super(client, workingDirectory, source.toString(), target, config);
        if (credentials != null && !(credentials instanceof UsernamePassword)) {
            throw new IllegalArgumentException("Unsupported credential type <" + credentials.getClass().getName() + ">, only UsernamePassword is supported.");
        }
        this.credentials = (UsernamePassword)credentials;
    }

    @Override
    public final boolean isImport() {
        return true;
    }

    @Override
    public String makeCommandline() throws MalformedURLException {
        String curl = this.configuration.getIDB().getProperty(CURL, CURL);
        URL url = IOUtils.addFTPCredentials(new URL(this.source), this.credentials);
        StringBuilder sb = new StringBuilder();
        sb.append(curl).append(" \"").append(url).append("\" -o \"");
        sb.append(this.workingDirectory).append("/").append(this.target).append("\"");
        return sb.toString();
    }

    @Override
    public void run() {
        if (this.configuration.getIDB().getProperty(CURL) == null) {
            this.runLocally();
        } else {
            super.run();
        }
    }

    public void runLocally() {
        try {
            this.startTime = System.currentTimeMillis();
            logger.info((Object)("Executing " + this.getDescription()));
            URL url = IOUtils.addFTPCredentials(new URL(this.source), this.credentials);
            InputStream is = url.openStream();
            OutputStream os = null;
            if (this.storageAdapter == null) {
                TSI tsi = this.configuration.getTargetSystemInterface(this.client);
                tsi.setStorageRoot(this.workingDirectory);
                os = tsi.getOutputStream(this.target);
            } else {
                os = this.storageAdapter.getOutputStream(this.target, false);
            }
            this.status = IFileTransfer.Status.RUNNING;
            this.copyTrackingTransferedBytes(is, os);
            is.close();
            os.flush();
            os.close();
            this.status = IFileTransfer.Status.DONE;
            this.reportUsage();
        }
        catch (Exception ex) {
            this.reportFailure("Could not do FTP download", ex);
        }
    }

    @Override
    public String getProtocol() {
        return "ftp";
    }
}

