/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.io.simple;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.io.DataStagingCredentials;
import de.fzj.unicore.xnjs.io.IFileTransfer;
import de.fzj.unicore.xnjs.io.IFileTransferCreator;
import de.fzj.unicore.xnjs.io.simple.FTPDownload;
import de.fzj.unicore.xnjs.io.simple.FTPUpload;
import de.fzj.unicore.xnjs.io.simple.FileCopy;
import de.fzj.unicore.xnjs.io.simple.GSIFTPDownload;
import de.fzj.unicore.xnjs.io.simple.GSIFTPUpload;
import de.fzj.unicore.xnjs.io.simple.HTTPFileDownload;
import de.fzj.unicore.xnjs.io.simple.HTTPFileUpload;
import de.fzj.unicore.xnjs.io.simple.Link;
import de.fzj.unicore.xnjs.io.simple.MailtoUpload;
import de.fzj.unicore.xnjs.io.simple.ScpDownload;
import de.fzj.unicore.xnjs.io.simple.ScpUpload;
import eu.unicore.security.Client;
import java.net.URI;

public class DefaultTransferCreator
implements IFileTransferCreator {
    private final Configuration configuration;

    public DefaultTransferCreator(Configuration config) {
        this.configuration = config;
    }

    @Override
    public String getProtocol() {
        return "ftp, gsiftp, scp, http, https, mailto, file, link";
    }

    @Override
    public IFileTransfer createFileExport(Client client, String workingDirectory, String source, URI target, DataStagingCredentials credentials) {
        String scheme = target.getScheme();
        if ("ftp".equalsIgnoreCase(scheme)) {
            return new FTPUpload(client, workingDirectory, source, target, this.configuration, credentials);
        }
        if ("gsiftp".equalsIgnoreCase(scheme)) {
            return new GSIFTPUpload(client, workingDirectory, source, target, this.configuration);
        }
        if ("scp".equalsIgnoreCase(scheme)) {
            return new ScpUpload(client, workingDirectory, source, target, this.configuration, credentials);
        }
        if ("mailto".equalsIgnoreCase(scheme)) {
            return new MailtoUpload(client, workingDirectory, source, target.getSchemeSpecificPart(), this.configuration);
        }
        if ("http".equalsIgnoreCase(scheme) || "https".equalsIgnoreCase(scheme)) {
            return new HTTPFileUpload(client, workingDirectory, source, target.toString(), this.configuration, credentials);
        }
        if ("file".equalsIgnoreCase(scheme)) {
            return new FileCopy(this.configuration, client, workingDirectory, source, target.getRawPath(), false);
        }
        if ("link".equalsIgnoreCase(scheme)) {
            return new Link(this.configuration, client, workingDirectory, source, target.getRawPath(), false);
        }
        return null;
    }

    @Override
    public IFileTransfer createFileImport(Client client, String workingDirectory, URI source, String target, DataStagingCredentials credentials) {
        String scheme = source.getScheme();
        if ("ftp".equalsIgnoreCase(scheme)) {
            return new FTPDownload(client, workingDirectory, source, target, this.configuration, credentials);
        }
        if ("gsiftp".equalsIgnoreCase(scheme)) {
            return new GSIFTPDownload(client, workingDirectory, source, target, this.configuration);
        }
        if ("scp".equalsIgnoreCase(scheme)) {
            return new ScpDownload(client, workingDirectory, source, target, this.configuration, credentials);
        }
        if ("http".equalsIgnoreCase(scheme) || "https".equalsIgnoreCase(scheme)) {
            return new HTTPFileDownload(client, workingDirectory, source.toString(), target, this.configuration, credentials);
        }
        if ("file".equalsIgnoreCase(scheme)) {
            return new FileCopy(this.configuration, client, workingDirectory, source.getRawPath(), target, true);
        }
        if ("link".equalsIgnoreCase(scheme)) {
            return new Link(this.configuration, client, workingDirectory, source.getSchemeSpecificPart(), target, true);
        }
        return null;
    }
}

