/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.io.simple;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.io.IFileTransfer;
import de.fzj.unicore.xnjs.io.IStorageAdapter;
import de.fzj.unicore.xnjs.io.XnjsFile;
import de.fzj.unicore.xnjs.tsi.TSI;
import de.fzj.unicore.xnjs.util.AsyncCommandHelper;
import de.fzj.unicore.xnjs.util.FileMonitor;
import de.fzj.unicore.xnjs.util.IOUtils;
import de.fzj.unicore.xnjs.util.LogUtil;
import de.fzj.unicore.xnjs.util.Observer;
import de.fzj.unicore.xnjs.util.ResultHolder;
import eu.unicore.security.Client;
import eu.unicore.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public abstract class AsyncFilemover
implements IFileTransfer,
Observer<XnjsFile> {
    protected static final Logger logger = LogUtil.getLogger("unicore.xnjs.io", AsyncFilemover.class);
    protected static final Logger usageLogger = Logger.getLogger((String)"unicore.services.datatransfer.USAGE");
    protected volatile IFileTransfer.Status status;
    protected String statusMessage;
    protected final String target;
    protected final String workingDirectory;
    protected final String source;
    protected final Client client;
    protected final String uuid;
    protected final Configuration configuration;
    protected AsyncCommandHelper ach;
    protected volatile long transferredBytes = 0L;
    protected IStorageAdapter storageAdapter;
    protected IFileTransfer.OverwritePolicy overwrite;
    protected volatile boolean abort = false;
    private String parentActionID;
    private boolean ignoreFailure;
    protected long startTime = System.currentTimeMillis();

    public AsyncFilemover(Client client, String workingDirectory, String source, String target, Configuration config) {
        this.uuid = UUID.randomUUID().toString();
        this.configuration = config;
        this.status = IFileTransfer.Status.CREATED;
        this.target = target;
        this.workingDirectory = workingDirectory;
        this.client = client;
        this.source = source;
    }

    protected abstract String makeCommandline() throws Exception;

    protected void preSubmit() throws Exception {
    }

    protected abstract boolean isImport();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block15: {
            this.startTime = System.currentTimeMillis();
            if (this.abort) {
                this.status = IFileTransfer.Status.ABORTED;
                this.statusMessage = "Aborted";
                return;
            }
            this.status = IFileTransfer.Status.RUNNING;
            this.statusMessage = "Running";
            logger.info((Object)("Submitting " + this));
            FileMonitor monitor = null;
            try {
                if (this.isImport()) {
                    monitor = new FileMonitor(this.workingDirectory, this.target, this.client, this.configuration, 3L, TimeUnit.SECONDS);
                    monitor.registerObserver(this);
                }
                String cmd = this.makeCommandline();
                this.ach = new AsyncCommandHelper(this.configuration, cmd, this.uuid, this.getParentActionID(), this.client);
                this.preSubmit();
                this.ach.submit();
                while (!this.ach.isDone()) {
                    Thread.sleep(2000L);
                }
                ResultHolder res = this.ach.getResult();
                if (res.getExitCode() != null && res.getExitCode() == 0) {
                    logger.info((Object)("Async transfer " + this.source + " -> " + this.target + " is DONE."));
                    this.status = IFileTransfer.Status.DONE;
                    if (monitor != null) {
                        monitor.run();
                    }
                    this.reportUsage();
                    break block15;
                }
                this.statusMessage = "Transfer failed.";
                try {
                    String error;
                    if (res != null && res.getResult().getErrorMessage() != null) {
                        this.statusMessage = this.statusMessage + " Error message: " + res.getResult().getErrorMessage();
                    }
                    if ((error = res.getStdErr()) != null && error.trim().length() > 0) {
                        this.statusMessage = this.statusMessage + " Error details: " + error;
                    }
                }
                catch (IOException ex) {
                    LogUtil.logException("Could not read stderr", ex, logger);
                }
                this.status = IFileTransfer.Status.FAILED;
            }
            catch (Exception ex) {
                this.reportFailure("Could not do transfer", ex);
                LogUtil.logException("Could not do transfer", ex, logger);
            }
            finally {
                if (monitor != null) {
                    monitor.dispose();
                }
            }
        }
    }

    @Override
    public void update(XnjsFile info) {
        if (info != null) {
            this.transferredBytes = info.getSize();
        }
    }

    @Override
    public String getUniqueId() {
        return this.uuid;
    }

    @Override
    public IFileTransfer.Status getStatus() {
        return this.status;
    }

    @Override
    public String getStatusMessage() {
        if (this.statusMessage != null) {
            return this.statusMessage;
        }
        return this.status != null ? this.status.toString() : "<unknown>";
    }

    @Override
    public long getTransferredBytes() {
        return this.transferredBytes;
    }

    @Override
    public long getDataSize() {
        if (this.isImport()) {
            if (IFileTransfer.Status.DONE == this.status) {
                try {
                    TSI tsi = this.configuration.getTargetSystemInterface(this.client);
                    tsi.setStorageRoot(this.workingDirectory);
                    return tsi.getProperties(this.target).getSize();
                }
                catch (Exception ex) {}
            }
        } else {
            try {
                TSI tsi = this.configuration.getTargetSystemInterface(this.client);
                tsi.setStorageRoot(this.workingDirectory);
                return tsi.getProperties(this.source).getSize();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1L;
    }

    @Override
    public void setStorageAdapter(IStorageAdapter adapter) {
        this.storageAdapter = adapter;
    }

    @Override
    public void setOverwritePolicy(IFileTransfer.OverwritePolicy overwrite) {
        this.overwrite = overwrite;
    }

    @Override
    public Map<String, Serializable> pause() {
        return null;
    }

    @Override
    public void resume(Map<String, Serializable> state) {
    }

    @Override
    public boolean abort() {
        this.abort = true;
        if (this.ach != null) {
            try {
                this.ach.abort();
            }
            catch (ExecutionException ee) {
                LogUtil.logException("Can't abort file transfer program", ee, logger);
            }
        }
        return true;
    }

    @Override
    public boolean isStreaming() {
        return false;
    }

    @Override
    public String getParentActionID() {
        return this.parentActionID;
    }

    @Override
    public void setParentActionID(String parentActionID) {
        this.parentActionID = parentActionID;
    }

    public ResultHolder getResult() {
        return this.ach != null ? this.ach.getResult() : null;
    }

    @Override
    public String getTarget() {
        return this.target;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    protected void copyTrackingTransferedBytes(InputStream in, OutputStream out) throws Exception {
        int bufferSize = 16384;
        byte[] buffer = new byte[bufferSize];
        int len = 0;
        while (!this.abort && (len = in.read(buffer, 0, bufferSize)) >= 0) {
            out.write(buffer, 0, len);
            this.transferredBytes += (long)len;
        }
    }

    public String toString() {
        return this.getDescription();
    }

    protected String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("Filetransfer ").append(this.uuid);
        sb.append(" '").append(this.source).append("' -> '").append(this.target);
        sb.append("' workdir='").append(this.workingDirectory).append("'");
        if (this.client != null) {
            sb.append(" client='").append(this.client.getDistinguishedName() + "'");
        }
        return sb.toString();
    }

    @Override
    public boolean isIgnoreFailure() {
        return this.ignoreFailure;
    }

    @Override
    public void setIgnoreFailure(boolean ignoreFailure) {
        this.ignoreFailure = ignoreFailure;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    protected void reportFailure(String message, Throwable cause) {
        this.status = IFileTransfer.Status.FAILED;
        this.statusMessage = Log.createFaultMessage((String)message, (Throwable)cause);
    }

    protected void reportUsage() {
        long finishTime = System.currentTimeMillis();
        long dataSize = this.getDataSize();
        long consumedMillis = finishTime - this.startTime;
        String r = IOUtils.format(Float.valueOf(consumedMillis > 0L ? (float)dataSize / (float)consumedMillis : 0.0f), 2);
        String what = this.isImport() ? "received" : "sent";
        String dn = this.client != null ? this.client.getDistinguishedName() : "anonymous";
        String url = "";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(what + dataSize + " bytes in " + consumedMillis + " milliseconds, data rate= " + r + " kB/s"));
        }
        if (usageLogger.isInfoEnabled()) {
            usageLogger.info((Object)("[" + dn + "]" + " [" + what + "]" + " [" + dataSize + "]" + " [" + r + " kB/s]" + " [" + url + "]" + " [" + this.source + "]" + " [" + this.target + "]" + " [" + this.getProtocol() + "]" + " [" + this.parentActionID + "]"));
        }
    }
}

