/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.io;

import de.fzj.unicore.xnjs.io.ACLEntry;
import de.fzj.unicore.xnjs.io.Permissions;
import de.fzj.unicore.xnjs.io.XnjsFileWithACL;
import java.util.Calendar;

public class XnjsFileImpl
implements XnjsFileWithACL {
    private String path;
    private long size;
    private boolean isDirectory;
    private boolean isOwnedByCaller;
    private Permissions permissions;
    private Calendar lastModified;
    private String metadata;
    private String owner;
    private String group;
    private String unixPermissions;
    private ACLEntry[] acl;

    public XnjsFileImpl() {
    }

    public XnjsFileImpl(String path, long size, boolean isDirectory, long lastModified, Permissions permissions, boolean isOwnedByCaller) {
        this.path = path;
        this.isDirectory = isDirectory;
        this.size = size;
        this.lastModified = Calendar.getInstance();
        this.lastModified.setTimeInMillis(lastModified);
        this.permissions = permissions;
        this.isOwnedByCaller = isOwnedByCaller;
    }

    public XnjsFileImpl(String path, long size, boolean isDirectory, long lastModified, Permissions permissions, boolean isOwnedByCaller, String owner, String group, String unixPermissions) {
        this(path, size, isDirectory, lastModified, permissions, isOwnedByCaller);
        this.owner = owner;
        this.group = group;
        this.unixPermissions = unixPermissions;
    }

    @Override
    public Calendar getLastModified() {
        return this.lastModified;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public boolean isDirectory() {
        return this.isDirectory;
    }

    public String toString() {
        return this.getPath() + " [" + this.getSize() + " bytes] [" + (this.isDirectory() ? "d" : "-") + this.permissions + "] " + this.lastModified.getTime();
    }

    public void setDirectory(boolean isDirectory) {
        this.isDirectory = isDirectory;
    }

    public void setLastModified(Calendar lastModified) {
        this.lastModified = lastModified;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setSize(long size) {
        this.size = size;
    }

    @Override
    public Permissions getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Permissions permissions) {
        this.permissions = permissions;
    }

    @Override
    public boolean isOwnedByCaller() {
        return this.isOwnedByCaller;
    }

    public void setOwnedByCaller(boolean isOwnedByCaller) {
        this.isOwnedByCaller = isOwnedByCaller;
    }

    @Override
    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public String getUNIXPermissions() {
        return this.unixPermissions;
    }

    public void setUNIXPermissions(String unixPermissions) {
        this.unixPermissions = unixPermissions;
    }

    @Override
    public ACLEntry[] getACL() {
        return this.acl;
    }

    public void setACL(ACLEntry[] acl) {
        this.acl = acl;
    }
}

