/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.io;

import java.util.regex.Pattern;

public class UNIXPermissionEntry {
    private String permissions;
    private final Pattern pattern;
    private static final Pattern GET_PATTERN = Pattern.compile("[r-][w-][x-]");
    private static final Pattern SET_PATTERN = Pattern.compile("[r-][w-][xX-]");

    public UNIXPermissionEntry(boolean isSet) {
        this.pattern = isSet ? SET_PATTERN : GET_PATTERN;
    }

    public UNIXPermissionEntry(boolean isSet, String permissions) throws IllegalArgumentException {
        this(isSet);
        if (permissions != null) {
            this.setPermissions(permissions);
        }
    }

    public String getPermissions() {
        return this.permissions;
    }

    public void setPermissions(String permissions) throws IllegalArgumentException {
        if (!this.pattern.matcher(permissions).matches()) {
            throw new IllegalArgumentException("Permissions string >" + permissions + "< must match " + this.pattern.pattern() + " regular expression.");
        }
        this.permissions = permissions;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.permissions == null ? 0 : this.permissions.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UNIXPermissionEntry other = (UNIXPermissionEntry)obj;
        return !(this.permissions == null ? other.permissions != null : !this.permissions.equals(other.permissions));
    }
}

