/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.io;

import de.fzj.unicore.xnjs.io.FileFilter;
import de.fzj.unicore.xnjs.io.XnjsFile;
import de.fzj.unicore.xnjs.tsi.TSI;
import java.util.Calendar;
import java.util.regex.Pattern;

public class SimpleFindOptions {
    private SimpleFindOptions() {
    }

    public static FileFilter suffixMatch(final String suffix, final boolean recurse) {
        return new FileFilter(){

            @Override
            public boolean accept(XnjsFile file, TSI tsi) {
                return file.getPath().endsWith(suffix);
            }

            @Override
            public boolean recurse() {
                return recurse;
            }
        };
    }

    public static FileFilter prefixMatch(final String prefix, final boolean recurse) {
        return new FileFilter(){

            @Override
            public boolean accept(XnjsFile file, TSI tsi) {
                return file.getPath().startsWith(prefix);
            }

            @Override
            public boolean recurse() {
                return recurse;
            }
        };
    }

    public static FileFilter nameContains(final String part, final boolean recurse) {
        return new FileFilter(){

            @Override
            public boolean accept(XnjsFile file, TSI tsi) {
                return file.getPath().contains(part);
            }

            @Override
            public boolean recurse() {
                return recurse;
            }
        };
    }

    public static FileFilter lowerSizeBound(final long size, final boolean recurse) {
        return new FileFilter(){

            @Override
            public boolean accept(XnjsFile file, TSI tsi) {
                return file.getSize() >= size;
            }

            @Override
            public boolean recurse() {
                return recurse;
            }
        };
    }

    public static FileFilter upperSizeBound(final long size, final boolean recurse) {
        return new FileFilter(){

            @Override
            public boolean accept(XnjsFile file, TSI tsi) {
                return file.getSize() <= size;
            }

            @Override
            public boolean recurse() {
                return recurse;
            }
        };
    }

    public static FileFilter lastAccessBefore(final Calendar lastAccess, final boolean recurse) {
        return new FileFilter(){

            @Override
            public boolean accept(XnjsFile file, TSI tsi) {
                return file.getLastModified().before(lastAccess);
            }

            @Override
            public boolean recurse() {
                return recurse;
            }
        };
    }

    public static FileFilter lastAccessAfter(final Calendar lastAccess, final boolean recurse) {
        return new FileFilter(){

            @Override
            public boolean accept(XnjsFile file, TSI tsi) {
                return file.getLastModified().after(lastAccess);
            }

            @Override
            public boolean recurse() {
                return recurse;
            }
        };
    }

    public static FileFilter filesOnly(final boolean recurse) {
        return new FileFilter(){

            @Override
            public boolean accept(XnjsFile file, TSI tsi) {
                return !file.isDirectory();
            }

            @Override
            public boolean recurse() {
                return recurse;
            }
        };
    }

    public static FileFilter directoriesOnly(final boolean recurse) {
        return new FileFilter(){

            @Override
            public boolean accept(XnjsFile file, TSI tsi) {
                return file.isDirectory();
            }

            @Override
            public boolean recurse() {
                return recurse;
            }
        };
    }

    public static FileFilter stringMatch(final String match, final boolean recurse) {
        return new FileFilter(){
            final Pattern p = Pattern.compile(this.makeRegExp());

            @Override
            public boolean accept(XnjsFile file, TSI tsi) {
                return this.p.matcher(file.getPath()).find();
            }

            @Override
            public boolean recurse() {
                return recurse;
            }

            private String makeRegExp() {
                StringBuilder pattern = new StringBuilder();
                pattern.append(match.replace("*", ".*").replace("?", "."));
                return pattern.toString();
            }
        };
    }

    public static FileFilter regExpMatch(final String regularExpression, final boolean recurse) {
        return new FileFilter(){
            final Pattern p;
            {
                this.p = Pattern.compile(regularExpression);
            }

            @Override
            public boolean accept(XnjsFile file, TSI tsi) {
                return this.p.matcher(file.getPath()).find();
            }

            @Override
            public boolean recurse() {
                return recurse;
            }
        };
    }
}

