/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.io;

import de.fzj.unicore.xnjs.io.FileFilter;
import de.fzj.unicore.xnjs.io.XnjsFile;
import de.fzj.unicore.xnjs.tsi.TSI;
import java.util.ArrayList;
import java.util.List;

public class CompositeFindOptions
implements FileFilter {
    private boolean recurse = true;
    private FileFilter base = new FileFilter(){

        @Override
        public boolean accept(XnjsFile file, TSI tsi) {
            return true;
        }

        @Override
        public boolean recurse() {
            return false;
        }
    };
    private final List<FileFilter> andOptions = new ArrayList<FileFilter>();
    private final List<FileFilter> orOptions = new ArrayList<FileFilter>();

    @Override
    public boolean accept(XnjsFile file, TSI tsi) {
        boolean result = this.base.accept(file, tsi);
        for (FileFilter opt : this.andOptions) {
            result = result && opt.accept(file, tsi);
        }
        boolean orResult = false;
        for (FileFilter opt : this.orOptions) {
            orResult = orResult || opt.accept(file, tsi);
        }
        return result || orResult;
    }

    @Override
    public boolean recurse() {
        return this.recurse;
    }

    public CompositeFindOptions match(FileFilter opt) {
        this.base = opt;
        return this;
    }

    public CompositeFindOptions and(FileFilter opt) {
        this.andOptions.add(opt);
        return this;
    }

    public CompositeFindOptions or(FileFilter opt) {
        this.orOptions.add(opt);
        return this;
    }

    public CompositeFindOptions setRecurse(boolean recurse) {
        this.recurse = recurse;
        return this;
    }
}

