/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.incarnation;

import de.fzj.unicore.xnjs.beans.inctweak.Action;
import de.fzj.unicore.xnjs.beans.inctweak.AfterScriptDocument;
import de.fzj.unicore.xnjs.beans.inctweak.BeforeScriptDocument;
import de.fzj.unicore.xnjs.beans.inctweak.IncarnationTweakerDocument;
import de.fzj.unicore.xnjs.beans.inctweak.RuleDocument;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.incarnation.AfterAction;
import de.fzj.unicore.xnjs.incarnation.BeforeAction;
import de.fzj.unicore.xnjs.incarnation.GroovyAction;
import de.fzj.unicore.xnjs.incarnation.GroovyFileAction;
import de.fzj.unicore.xnjs.incarnation.GroovyFileFilter;
import de.fzj.unicore.xnjs.incarnation.GroovyFilter;
import de.fzj.unicore.xnjs.incarnation.IncarnationTweaker;
import de.fzj.unicore.xnjs.incarnation.Rule;
import de.fzj.unicore.xnjs.incarnation.RulesContainer;
import de.fzj.unicore.xnjs.incarnation.SpelAction;
import de.fzj.unicore.xnjs.incarnation.SpelFilter;
import de.fzj.unicore.xnjs.incarnation.SpelScriptAction;
import de.fzj.unicore.xnjs.incarnation.TestContextBean;
import de.fzj.unicore.xnjs.util.LogUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlException;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;

public class TweakerConfiguration {
    private static final Logger log = LogUtil.getLogger("unicore.xnjs", TweakerConfiguration.class);
    private String file;
    private static final int DEF_UPDATE_CHECK = 10000;
    private static final int DEF_MAX_WAIT_FOR_SCRIPT = 10000;
    private long lastRulesLoadTime;
    private RulesContainer<BeforeAction> beforeRules;
    private RulesContainer<AfterAction> afterRules;
    private ExpressionParser spelParser;
    private int maxWaitForScript;

    public TweakerConfiguration(String file, ScheduledExecutorService executor, int updateInterval, int maxWaitForScript) throws IOException, XmlException, ParseException {
        this.init(file, maxWaitForScript);
        this.startConfigWatcher(updateInterval, executor);
    }

    public TweakerConfiguration(String file, ScheduledExecutorService executor) throws IOException, XmlException, ParseException {
        this.init(file, 10000);
        this.startConfigWatcher(10000L, executor);
    }

    private void init(String file, int maxWait) throws IOException, XmlException, ParseException {
        this.file = file;
        this.maxWaitForScript = maxWait;
        this.spelParser = new SpelExpressionParser();
        this.parse();
    }

    private void startConfigWatcher(long interval, ScheduledExecutorService executor) {
        FileWatcher r = new FileWatcher();
        executor.scheduleWithFixedDelay(r, interval, interval, TimeUnit.MILLISECONDS);
    }

    private void parse() throws IOException, XmlException, ParseException {
        IncarnationTweakerDocument mainDoc = IncarnationTweakerDocument.Factory.parse(new BufferedInputStream(new FileInputStream(this.file)));
        IncarnationTweakerDocument.IncarnationTweaker main = mainDoc.getIncarnationTweaker();
        BeforeScriptDocument.BeforeScript bs = main.getBeforeScript();
        RulesContainer<BeforeAction> bRules = this.parseBeforeSection(bs);
        AfterScriptDocument.AfterScript as = main.getAfterScript();
        RulesContainer<AfterAction> aRules = this.parseAfterSection(as);
        this.test(bRules, aRules);
        this.updateContainers(bRules, aRules);
        this.lastRulesLoadTime = System.currentTimeMillis();
    }

    private void test(RulesContainer<BeforeAction> bRules, RulesContainer<AfterAction> aRules) throws IOException {
        log.info((Object)"Will perform a dry run on just loaded incarnation rules.");
        TestContextBean root = new TestContextBean();
        IncarnationTweaker.ErrorHolder eh = new IncarnationTweaker.ErrorHolder();
        try {
            IncarnationTweaker.preScriptInternal(root, bRules, eh);
        }
        catch (ExecutionException e) {
            log.debug((Object)"Dry run of the BEFORE-SCRIPT section finished with the ExecutionException. This might be the expected behavior.", (Throwable)e);
        }
        if (eh.isError()) {
            throw new IOException("Configuration was read correctly but dry run of the incarnation rules from the BEFORE-SCRIPT section finished with an error. See previous log messages for details and recheck your configuration.");
        }
        root = new TestContextBean();
        try {
            IncarnationTweaker.postScriptInternal(root, "#!/bin/bash", aRules, eh);
        }
        catch (ExecutionException e) {
            log.debug((Object)"Dry run of the AFTER-SCRIPT section finished with the ExecutionException. This might be the expected behavior.", (Throwable)e);
        }
        if (eh.isError()) {
            throw new IOException("Configuration was read correctly but dry run of the incarnation rules from the AFTER-SCRIPT section finished with an error. See previous log messages for details and recheck your configuration.");
        }
        log.info((Object)"Dry run of incarnation rules suceeded.");
    }

    private synchronized void updateContainers(RulesContainer<BeforeAction> bRules, RulesContainer<AfterAction> aRules) {
        this.beforeRules = bRules;
        this.afterRules = aRules;
    }

    public synchronized RulesContainer<BeforeAction> getBeforeRules() {
        return this.beforeRules;
    }

    public synchronized RulesContainer<AfterAction> getAfterRules() {
        return this.afterRules;
    }

    private RulesContainer<BeforeAction> parseBeforeSection(BeforeScriptDocument.BeforeScript bs) throws ParseException, IOException {
        ArrayList bRules = new ArrayList();
        RulesContainer<BeforeAction> beforeRules = new RulesContainer<BeforeAction>(bRules);
        if (bs == null) {
            return beforeRules;
        }
        RuleDocument.Rule[] xmlRules = bs.getRuleArray();
        if (xmlRules == null || xmlRules.length == 0) {
            return beforeRules;
        }
        for (RuleDocument.Rule xmlRule : xmlRules) {
            String rawCond = xmlRule.getCondition();
            if (rawCond == null) {
                throw new ParseException("Rule without a condition found", -1);
            }
            Expression e = TweakerConfiguration.parseSpEL(this.spelParser, rawCond);
            boolean stopOnHit = xmlRule.isSetFinishOnHit() ? xmlRule.getFinishOnHit() : false;
            ArrayList<BeforeAction> actions = new ArrayList<BeforeAction>();
            Action[] xmlActions = xmlRule.getActionArray();
            if (xmlActions == null || xmlActions.length == 0) {
                throw new ParseException("Rule without action found", -1);
            }
            for (Action xmlAction : xmlActions) {
                BeforeAction action = this.getBeforeAction(xmlAction);
                actions.add(action);
            }
            bRules.add(new Rule(e, stopOnHit, actions));
        }
        return beforeRules;
    }

    private RulesContainer<AfterAction> parseAfterSection(AfterScriptDocument.AfterScript bs) throws ParseException, IOException {
        ArrayList aRules = new ArrayList();
        RulesContainer<AfterAction> afterRules = new RulesContainer<AfterAction>(aRules);
        if (bs == null) {
            return afterRules;
        }
        RuleDocument.Rule[] xmlRules = bs.getRuleArray();
        if (xmlRules == null || xmlRules.length == 0) {
            return afterRules;
        }
        for (RuleDocument.Rule xmlRule : xmlRules) {
            String rawCond = xmlRule.getCondition();
            if (rawCond == null) {
                throw new ParseException("Rule without a condition found", -1);
            }
            Expression e = TweakerConfiguration.parseSpEL(this.spelParser, rawCond);
            boolean stopOnHit = xmlRule.isSetFinishOnHit() ? xmlRule.getFinishOnHit() : false;
            ArrayList<AfterAction> actions = new ArrayList<AfterAction>();
            Action[] xmlActions = xmlRule.getActionArray();
            if (xmlActions == null || xmlActions.length == 0) {
                throw new ParseException("Rule without action found", -1);
            }
            for (Action xmlAction : xmlActions) {
                AfterAction action = this.getAfterAction(xmlAction);
                actions.add(action);
            }
            aRules.add(new Rule(e, stopOnHit, actions));
        }
        return afterRules;
    }

    private BeforeAction getBeforeAction(Action xmlAction) throws ParseException, IOException {
        String value = xmlAction.getStringValue();
        if (value == null) {
            throw new ParseException("Rule with empty action contents found", -1);
        }
        String type = xmlAction.getType();
        if (type == null || type.equals("spel")) {
            return new SpelAction(value);
        }
        if (type.equals("groovy")) {
            return new GroovyAction(value);
        }
        if (type.equals("script")) {
            return new SpelScriptAction(value, this.maxWaitForScript);
        }
        if (type.equals("groovy-file")) {
            return new GroovyFileAction(value);
        }
        throw new ParseException("Found action with an unknown type: <" + type + ">", -1);
    }

    private AfterAction getAfterAction(Action xmlAction) throws ParseException, IOException {
        String value = xmlAction.getStringValue();
        if (value == null) {
            throw new ParseException("Rule with empty action contents found", -1);
        }
        String type = xmlAction.getType();
        if (type == null || type.equals("script")) {
            return new SpelFilter(value, this.maxWaitForScript);
        }
        if (type.equals("groovy")) {
            return new GroovyFilter(value);
        }
        if (type.equals("groovy-file")) {
            return new GroovyFileFilter(value);
        }
        throw new ParseException("Found action with an unknown type: <" + type + ">", -1);
    }

    public static Expression parseSpEL(ExpressionParser spelParser, String expr) throws ParseException {
        return TweakerConfiguration.parseSpEL(spelParser, expr, null);
    }

    public static Expression parseSpEL(ExpressionParser spelParser, String expr, ParserContext parserCtx) throws ParseException {
        try {
            return parserCtx == null ? spelParser.parseExpression(expr) : spelParser.parseExpression(expr, parserCtx);
        }
        catch (org.springframework.expression.ParseException e) {
            throw new ParseException(e.getMessage(), e.getPosition());
        }
        catch (Exception ee) {
            throw new ParseException("Other problem parsing SpEL expression '" + expr + "': " + ee.toString(), -1);
        }
    }

    public long getLastRulesLoadTime() {
        return this.lastRulesLoadTime;
    }

    private class FileWatcher
    implements Runnable {
        private final File target;
        private long lastAccessed;

        public FileWatcher() {
            this.target = new File(TweakerConfiguration.this.file);
            this.lastAccessed = this.target.lastModified();
        }

        @Override
        public void run() {
            if (this.target.lastModified() <= this.lastAccessed) {
                return;
            }
            this.lastAccessed = this.target.lastModified();
            log.info((Object)"Dynamic incarnation configuration file was modified, re-configuring.");
            try {
                TweakerConfiguration.this.parse();
            }
            catch (Exception e) {
                log.error((Object)("Error reading new incarnation configuration (file " + TweakerConfiguration.this.file + "): " + e.toString()), (Throwable)e);
            }
        }
    }
}

