/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.incarnation;

import de.fzj.unicore.xnjs.incarnation.AfterAction;
import de.fzj.unicore.xnjs.incarnation.RootCtxBean;
import de.fzj.unicore.xnjs.incarnation.ScriptActionBase;
import de.fzj.unicore.xnjs.incarnation.TweakerConfiguration;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.text.ParseException;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParserContext;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;

public class SpelFilter
extends ScriptActionBase
implements AfterAction {
    public static final String ID = "script";
    private Expression expression;

    public SpelFilter(String expr, int maxWait) throws ParseException {
        super(maxWait);
        this.expression = TweakerConfiguration.parseSpEL((ExpressionParser)new SpelExpressionParser(), expr, (ParserContext)new TemplateParserContext("${", "}"));
    }

    @Override
    public String filter(RootCtxBean root, String script) throws Exception {
        Process p = this.runScript(this.expression, root);
        TimeLimitedThread tlthread = new TimeLimitedThread(p, script);
        Thread thread = new Thread(tlthread);
        thread.start();
        this.waitFor(p, thread, tlthread);
        return new String(tlthread.buf, 0, tlthread.length, Charset.defaultCharset());
    }

    @Override
    public String getActionDefinition() {
        return this.expression.getExpressionString();
    }

    private static class TimeLimitedThread
    extends ScriptActionBase.TimeLimitedThreadBase {
        private byte[] buf;
        private int length;
        private String script;

        public TimeLimitedThread(Process p, String script) {
            super(p);
            this.script = script;
        }

        @Override
        public void unsafeRun() throws Exception {
            OutputStream os = this.p.getOutputStream();
            byte[] orig = this.script.getBytes(Charset.defaultCharset());
            os.write(orig);
            os.flush();
            os.close();
            InputStream is = this.p.getInputStream();
            this.buf = new byte[Math.max(orig.length * 10, 10240)];
            int i = 0;
            int r = 0;
            while ((r = is.read(this.buf, i, this.buf.length - i)) > 0) {
                i += r;
            }
            if (r != -1) {
                throw new Exception("Filtered script produced by the command is too long. Maximal length is 10kb or 10 times legth of the original script whichever is bigger.");
            }
            this.length = i;
            super.unsafeRun();
        }
    }
}

