/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.incarnation;

import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.incarnation.RootCtxBean;
import de.fzj.unicore.xnjs.incarnation.SimplifiedCmdLineLexer;
import de.fzj.unicore.xnjs.util.LogUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public abstract class ScriptActionBase {
    protected static final Logger log = LogUtil.getLogger("unicore.xnjs", ScriptActionBase.class);
    protected int maxWaitIter;
    protected static final int WAIT_T = 50;
    protected static final int RECOGNIZED_ERROR_CODE = 10;

    public ScriptActionBase(int maxWait) {
        this.maxWaitIter = maxWait / 50;
    }

    protected Process runScript(Expression expression, RootCtxBean root) throws Exception {
        StandardEvaluationContext ctx = new StandardEvaluationContext((Object)root);
        Object o = expression.getValue((EvaluationContext)ctx);
        if (o == null) {
            throw new Exception("Script SpEL expression was evaluated to null");
        }
        String cmdLine = o.toString();
        Object[] cmdLineTokens = SimplifiedCmdLineLexer.tokenizeString(cmdLine);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will run the following command line (comma is used to separate arguments):\n" + Arrays.toString(cmdLineTokens)));
        }
        Runtime runtime = Runtime.getRuntime();
        return runtime.exec((String[])cmdLineTokens);
    }

    protected void waitFor(Process p, Thread thread, TimeLimitedThreadBase tlthread) throws Exception {
        try {
            thread.join(this.maxWaitIter * 50);
            if (thread.isAlive()) {
                throw new InterruptedException();
            }
        }
        catch (InterruptedException e) {
            p.destroy();
            thread.interrupt();
            throw new Exception("Killed the invoked script as it hang for at least " + this.maxWaitIter * 50 + "ms");
        }
        if (tlthread.exc != null) {
            throw tlthread.exc;
        }
        int exitCode = 0;
        try {
            exitCode = p.exitValue();
        }
        catch (IllegalThreadStateException e) {
            // empty catch block
        }
        if (exitCode == 10) {
            throw new ExecutionException(21, tlthread.stderr);
        }
        if (exitCode != 0) {
            log.warn((Object)"Filter script finished with a non zero return code");
        }
    }

    public static String readStdErr(Process p) {
        String msg;
        InputStream is = p.getErrorStream();
        byte[] buf = new byte[1024];
        int i = 0;
        int r = 0;
        try {
            while ((r = is.read(buf, i, buf.length - i)) > 0) {
                i += r;
            }
            msg = new String(buf, 0, i, Charset.defaultCharset());
        }
        catch (IOException e) {
            msg = "Error reading the command's stderr.";
        }
        return msg;
    }

    protected boolean finished(Process p) {
        try {
            p.exitValue();
        }
        catch (IllegalThreadStateException ie) {
            return false;
        }
        return true;
    }

    protected static class TimeLimitedThreadBase
    implements Runnable {
        protected Process p;
        protected String stderr;
        protected Exception exc = null;

        public TimeLimitedThreadBase(Process p) {
            this.p = p;
        }

        public void unsafeRun() throws Exception {
            this.stderr = ScriptActionBase.readStdErr(this.p);
            this.p.waitFor();
        }

        @Override
        public void run() {
            try {
                this.unsafeRun();
            }
            catch (Exception e) {
                this.exc = e;
            }
        }
    }
}

