/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.incarnation;

import de.fzj.unicore.xnjs.jsdl.JSDLResourceSet;
import de.fzj.unicore.xnjs.resources.ExclusiveExecutionResource;
import de.fzj.unicore.xnjs.resources.ReservationResource;
import de.fzj.unicore.xnjs.resources.Resource;
import de.fzj.unicore.xnjs.resources.ResourceSet;
import de.fzj.unicore.xnjs.resources.ValueListResource;
import java.util.Collections;

public class ResourcesWrapper {
    private final ResourceSet wrapped;

    public ResourcesWrapper(ResourceSet wrapped) {
        this.wrapped = wrapped;
    }

    public Double getIndividualCPUCount() {
        return this.safeGetValue(this.wrapped.getResource("CPUsPerNode"));
    }

    public void setIndividualCPUCount(double value) {
        this.wrapped.putResource(JSDLResourceSet.createDoubleResource("CPUsPerNode", value, Resource.Category.PROCESSING));
    }

    public Double getTotalResourceCount() {
        return this.safeGetValue(this.wrapped.getResource("Nodes"));
    }

    public void setTotalResourceCount(double value) {
        this.wrapped.putResource(JSDLResourceSet.createDoubleResource("Nodes", value, Resource.Category.PROCESSING));
    }

    public Double getTotalCPUCount() {
        return this.safeGetValue(this.wrapped.getResource("TotalCPUs"));
    }

    public void setTotalCPUCount(double value) {
        this.wrapped.putResource(JSDLResourceSet.createDoubleResource("TotalCPUs", value, Resource.Category.PROCESSING));
    }

    public Double getIndividualPhysicalMemory() {
        return this.safeGetValue(this.wrapped.getResource("MemoryPerNode"));
    }

    public void setIndividualPhysicalMemory(double value) {
        this.wrapped.putResource(JSDLResourceSet.createDoubleResource("MemoryPerNode", value, Resource.Category.MEMORY));
    }

    public Double getIndividualCPUTime() {
        return this.safeGetValue(this.wrapped.getResource("CPUTime"));
    }

    public void setIndividualCPUTime(double value) {
        this.wrapped.putResource(JSDLResourceSet.createDoubleResource("CPUTime", value, Resource.Category.TIME));
    }

    public void setQueue(String queue) {
        this.wrapped.putResource(new ValueListResource("Queue", queue, Collections.singletonList(queue), Resource.Category.QUEUE));
    }

    public String getQueue() {
        Resource ret = this.wrapped.getResource("queue");
        return ret == null ? null : ret.getStringValue();
    }

    public String getReservationId() {
        Resource reservation = this.wrapped.getResource("ReservationID");
        return reservation != null ? reservation.getStringValue() : null;
    }

    public void setReservationId(String reservation) {
        this.wrapped.putResource(new ReservationResource(reservation));
    }

    public void setExclusiveExecution(boolean value) {
        this.wrapped.putResource(new ExclusiveExecutionResource(value));
    }

    public Boolean getExclusiveExecution() {
        Resource exclusive = this.wrapped.getResource("ExclusiveExecution");
        return exclusive != null ? (Boolean)exclusive.getValue() : null;
    }

    public ResourceSet getAllResources() {
        return this.wrapped;
    }

    private Double safeGetValue(Resource from) {
        return from != null ? from.getDoubleValue() : null;
    }
}

