/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.incarnation;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.ems.Action;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.incarnation.AfterAction;
import de.fzj.unicore.xnjs.incarnation.BeforeAction;
import de.fzj.unicore.xnjs.incarnation.ITweaker;
import de.fzj.unicore.xnjs.incarnation.RootCtxBean;
import de.fzj.unicore.xnjs.incarnation.Rule;
import de.fzj.unicore.xnjs.incarnation.RulesContainer;
import de.fzj.unicore.xnjs.incarnation.TweakerConfiguration;
import de.fzj.unicore.xnjs.jsdl.IncarnationDataBase;
import de.fzj.unicore.xnjs.management.Lifecycle;
import de.fzj.unicore.xnjs.tsi.ApplicationInfo;
import de.fzj.unicore.xnjs.util.LogUtil;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.support.StandardEvaluationContext;

@Lifecycle(isSingleton=true)
public class IncarnationTweaker
implements ITweaker {
    public static final String INCARNATION_TWEAKER_CONFIG_KEY = "XNJS.incarnationTweakerConfig";
    private static final Logger log = LogUtil.getLogger("unicore.xnjs", IncarnationTweaker.class);
    private boolean enabled = false;
    private TweakerConfiguration config;

    public IncarnationTweaker(Configuration xnjsConfiguration) {
        String configFile = xnjsConfiguration.getProperty(INCARNATION_TWEAKER_CONFIG_KEY);
        if (configFile == null || configFile.equals("")) {
            return;
        }
        try {
            this.config = new TweakerConfiguration(configFile, xnjsConfiguration.getScheduledExecutor());
        }
        catch (Exception e) {
            log.error((Object)("Can not load configuration of the incarnation tweaking subsystem, it WILL BE DISABLED. Cause: " + e.getMessage()), (Throwable)e);
            return;
        }
        this.enabled = true;
    }

    @Override
    public void preScript(ApplicationInfo appDescription, Action job, IncarnationDataBase idb) throws ExecutionException {
        if (!this.enabled) {
            return;
        }
        RootCtxBean root = new RootCtxBean(appDescription, job, idb);
        IncarnationTweaker.preScriptInternal(root, this.config.getBeforeRules(), new ErrorHolder());
    }

    static void preScriptInternal(RootCtxBean root, RulesContainer<BeforeAction> rulesC, ErrorHolder eh) throws ExecutionException {
        StandardEvaluationContext ctx = new StandardEvaluationContext((Object)root);
        List<Rule<BeforeAction>> rules = rulesC.getRulesList();
        int i = 0;
        for (Rule<BeforeAction> r : rules) {
            if (!IncarnationTweaker.checkCondition(r.getCondition(), ctx, ++i, "before", eh)) continue;
            List<BeforeAction> actions = r.getActions();
            int j = 0;
            for (BeforeAction action : actions) {
                ++j;
                try {
                    action.invoke(root);
                }
                catch (ExecutionException ee) {
                    throw ee;
                }
                catch (Exception e) {
                    log.error((Object)("Invocation of an action " + j + " of the before script rule " + i + " thrown an error: " + e + ". This error is ignored and processing is continued."), (Throwable)e);
                    eh.setError(true);
                }
            }
            if (!r.isFinishOnHit()) continue;
            break;
        }
    }

    @Override
    public String postScript(ApplicationInfo appDescription, Action job, IncarnationDataBase idb, String script) throws ExecutionException {
        if (!this.enabled) {
            return script;
        }
        RootCtxBean root = new RootCtxBean(appDescription, job, idb);
        return IncarnationTweaker.postScriptInternal(root, script, this.config.getAfterRules(), new ErrorHolder());
    }

    static String postScriptInternal(RootCtxBean root, String script, RulesContainer<AfterAction> rulesC, ErrorHolder eh) throws ExecutionException {
        StandardEvaluationContext ctx = new StandardEvaluationContext((Object)root);
        List<Rule<AfterAction>> rules = rulesC.getRulesList();
        int i = 0;
        for (Rule<AfterAction> r : rules) {
            if (!IncarnationTweaker.checkCondition(r.getCondition(), ctx, ++i, "after", eh)) continue;
            List<AfterAction> actions = r.getActions();
            int j = 0;
            for (AfterAction action : actions) {
                ++j;
                try {
                    String filtered;
                    log.debug((Object)("Will filter the original TSI script:\n" + script));
                    script = filtered = action.filter(root, script);
                    log.debug((Object)("Replaced original script with:\n" + script));
                }
                catch (ExecutionException ee) {
                    throw ee;
                }
                catch (Exception e) {
                    log.error((Object)("Invocation of an action " + j + " of the after-script rule " + i + " thrown an error: " + e + ". This error is ignored and processing is continued."), (Throwable)e);
                    eh.setError(true);
                }
            }
            if (!r.isFinishOnHit()) continue;
            break;
        }
        return script;
    }

    private static boolean checkCondition(Expression condition, StandardEvaluationContext ctx, int i, String info, ErrorHolder eh) {
        Object condResult;
        try {
            condResult = condition.getValue((EvaluationContext)ctx);
        }
        catch (Exception e) {
            log.error((Object)("Skipping the " + info + "-script rule number " + i + " as evaluation of its condition finished with " + "an error: " + e.toString()), (Throwable)e);
            eh.setError(true);
            return false;
        }
        if (!(condResult instanceof Boolean) || condResult == null) {
            log.error((Object)("Skipping the " + info + "-script rule number " + i + " as evaluation of its condition finished with " + "a non boolean result. Result type is: " + condResult == null ? "null" : condResult.getClass().getName()));
            eh.setError(true);
            return false;
        }
        boolean result = (Boolean)condResult;
        if (log.isDebugEnabled()) {
            log.debug((Object)(info + "-script rule number " + i + " condition returned " + result));
        }
        return result;
    }

    static class ErrorHolder {
        private boolean error = false;

        ErrorHolder() {
        }

        public void setError(boolean error) {
            this.error = error;
        }

        public boolean isError() {
            return this.error;
        }
    }
}

