/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.incarnation;

import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.incarnation.Action;
import de.fzj.unicore.xnjs.incarnation.GroovyFilter;
import de.fzj.unicore.xnjs.incarnation.RootCtxBean;
import de.fzj.unicore.xnjs.util.LogUtil;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.log4j.Logger;

public class GroovyActionBase
implements Action {
    private static Logger log = LogUtil.getLogger("unicore.xnjs", GroovyFilter.class);
    protected String groovyScript;
    protected PropertyDescriptor[] properties;

    public GroovyActionBase(String groovyScript) {
        BeanInfo bi;
        this.groovyScript = groovyScript;
        try {
            bi = Introspector.getBeanInfo(RootCtxBean.class);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
        this.properties = bi.getPropertyDescriptors();
    }

    protected void fillContext(RootCtxBean rootCtx, ScriptEngine engine) {
        for (PropertyDescriptor property : this.properties) {
            try {
                Object o = property.getReadMethod().invoke((Object)rootCtx, new Object[0]);
                engine.put(property.getName(), o);
            }
            catch (Exception e) {
                log.error((Object)("BUG: can't set property " + property.getName() + " for groovy script evaluation"), (Throwable)e);
            }
        }
    }

    protected void handleException(ScriptException se) throws ScriptException, ExecutionException {
        Throwable cause;
        for (cause = se.getCause(); cause != null && cause instanceof ScriptException; cause = cause.getCause()) {
        }
        if (cause == null) {
            throw se;
        }
        if (cause instanceof ExecutionException) {
            throw (ExecutionException)cause;
        }
        throw se;
    }

    @Override
    public String getActionDefinition() {
        return this.groovyScript;
    }
}

