/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.ems.processors;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.ems.processors.DefaultProcessor;
import de.fzj.unicore.xnjs.util.LogUtil;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Logger;

public class UsageLogger
extends DefaultProcessor {
    private static final Logger usage = LogUtil.getLogger("unicore.services.jobexecution", "USAGE");
    private static final Logger logger = LogUtil.getLogger("unicore.services.jobexecution", UsageLogger.class);
    static final String USAGE_LOGGED = "USAGE.logged";
    public static final String XNJS_TSI_MACHINE_NAME_PROP = "CLASSICTSI.machine";
    public static final String REAL_BSS_MACHINE_NAME_PROP = "RUS.bssMachine";

    public UsageLogger(Configuration config) {
        super(config);
    }

    @Override
    protected void done() {
        if (this.action.getStatus() != 7) {
            return;
        }
        try {
            Boolean haveLogged = (Boolean)this.action.getProcessingContext().get(USAGE_LOGGED);
            if (haveLogged == null) {
                usage.info((Object)this.getUsage());
                this.action.getProcessingContext().put(USAGE_LOGGED, Boolean.TRUE);
                this.action.setDirty();
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Error when logging usage.", (Throwable)ex);
        }
    }

    protected String getUsage() {
        StringBuilder sb = new StringBuilder();
        String uuid = this.action.getUUID();
        String client = this.action.getClient().getDistinguishedName();
        try {
            client = new X500Principal(client).toString();
        }
        catch (Exception ex) {
            // empty catch block
        }
        String result = this.action.getResult().toString();
        String exec = this.action.getExecutionContext() != null ? this.action.getExecutionContext().getExecutable() : "";
        if (exec == null) {
            exec = "n/a";
        }
        String bsid = this.action.getBSID();
        String localUserName = this.action.getClient().getSelectedXloginName();
        String jobName = this.action.getJobName();
        String machineName = this.configuration.getProperty(REAL_BSS_MACHINE_NAME_PROP);
        if (machineName == null) {
            machineName = this.configuration.getProperty(XNJS_TSI_MACHINE_NAME_PROP);
        }
        String vo = null;
        if (this.action.getClient() != null && this.action.getClient().getVos() != null && this.action.getClient().getVos().length > 0) {
            int i;
            String[] vos = this.action.getClient().getVos();
            StringBuilder vosb = new StringBuilder();
            for (i = 0; i < vos.length - 1; ++i) {
                vosb.append(vos[i]);
                vosb.append(",");
            }
            if (i < vos.length) {
                vosb.append(vos[i]);
            }
            vo = vosb.toString();
        }
        if (bsid == null) {
            bsid = "";
        }
        if (localUserName == null) {
            localUserName = "";
        }
        if (jobName == null) {
            jobName = "";
        }
        if (machineName == null) {
            machineName = "";
        }
        if (vo == null) {
            vo = "";
        }
        sb.append("[").append(UsageLogger.escapeBrackets(result)).append("] [ ");
        sb.append(UsageLogger.escapeBrackets(exec)).append("] [ ");
        sb.append(UsageLogger.escapeBrackets(uuid)).append("] [");
        sb.append(UsageLogger.escapeBrackets(client)).append("] [");
        sb.append(UsageLogger.escapeBrackets(bsid));
        sb.append("] [").append(UsageLogger.escapeBrackets(localUserName));
        sb.append("] [").append(UsageLogger.escapeBrackets(jobName));
        sb.append("] [").append(UsageLogger.escapeBrackets(machineName));
        sb.append("] [").append(UsageLogger.escapeBrackets(vo));
        sb.append("]");
        return sb.toString();
    }

    private static String escapeBrackets(String input) {
        String ret1 = input.replace("\\", "\\\\");
        String ret = ret1.replace("]", "\\]");
        return ret;
    }
}

