/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.ems.processors;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.ems.ProcessingException;
import de.fzj.unicore.xnjs.ems.processors.DefaultProcessor;

public class LogProcessingTimeProcessor
extends DefaultProcessor {
    static final String startTimeKey = LogProcessingTimeProcessor.class.getName() + "_starttime";

    public LogProcessingTimeProcessor(Configuration config) {
        super(config);
    }

    @Override
    protected void begin() throws ProcessingException {
        if (this.action.getProcessingContext().get(startTimeKey) != null) {
            return;
        }
        Long startTime = System.currentTimeMillis();
        this.action.getProcessingContext().put(startTimeKey, startTime);
        this.action.setDirty();
    }

    @Override
    protected void done() throws ProcessingException {
        if (this.action.getStatus() == 7) {
            String msg = this.buildLogEntry();
            logger.info((Object)msg);
            this.action.addLogTrace(msg);
        }
    }

    protected String buildLogEntry() {
        StringBuilder sb = new StringBuilder();
        Long startTime = (Long)this.action.getProcessingContext().get(startTimeKey);
        long endTime = System.currentTimeMillis();
        long time = endTime - startTime;
        sb.append("TIMER: Processed [").append(this.action.getUUID());
        sb.append("] of type [").append(this.action.getType());
        sb.append("] in ").append(time).append(" ms.");
        return sb.toString();
    }
}

