/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.ems.processors;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.XNJSException;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.ems.IProcessorFactory;
import de.fzj.unicore.xnjs.ems.Processor;
import java.lang.reflect.Constructor;

public class DefaultProcessorFactory
implements IProcessorFactory {
    private final Configuration configuration;

    public DefaultProcessorFactory(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public Processor getProcessor(String actionType) throws ExecutionException {
        try {
            String[] chain = this.configuration.getProcessorChain(actionType);
            Processor[] ps = new Processor[chain.length];
            for (int i = 0; i < chain.length; ++i) {
                ps[i] = this.createInstance(chain[i]);
                if (i <= 0) continue;
                ps[i - 1].setNext(ps[i]);
            }
            return ps[0];
        }
        catch (Exception e) {
            throw new ExecutionException("Can't create processor for action type <" + actionType + ">", e);
        }
    }

    protected Processor createInstance(String classname) throws Exception {
        Class<?> pClass = Class.forName(classname);
        try {
            Constructor<?> c = pClass.getConstructor(Configuration.class);
            return (Processor)c.newInstance(this.configuration);
        }
        catch (IllegalArgumentException e) {
            throw new XNJSException("Processor class " + classname + " needs appropriate constructor.");
        }
    }
}

