/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.ems.processors;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.ems.Action;
import de.fzj.unicore.xnjs.ems.ActionResult;
import de.fzj.unicore.xnjs.ems.ProcessingException;
import de.fzj.unicore.xnjs.ems.Processor;
import de.fzj.unicore.xnjs.ems.event.ContinueProcessingEvent;
import de.fzj.unicore.xnjs.util.LogUtil;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class DefaultProcessor
extends Processor {
    protected static final Logger logger = LogUtil.getLogger("unicore.xnjs", DefaultProcessor.class);
    protected static final String KEY_FS_CHECKED_FLAG = "FILE_SYSTEM_CHECKED";
    protected static final String KEY_FIRST_STAGEOUT_FAILURE = "FIRST_STAGEOUT_FAILURE";
    public static final int DEFAULT_FS_TIMEOUT = 10;

    public DefaultProcessor(Configuration configuration) {
        super(configuration);
    }

    protected void handleCancelling() throws ProcessingException {
        this.action.addLogTrace("Job was cancelled by the user.");
        this.action.setStatus(7);
        this.action.setResult(new ActionResult(1, "Job was cancelled by the user."));
    }

    @Override
    protected void handleAborting() throws ProcessingException {
        this.action.addLogTrace("Job was aborted by the user.");
        this.action.setStatus(7);
        this.action.setResult(new ActionResult(1, "Job was aborted by the user."));
    }

    @Override
    protected void handlePausing() throws ProcessingException {
        this.action.setStatus(3);
    }

    @Override
    protected void handleResuming() throws ProcessingException {
        this.action.setStatus(5);
    }

    @Override
    protected void handleRemoving() throws ProcessingException {
        try {
            this.configuration.getExecutionContextMgr().destroyUSpace(this.action);
            if (this.action.getStatus() != 8) {
                this.action.setStatus(8);
                this.action.setResult(new ActionResult(1));
            }
        }
        catch (Exception e) {
            throw new ProcessingException(e);
        }
        finally {
            this.action.setTransitionalStatus(0);
        }
    }

    @Override
    protected void handleCreated() throws ProcessingException {
    }

    @Override
    protected void handlePreProcessing() throws ProcessingException {
    }

    @Override
    protected void handleReady() throws ProcessingException {
    }

    @Override
    protected void handlePending() throws ProcessingException {
    }

    @Override
    protected void handleQueued() throws ProcessingException {
    }

    @Override
    protected void handleRunning() throws ProcessingException {
    }

    @Override
    protected void handlePostProcessing() throws ProcessingException {
    }

    @Override
    protected void begin() throws ProcessingException {
    }

    @Override
    protected void done() throws ProcessingException {
    }

    protected void setToDoneAndFailed(String reason) {
        this.action.setStatus(7);
        this.action.setResult(new ActionResult(2, reason));
    }

    protected void sleep(int millis) {
        this.action.setWaiting(true);
        this.manager.scheduleEvent(new ContinueProcessingEvent(this.action.getUUID()), millis, TimeUnit.MILLISECONDS);
    }

    protected void storeTimeStamp(String key) {
        this.action.getProcessingContext().put(key, System.currentTimeMillis());
        this.action.setDirty();
    }

    protected Long getTimeStamp(String key) {
        return (Long)this.action.getProcessingContext().get(key);
    }

    void setAction(Action a) {
        this.action = a;
    }
}

