/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.ems.processors;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.ems.ActionResult;
import de.fzj.unicore.xnjs.ems.ExecutionContext;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.ems.ProcessingException;
import de.fzj.unicore.xnjs.ems.processors.DefaultProcessor;
import de.fzj.unicore.xnjs.resources.ResourceSet;
import de.fzj.unicore.xnjs.tsi.ApplicationInfo;
import de.fzj.unicore.xnjs.tsi.IExecution;
import de.fzj.unicore.xnjs.tsi.TSI;
import de.fzj.unicore.xnjs.tsi.TSIBusyException;
import de.fzj.unicore.xnjs.util.LogUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class AsyncCommandProcessor
extends DefaultProcessor {
    private static final Logger logger = LogUtil.getLogger("unicore.services.jobexecution", AsyncCommandProcessor.class);
    private final IExecution exec;

    public AsyncCommandProcessor(Configuration c) {
        super(c);
        this.exec = this.configuration.getExecutionInterface();
    }

    @Override
    protected void handleCreated() throws ProcessingException {
        try {
            this.submit();
        }
        catch (ExecutionException e) {
            throw new ProcessingException(e);
        }
    }

    protected void submit() throws ExecutionException {
        SubCommand subCommand = (SubCommand)this.action.getAjd();
        ExecutionContext ec = this.action.getExecutionContext();
        TSI tsi = this.configuration.getTargetSystemInterface(this.action.getClient());
        if (subCommand.workingDir != null) {
            ec.setWorkingDirectory(subCommand.workingDir);
        }
        ec.setOutcomeDirectory(ec.getWorkingDirectory() + ".UNICORE_" + subCommand.id + tsi.getFileSeparator());
        tsi.mkdir(ec.getOutcomeDirectory());
        ec.setExitCodeFileName(subCommand.id + "_" + "UNICORE_SCRIPT_EXIT_CODE");
        ec.setInteractive(true);
        ec.setPIDFileName(subCommand.id + "_" + "UNICORE_SCRIPT_PID");
        ec.getEnvironment().putAll(subCommand.env);
        ec.setPreferredExecutionHost(subCommand.preferredExecutionHost);
        ec.setStderr(subCommand.stderr);
        ec.setStdout(subCommand.stdout);
        this.action.addLogTrace("Executing command: " + subCommand.cmd);
        this.action.setStatus(21);
        ApplicationInfo appInfo = this.action.getApplicationInfo();
        appInfo.setExecutable(subCommand.cmd);
        ec.setResourceRequest(new ResourceSet());
    }

    @Override
    protected void handlePending() throws ProcessingException {
        try {
            this.action.setStatus(22);
            this.exec.submit(this.action);
            this.sleep(3000);
        }
        catch (ExecutionException e) {
            throw new ProcessingException(e);
        }
        catch (TSIBusyException tbe) {
            logger.debug((Object)"Could not submit action", (Throwable)tbe);
            this.action.setWaiting(false);
        }
    }

    @Override
    protected void handleQueued() throws ProcessingException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Handling QUEUED state for Action " + this.action.getUUID()));
        }
        try {
            this.exec.updateStatus(this.action);
            if (this.action.getStatus() == 22) {
                this.sleep(3000);
            }
        }
        catch (ExecutionException ex) {
            String msg = "Could not update status: " + ex.getMessage();
            this.action.addLogTrace(msg);
            throw new ProcessingException(msg, ex);
        }
    }

    @Override
    protected void handleRunning() throws ProcessingException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Handling RUNNING state for Action " + this.action.getUUID()));
        }
        try {
            this.exec.updateStatus(this.action);
            if (this.action.getStatus() == 5) {
                this.sleep(3000);
            }
        }
        catch (ExecutionException ex) {
            String msg = "Could not update status for action " + ex.getMessage();
            this.action.addLogTrace(msg);
            throw new ProcessingException(msg, ex);
        }
    }

    @Override
    protected void handlePostProcessing() throws ProcessingException {
        this.setToSuccess();
    }

    protected void setToSuccess() {
        this.action.setStatus(7);
        this.action.setResult(new ActionResult(3));
    }

    @Override
    protected void handleRemoving() throws ProcessingException {
    }

    public static class SubCommand
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public String cmd;
        public String id;
        public String preferredExecutionHost;
        public String workingDir;
        public String stdout = "stdout";
        public String stderr = "stderr";
        public Map<String, String> env = new HashMap<String, String>();

        public String toString() {
            return "SubCommand ['" + this.cmd + "' in '" + this.workingDir + "']";
        }
    }
}

