/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.ems;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.ems.Action;
import de.fzj.unicore.xnjs.ems.InternalManager;
import de.fzj.unicore.xnjs.ems.ProcessingException;

public abstract class Processor {
    protected final Configuration configuration;
    protected Processor next;
    protected Action action;
    protected InternalManager manager;

    public Processor(Configuration configuration) {
        this.configuration = configuration;
        this.manager = configuration.getInternalManager();
    }

    public void setNext(Processor p) {
        this.next = p;
    }

    public String toString() {
        String nextName = "";
        if (this.next != null) {
            nextName = "->" + this.next.toString();
        }
        return this.getClass().getName() + "@" + this.hashCode() + nextName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void process(Action a) throws ProcessingException {
        this.action = a;
        this.begin();
        if (a.getTransitionalStatus() != 0) {
            try {
                this.processTransition(this.action);
            }
            finally {
                a.setTransitionalStatus(0);
            }
        }
        switch (this.action.getStatus()) {
            case 7: {
                break;
            }
            case 0: {
                this.handleCreated();
                break;
            }
            case 1: {
                this.handlePreProcessing();
                break;
            }
            case 2: {
                this.handleReady();
                break;
            }
            case 21: {
                this.handlePending();
                break;
            }
            case 22: {
                this.handleQueued();
                break;
            }
            case 5: {
                this.handleRunning();
                break;
            }
            case 6: {
                this.handlePostProcessing();
                break;
            }
        }
        this.done();
        if (this.next != null) {
            this.next.process(this.action);
        }
    }

    final void processTransition(Action a) throws ProcessingException {
        this.action = a;
        switch (this.action.getTransitionalStatus()) {
            case 2: {
                this.handleAborting();
                break;
            }
            case 3: {
                this.handlePausing();
                break;
            }
            case 4: {
                this.handleResuming();
                break;
            }
            case 5: {
                this.handleRemoving();
            }
        }
        if (this.next != null) {
            this.next.processTransition(this.action);
        }
    }

    protected abstract void begin() throws ProcessingException;

    protected abstract void done() throws ProcessingException;

    protected abstract void handleCreated() throws ProcessingException;

    protected abstract void handlePreProcessing() throws ProcessingException;

    protected abstract void handleReady() throws ProcessingException;

    protected abstract void handlePending() throws ProcessingException;

    protected abstract void handleQueued() throws ProcessingException;

    protected abstract void handleRunning() throws ProcessingException;

    protected abstract void handlePostProcessing() throws ProcessingException;

    protected abstract void handleAborting() throws ProcessingException;

    protected abstract void handlePausing() throws ProcessingException;

    protected abstract void handleResuming() throws ProcessingException;

    protected abstract void handleRemoving() throws ProcessingException;
}

