/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.ems;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.ems.Action;
import de.fzj.unicore.xnjs.ems.ActionStatus;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.ems.InternalManager;
import de.fzj.unicore.xnjs.ems.ProcessingException;
import de.fzj.unicore.xnjs.ems.Processor;
import de.fzj.unicore.xnjs.ems.SubAction;
import de.fzj.unicore.xnjs.ems.event.ContinueProcessingEvent;
import de.fzj.unicore.xnjs.util.LogUtil;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class JobRunner
extends Thread {
    private static final Logger logger = LogUtil.getLogger("unicore.xnjs", JobRunner.class);
    private final Configuration configuration;
    private final InternalManager mgr;
    volatile boolean isInterrupted = false;
    private static AtomicInteger count = new AtomicInteger(0);

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration config) {
        throw new IllegalStateException("Can't modify the configuration");
    }

    public JobRunner(Configuration config) {
        this.configuration = config;
        int n = count.incrementAndGet();
        super.setName("XNJS-" + this.configuration.getID() + "-JobRunner-" + n);
        this.mgr = this.configuration.getInternalManager();
        logger.debug((Object)("Job runner thread " + n + " starting"));
    }

    @Override
    public void interrupt() {
        this.isInterrupted = true;
        logger.debug((Object)(this.getName() + " stopping"));
        count.decrementAndGet();
        super.interrupt();
    }

    @Override
    public void run() {
        logger.info((Object)("Worker " + this.getName() + " starting."));
        try {
            while (this.configuration.isStopped() && !this.isInterrupted) {
                Thread.sleep(500L);
            }
            while (!this.isInterrupted && !this.configuration.isStopped()) {
                while (this.mgr.isPaused()) {
                    Thread.sleep(300L);
                }
                Action a = null;
                try {
                    a = this.mgr.getNextActionForProcessing();
                }
                catch (ExecutionException eex) {
                    logger.warn((Object)"Can't get action for processing", (Throwable)eex);
                }
                if (a == null) continue;
                if (this.check(a)) {
                    this.process(a);
                    continue;
                }
                this.sendToSleep(a);
            }
        }
        catch (InterruptedException ie) {
            logger.info((Object)(this.getName() + " stopped."));
            return;
        }
    }

    private boolean check(Action a) {
        return a.getNotBefore() - System.currentTimeMillis() < 0L;
    }

    private void sendToSleep(Action a) {
        a.setWaiting(true);
        long delay = a.getNotBefore() - System.currentTimeMillis();
        if (delay <= 0L) {
            delay = 5000L;
        }
        this.mgr.scheduleEvent(new ContinueProcessingEvent(a.getUUID()), (int)delay, TimeUnit.MILLISECONDS);
        this.mgr.doneProcessing(a, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(Action a) {
        block18: {
            int status = a.getStatus();
            try {
                SubAction s;
                LogUtil.fillLogContext(a);
                Processor p = this.getConfiguration().createProcessor(a.getType());
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Processing Action <" + a.getUUID() + "> in status " + ActionStatus.toString(a.getStatus())));
                }
                p.process(a);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("New status for Action <" + a.getUUID() + ">: " + ActionStatus.toString(a.getStatus())));
                }
                int newStatus = a.getStatus();
                this.mgr.doneProcessing(a, true);
                if (newStatus == status) break block18;
                try {
                    this.mgr.stateChanged(a.getUUID(), newStatus);
                }
                catch (Exception ex2) {
                    logger.warn((Object)"Internal error during state change notification.", (Throwable)ex2);
                }
                if (newStatus == 7 && a instanceof SubAction && (s = (SubAction)a).isNotifyDone()) {
                    try {
                        String parent = s.getParentID();
                        this.mgr.handleEvent(new ContinueProcessingEvent(parent));
                    }
                    catch (Exception ex) {
                        logger.error((Object)"Error sending notification", (Throwable)ex);
                    }
                }
            }
            catch (ProcessingException pe) {
                logger.error((Object)("Error during processing action <" + a.getUUID() + ">"), (Throwable)pe);
                try {
                    this.mgr.errorProcessing(a, pe);
                }
                catch (Exception ex) {
                    logger.error((Object)("Error during error reporting for action <" + a.getUUID() + ">"), (Throwable)ex);
                }
            }
            catch (Throwable t) {
                logger.error((Object)("Severe error during processing action <" + a.getUUID() + ">"), t);
                try {
                    this.mgr.errorProcessing(a, t);
                }
                catch (Exception ex) {
                    logger.error((Object)("Error during error reporting for action <" + a.getUUID() + ">"), (Throwable)ex);
                }
            }
            finally {
                LogUtil.clearLogContext();
            }
        }
    }
}

