/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.ems;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.ems.Action;
import de.fzj.unicore.xnjs.ems.ActionResult;
import de.fzj.unicore.xnjs.ems.ActionStatus;
import de.fzj.unicore.xnjs.ems.ApplicationExecutionStatus;
import de.fzj.unicore.xnjs.ems.EMSStatistics;
import de.fzj.unicore.xnjs.ems.ExecutionContext;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.ems.IExecutionContextManager;
import de.fzj.unicore.xnjs.ems.ProcessingException;
import de.fzj.unicore.xnjs.ems.event.ContinueProcessingEvent;
import de.fzj.unicore.xnjs.ems.processors.AsyncCommandProcessor;
import de.fzj.unicore.xnjs.ems.processors.DefaultProcessor;
import de.fzj.unicore.xnjs.incarnation.TweakerExecutionException;
import de.fzj.unicore.xnjs.io.DataStageInInfo;
import de.fzj.unicore.xnjs.io.DataStageOutInfo;
import de.fzj.unicore.xnjs.jsdl.IncarnatedExecutionEnvironment;
import de.fzj.unicore.xnjs.tsi.ApplicationInfo;
import de.fzj.unicore.xnjs.tsi.IExecution;
import de.fzj.unicore.xnjs.tsi.TSI;
import de.fzj.unicore.xnjs.tsi.TSIBusyException;
import de.fzj.unicore.xnjs.util.LogUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public abstract class JobProcessor<T>
extends DefaultProcessor {
    private static final Logger logger = LogUtil.getLogger("unicore.services.jobexecution", JobProcessor.class);
    protected static final String subactionkey_in = "JSDL_de.fzj.unicore.xnjs.jsdl.JSDLProcessor_SUBACTION_STAGEIN";
    public static final String KEY_DELETEONTERMINATION = "JSDL_DELETEFILES";
    protected static final String subactionkey_out = "JSDL_de.fzj.unicore.xnjs.jsdl.JSDLProcessor_SUBACTION_STAGEOUT";
    protected static final String subactionkey_pre = "JSDL_de.fzj.unicore.xnjs.jsdl.JSDLProcessor_SUBACTION_PRECOMMAND";
    protected static final String subactionkey_post = "JSDL_de.fzj.unicore.xnjs.jsdl.JSDLProcessor_SUBACTION_POSTCOMMAND";
    private static final String BSS_SUBMIT_COUNT = "JSDL_de.fzj.unicore.xnjs.jsdl.JSDLProcessor_BSSSUBMITCOUNT";
    private static final String STARTTIME = "JSDL_de.fzj.unicore.xnjs.jsdl.JSDLProcessor_START";
    private static final String ENDSTAGEIN = "JSDL_de.fzj.unicore.xnjs.jsdl.JSDLProcessor_ENDSTAGEIN";
    private static final String SUBMITTED = "JSDL_de.fzj.unicore.xnjs.jsdl.JSDLProcessor_SUBMITTED";
    private static final String START_RUNNING = "JSDL_de.fzj.unicore.xnjs.jsdl.JSDLProcessor_START_RUNNING";
    private static final String STARTSTAGEOUT = "JSDL_de.fzj.unicore.xnjs.jsdl.JSDLProcessor_STARTSTAGEOUT";
    private static final String ENDTIME = "JSDL_de.fzj.unicore.xnjs.jsdl.JSDLProcessor_END";
    protected final IExecution exec;
    protected final IExecutionContextManager ecm;

    public JobProcessor(Configuration config) {
        super(config);
        this.exec = this.configuration.getExecutionInterface();
        this.ecm = this.configuration.getExecutionContextMgr();
    }

    @Override
    protected void begin() throws ProcessingException {
        super.begin();
    }

    protected final T getJobDescriptionDocument() {
        return (T)this.action.getAjd();
    }

    protected abstract boolean isEmptyJob();

    protected abstract String getJobName();

    protected abstract boolean hasStageIn();

    protected abstract boolean hasStageOut();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void handleCreated() throws ProcessingException {
        try {
            if (this.isEmptyJob()) {
                String msg = "Empty job description. Setting to DONE.";
                this.action.addLogTrace(msg);
                this.setToDoneSuccessfully();
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Job name: " + this.getJobName()));
            }
            this.storeTimeStamp(STARTTIME);
            try {
                this.extractFromJSDL();
            }
            catch (Exception ee) {
                throw new ProcessingException(ee);
            }
            if (!this.hasStageIn()) {
                this.action.addLogTrace("No staging in needed.");
                this.setToReady();
                this.storeTimeStamp(ENDSTAGEIN);
                return;
            }
            this.action.setStatus(1);
            this.action.addLogTrace("Status set to PREPROCESSING (staging in).");
            if (this.configuration.haveProcessingFor("JSDL_STAGEIN")) {
                this.addStageIn();
                this.action.setWaiting(true);
                return;
            }
            this.action.addLogTrace("Staging in not done (no processing configured).");
            this.setToReady();
            return;
        }
        catch (Exception ex) {
            String msg = "Error processing action " + ex.getMessage();
            this.action.addLogTrace(msg);
            throw new ProcessingException(msg, ex);
        }
    }

    @Override
    protected void handlePreProcessing() throws ProcessingException {
        try {
            String stageInActionID = (String)this.action.getProcessingContext().get(subactionkey_in);
            if (stageInActionID != null) {
                this.handleStagingIn(stageInActionID);
            }
        }
        catch (Exception ex) {
            LogUtil.logException("Error processing stage-in.", ex, logger);
            String reason = LogUtil.createFaultMessage("Error processing stage-in.", ex);
            this.setToDoneAndFailed(reason);
        }
    }

    protected void handleStagingIn(String id) throws ExecutionException, ProcessingException {
        String err = this.checkSubAction(subactionkey_in, "Stage in");
        if (err != null) {
            this.setToDoneAndFailed(err);
        } else if (!this.action.isWaiting()) {
            Action subAction = this.manager.getAction(id);
            this.storeTimeStamp(ENDSTAGEIN);
            List files = (List)subAction.getProcessingContext().get(KEY_DELETEONTERMINATION);
            this.action.getProcessingContext().put(KEY_DELETEONTERMINATION, files);
            this.configuration.getEMSManager().destroy(id, this.action.getClient());
            this.setToReady();
        }
    }

    protected void setToReady() {
        this.action.setStatus(2);
        this.action.addLogTrace("Status set to READY.");
    }

    @Override
    protected void handleReady() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Handling READY state for Action " + this.action.getUUID()));
        }
        this.extractNotBefore();
        if (this.configuration.isAutoSubmitToBSS()) {
            this.goToPending();
        } else {
            if (this.action.getProcessingContext().get("EMS_AUTOSUBMIT") == null) {
                this.action.setWaiting(true);
                return;
            }
            this.goToPending();
        }
    }

    protected void goToPending() {
        this.action.setStatus(21);
        this.action.addLogTrace("Status set to PENDING.");
    }

    @Override
    protected void handlePending() throws ProcessingException {
        ApplicationExecutionStatus aes;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Handling PENDING state for Action " + this.action.getUUID()));
        }
        if ((aes = this.action.getProcessingContext().get(ApplicationExecutionStatus.class)) == null) {
            aes = new ApplicationExecutionStatus();
            this.action.getProcessingContext().set(aes);
            this.action.setDirty();
        }
        switch (aes.get()) {
            case 0: {
                this.setupPreCommand();
                break;
            }
            case 1: {
                this.handlePreCommandRunning();
                break;
            }
            case 2: {
                this.submitMainExecutable();
                break;
            }
            default: {
                throw new IllegalStateException("Illegal precommand state <+" + aes.get() + "> in PENDING.");
            }
        }
    }

    protected void setupPreCommand() throws ProcessingException {
        try {
            IncarnatedExecutionEnvironment ee = this.action.getExecutionEnvironment();
            boolean done = true;
            if (ee != null) {
                if (ee.getUserPreCommand() != null && ee.isRunUserPreCommandOnLoginNode()) {
                    done = false;
                    String userPre = ee.getUserPreCommand();
                    AsyncCommandProcessor.SubCommand cmd = new AsyncCommandProcessor.SubCommand();
                    cmd.id = "PRE";
                    cmd.cmd = userPre;
                    cmd.workingDir = this.action.getExecutionContext().getWorkingDirectory();
                    String subID = this.createPrePostAction(cmd);
                    this.action.getProcessingContext().put(subactionkey_pre, subID);
                }
                for (int i = 0; i < ee.getPreCommands().size(); ++i) {
                    if (!ee.isRunPreCommandOnLoginNode(i)) continue;
                    done = false;
                    String cmdString = ee.getPreCommands().get(i);
                    AsyncCommandProcessor.SubCommand cmd = new AsyncCommandProcessor.SubCommand();
                    cmd.id = "PRE";
                    cmd.cmd = cmdString;
                    cmd.workingDir = this.action.getExecutionContext().getWorkingDirectory();
                    String subID = this.createPrePostAction(cmd);
                    this.action.getProcessingContext().put(subactionkey_pre, subID);
                }
            }
            if (done) {
                this.action.getProcessingContext().set(ApplicationExecutionStatus.precommandDone());
            } else {
                this.action.getProcessingContext().set(ApplicationExecutionStatus.precommandRunning());
            }
            this.action.setDirty();
        }
        catch (Exception ex) {
            String msg = "Could not setup pre-command: " + ex.getMessage();
            this.action.addLogTrace(msg);
            this.setToDoneAndFailed(msg);
            throw new ProcessingException(msg, ex);
        }
    }

    protected void handlePreCommandRunning() throws ProcessingException {
        try {
            String id = (String)this.action.getProcessingContext().get(subactionkey_pre);
            String err = this.checkSubAction(subactionkey_pre, "Pre-commands");
            if (err != null) {
                this.setToDoneAndFailed(err);
                this.configuration.getEMSManager().destroy(id, this.action.getClient());
            } else if (!this.action.isWaiting()) {
                this.action.getProcessingContext().set(ApplicationExecutionStatus.precommandDone());
                this.configuration.getEMSManager().destroy(id, this.action.getClient());
            }
        }
        catch (ExecutionException ee) {
            throw new ProcessingException(ee);
        }
    }

    protected void setupPostCommand() throws ProcessingException {
        try {
            IncarnatedExecutionEnvironment ee = this.action.getExecutionEnvironment();
            boolean done = true;
            if (ee != null) {
                if (ee.getUserPostCommand() != null && ee.isRunUserPostCommandOnLoginNode()) {
                    done = false;
                    String userPost = ee.getUserPostCommand();
                    AsyncCommandProcessor.SubCommand cmd = new AsyncCommandProcessor.SubCommand();
                    cmd.id = "POST";
                    cmd.cmd = userPost;
                    cmd.workingDir = this.action.getExecutionContext().getWorkingDirectory();
                    String subID = this.createPrePostAction(cmd);
                    this.action.getProcessingContext().put(subactionkey_post, subID);
                }
                for (int i = 0; i < ee.getPostCommands().size(); ++i) {
                    if (!ee.isRunPostCommandOnLoginNode(i)) continue;
                    done = false;
                    String cmdString = ee.getPostCommands().get(i);
                    AsyncCommandProcessor.SubCommand cmd = new AsyncCommandProcessor.SubCommand();
                    cmd.id = "POST";
                    cmd.cmd = cmdString;
                    cmd.workingDir = this.action.getExecutionContext().getWorkingDirectory();
                    String subID = this.createPrePostAction(cmd);
                    this.action.getProcessingContext().put(subactionkey_post, subID);
                }
            }
            if (done) {
                this.action.getProcessingContext().set(ApplicationExecutionStatus.done());
            } else {
                this.action.getProcessingContext().set(ApplicationExecutionStatus.postcommandRunning());
            }
            this.action.setDirty();
        }
        catch (Exception ex) {
            String msg = "Could not setup post-command: " + ex.getMessage();
            this.action.addLogTrace(msg);
            this.setToDoneAndFailed(msg);
            throw new ProcessingException(msg, ex);
        }
    }

    protected void handlePostCommandRunning() throws ProcessingException {
        try {
            String id = (String)this.action.getProcessingContext().get(subactionkey_post);
            String err = this.checkSubAction(subactionkey_post, "Post-commands");
            if (err != null) {
                this.setToDoneAndFailed(err);
                this.configuration.getEMSManager().destroy(id, this.action.getClient());
            } else if (!this.action.isWaiting()) {
                this.action.getProcessingContext().set(ApplicationExecutionStatus.done());
                this.configuration.getEMSManager().destroy(id, this.action.getClient());
            }
        }
        catch (ExecutionException ee) {
            throw new ProcessingException(ee);
        }
    }

    protected String createPrePostAction(AsyncCommandProcessor.SubCommand cmd) throws ExecutionException {
        return this.manager.addSubAction(cmd, "ASYNC_COMMAND", this.action, true);
    }

    protected void submitMainExecutable() throws ProcessingException {
        try {
            ApplicationInfo appInfo = this.action.getApplicationInfo();
            if (appInfo == null || appInfo.getExecutable() == null) {
                this.action.addLogTrace("No application to execute, changing action status to POSTPROCESSING");
                this.action.setStatus(6);
                return;
            }
            this.action.setWaiting(true);
            this.exec.submit(this.action);
            ApplicationExecutionStatus aes = this.action.getProcessingContext().get(ApplicationExecutionStatus.class);
            aes.set(50);
            this.action.setStatus(22);
            this.storeTimeStamp(SUBMITTED);
        }
        catch (TweakerExecutionException tex) {
            String msg = "Could not submit job: " + tex.getMessage();
            this.action.addLogTrace(msg);
            this.setToDoneAndFailed(msg);
            throw new ProcessingException(msg, tex);
        }
        catch (ExecutionException ex) {
            String msg = "Could not submit job: " + ex.getMessage();
            Integer submitCount = (Integer)this.action.getProcessingContext().get(BSS_SUBMIT_COUNT);
            if (submitCount == null) {
                submitCount = new Integer(0);
            }
            Integer n = submitCount;
            Integer n2 = submitCount = Integer.valueOf(submitCount + 1);
            this.action.getProcessingContext().put(BSS_SUBMIT_COUNT, submitCount);
            int maxSubmitCount = this.configuration.getBSSResubmissionCount();
            if (submitCount > maxSubmitCount) {
                this.action.addLogTrace(msg);
                this.setToDoneAndFailed(msg);
                throw new ProcessingException(msg, ex);
            }
            this.action.addLogTrace("Submit attempt " + submitCount + " (of " + maxSubmitCount + ") failed: " + ex.getMessage());
            this.action.printLogTrace();
            this.pauseExecution(this.configuration.getBSSResubmissionDelay(), TimeUnit.SECONDS);
        }
        catch (TSIBusyException tbe) {
            this.action.setWaiting(false);
        }
    }

    @Override
    protected void handleQueued() throws ProcessingException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Handling QUEUED state for Action " + this.action.getUUID()));
        }
        try {
            this.exec.updateStatus(this.action);
            if (this.action.getStatus() == 22) {
                this.action.setWaiting(true);
            }
        }
        catch (ExecutionException ex) {
            String msg = "Could not update status: " + ex.getMessage();
            this.action.addLogTrace(msg);
            throw new ProcessingException(msg, ex);
        }
    }

    @Override
    protected void handleRunning() throws ProcessingException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Handling RUNNING state for Action " + this.action.getUUID()));
        }
        if (this.getTimeStamp(START_RUNNING) == null) {
            this.storeTimeStamp(START_RUNNING);
        }
        try {
            this.exec.updateStatus(this.action);
            if (this.action.getStatus() == 5) {
                this.action.setWaiting(true);
            }
        }
        catch (ExecutionException ex) {
            String msg = "Could not update status for action " + ex.getMessage();
            this.action.addLogTrace(msg);
            throw new ProcessingException(msg, ex);
        }
    }

    @Override
    protected void handlePostProcessing() throws ProcessingException {
        ApplicationExecutionStatus aes = this.action.getProcessingContext().get(ApplicationExecutionStatus.class);
        switch (aes.get()) {
            case 0: 
            case 2: 
            case 50: 
            case 51: {
                this.setupPostCommand();
                break;
            }
            case 70: {
                this.handlePostCommandRunning();
                break;
            }
            case 99: {
                if (!this.fileSystemReadyBeforeStageout()) break;
                this.handleStageOut();
                break;
            }
            default: {
                throw new IllegalStateException("Illegal state: POSTPROCESSING with substate " + aes);
            }
        }
    }

    protected boolean fileSystemReadyBeforeStageout() {
        long timeout;
        String err;
        List<DataStageOutInfo> stageOuts = this.action.getStageOuts();
        if (stageOuts == null || stageOuts.size() == 0) {
            return true;
        }
        ApplicationInfo appInfo = this.action.getApplicationInfo();
        if (appInfo == null) {
            return true;
        }
        Object fsCheckedFlag = this.action.getProcessingContext().get("FILE_SYSTEM_CHECKED");
        if (fsCheckedFlag != null) {
            return true;
        }
        String uspace = this.action.getExecutionContext().getWorkingDirectory();
        TSI tsi = this.configuration.getTargetSystemInterface(this.action.getClient());
        HashSet<String> toCheck = new HashSet<String>();
        String fileSep = "/";
        try {
            fileSep = tsi.getFileSeparator();
            for (DataStageOutInfo dst : stageOuts) {
                try {
                    String workingDirectory = uspace;
                    String fsName = dst.getFileSystemName();
                    if (fsName != null) {
                        String fs = this.configuration.getIDB().getFilespace(fsName);
                        if (fs == null) continue;
                        workingDirectory = tsi.resolve(fs);
                    }
                    toCheck.add(workingDirectory + fileSep + dst.getFileName());
                }
                catch (Exception e) {}
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Unable to list stage-outs " + e.getMessage()), (Throwable)e);
        }
        String out = appInfo.getStdout();
        if (out != null) {
            toCheck.add(uspace + fileSep + out);
        }
        if ((err = appInfo.getStderr()) != null) {
            toCheck.add(uspace + fileSep + err);
        }
        if (toCheck.isEmpty()) {
            this.action.getProcessingContext().put("FILE_SYSTEM_CHECKED", Boolean.TRUE);
            this.action.setDirty();
            return true;
        }
        boolean allFilesExist = true;
        try {
            for (String fullPath : toCheck) {
                if (tsi.getProperties(fullPath) != null) continue;
                allFilesExist = false;
                break;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (allFilesExist) {
            this.action.getProcessingContext().put("FILE_SYSTEM_CHECKED", Boolean.TRUE);
            this.action.setDirty();
            return true;
        }
        try {
            timeout = 0L + (long)Integer.parseInt(this.configuration.getProperty("XNJS.staging.filesystem.grace"));
        }
        catch (Exception e) {
            timeout = 10L;
        }
        timeout *= 1000L;
        Long firstFailure = (Long)this.action.getProcessingContext().get("FIRST_STAGEOUT_FAILURE");
        long currentTime = System.currentTimeMillis();
        if (firstFailure == null) {
            this.action.getProcessingContext().put("FIRST_STAGEOUT_FAILURE", currentTime);
            this.action.setDirty();
        } else if (currentTime - firstFailure > timeout) {
            this.action.getProcessingContext().put("FILE_SYSTEM_CHECKED", Boolean.TRUE);
            this.action.setDirty();
            return true;
        }
        return false;
    }

    protected void handleStageOut() throws ProcessingException {
        String id;
        if (this.getTimeStamp(STARTSTAGEOUT) == null) {
            this.storeTimeStamp(STARTSTAGEOUT);
        }
        if ((id = (String)this.action.getProcessingContext().get(subactionkey_out)) != null) {
            String err = this.checkSubAction(subactionkey_out, "Stage-out");
            if (err != null) {
                this.setToDoneAndFailed(err);
            } else if (!this.action.isWaiting()) {
                this.setToDoneSuccessfully();
            }
        } else if (this.hasStageOut()) {
            this.addStageOut();
        } else {
            this.setToDoneSuccessfully();
        }
    }

    protected String checkSubAction(String processingKey, String name) throws ProcessingException {
        String id = (String)this.action.getProcessingContext().get(processingKey);
        try {
            if (this.manager.isActionDone(id)) {
                Action subAction = this.manager.getAction(id);
                this.action.addLogTrace(name + " log:");
                this.action.appendLogTraceFrom(subAction);
                this.action.addLogTrace(name + " is DONE.");
                ActionResult r = subAction.getResult();
                if (!r.isSuccessful()) {
                    this.action.addLogTrace(name + " was NOT SUCCESSFUL");
                    StringBuilder errorDescription = new StringBuilder(name + " was NOT SUCCESSFUL");
                    if (r.getErrorMessage() != null) {
                        errorDescription.append(": " + r.getErrorMessage());
                    }
                    return errorDescription.toString();
                }
            } else {
                this.sleep(3000);
            }
        }
        catch (Exception ex) {
            throw new ProcessingException("Can't check subaction for " + name, ex);
        }
        return null;
    }

    protected abstract void extractFromJSDL() throws Exception;

    protected abstract void extractNotBefore();

    public void updateExecutionContext(ApplicationInfo appDescription, Action job) {
        ExecutionContext ec = job.getExecutionContext();
        String executable = appDescription.getExecutable();
        job.getExecutionContext().setExecutable(executable);
        if (appDescription.getStdout() != null) {
            ec.setStdout(appDescription.getStdout());
        }
        if (appDescription.getStderr() != null) {
            ec.setStderr(appDescription.getStderr());
        }
        if (appDescription.getStdin() != null) {
            ec.setStdin(appDescription.getStdin());
        }
        HashMap<String, String> map = ec.getEnvironment();
        map.putAll(appDescription.getEnvironment());
        for (String fileSystemName : this.configuration.getIDB().getFilesystemNames()) {
            String fs = this.configuration.getIDB().getFilespace(fileSystemName);
            map.put(fileSystemName, fs);
        }
        if (Boolean.parseBoolean(appDescription.getEnvironment().get("UC_PREFER_INTERACTIVE_EXECUTION"))) {
            ec.setInteractive(true);
        }
        job.setDirty();
    }

    private void storeStatistics() {
        Float timeQueued = JobProcessor.getTimeQueued(this.action.getProcessingContext());
        if (timeQueued != null) {
            EMSStatistics stats = this.configuration.getComponentInstanceOfType(EMSStatistics.class);
            stats.updateMeanTimeQueued(timeQueued.longValue());
        }
    }

    private static Float getTimeQueued(Map<Object, Object> context) {
        Long submitToBSS = (Long)context.get(SUBMITTED);
        Long startBSSExecution = (Long)context.get(START_RUNNING);
        if (startBSSExecution != null) {
            return new Float(startBSSExecution - submitToBSS);
        }
        return null;
    }

    public static String getTimeProfile(Map<Object, Object> context) {
        try {
            Long start = (Long)context.get(STARTTIME);
            Long endStageIn = (Long)context.get(ENDSTAGEIN);
            Long startStageOut = (Long)context.get(STARTSTAGEOUT);
            Long end = (Long)context.get(ENDTIME);
            StringBuilder sb = new StringBuilder();
            Float totalTime = new Float((float)(end - start) / 1000.0f);
            sb.append("Total: " + String.format("%.2f sec.", totalTime));
            sb.append(", ");
            Float totalStageIn = new Float((float)(endStageIn - start) / 1000.0f);
            sb.append("Stage-in: " + String.format("%.2f sec.", totalStageIn));
            sb.append(", ");
            Float totalStageOut = new Float((float)(end - startStageOut) / 1000.0f);
            sb.append("Stage-out: " + String.format("%.2f sec.", totalStageOut));
            Float timeQueued = JobProcessor.getTimeQueued(context);
            if (timeQueued != null) {
                timeQueued = Float.valueOf(timeQueued.floatValue() / 1000.0f);
                sb.append(", ");
                sb.append("Time in queue: " + String.format("%.2f sec.", timeQueued));
            }
            Float dataPercentage = Float.valueOf(100.0f * (totalStageIn.floatValue() + totalStageOut.floatValue()) / totalTime.floatValue());
            sb.append(", ");
            sb.append("Datamovement: " + String.format("%.0f %%", dataPercentage));
            return sb.toString();
        }
        catch (RuntimeException e) {
            return "Time profile data not available";
        }
    }

    protected void addStageIn() throws ProcessingException {
        try {
            String subId = this.manager.addSubAction((Serializable)((Object)this.extractStageInInfo()), "JSDL_STAGEIN", this.action, true);
            this.action.getProcessingContext().put(subactionkey_in, subId);
            this.action.addLogTrace("Adding stage in subaction with id=" + subId);
        }
        catch (Exception ex) {
            throw new ProcessingException(ex);
        }
    }

    protected void addStageOut() throws ProcessingException {
        try {
            if (this.hasStageOut()) {
                if (this.configuration.haveProcessingFor("JSDL_STAGEOUT")) {
                    List<DataStageOutInfo> stageOut = this.extractStageOutInfo();
                    String subId = this.manager.addSubAction((Serializable)((Object)stageOut), "JSDL_STAGEOUT", this.action, true);
                    this.action.addLogTrace("Adding stage out subaction with id=" + subId);
                    this.action.getProcessingContext().put(subactionkey_out, subId);
                    this.action.setWaiting(true);
                } else {
                    this.action.addLogTrace("Staging out not done.");
                    this.setToDoneSuccessfully();
                }
            } else {
                this.action.addLogTrace("No staging out needed.");
                this.setToDoneSuccessfully();
            }
        }
        catch (Exception ex) {
            String msg = "Error processing action: " + ex.getMessage();
            this.action.addLogTrace(msg);
            throw new ProcessingException(ex);
        }
    }

    protected abstract List<DataStageInInfo> extractStageInInfo() throws Exception;

    protected abstract List<DataStageOutInfo> extractStageOutInfo() throws Exception;

    private void deleteFiles() {
        try {
            List files = (List)this.action.getProcessingContext().get(KEY_DELETEONTERMINATION);
            if (files == null || files.size() == 0) {
                return;
            }
            TSI tsi = this.configuration.getTargetSystemInterface(this.action.getClient());
            tsi.setStorageRoot(this.action.getExecutionContext().getWorkingDirectory());
            int c = 0;
            for (String file : files) {
                try {
                    tsi.rm(file);
                    ++c;
                }
                catch (ExecutionException ee) {
                    this.action.addLogTrace("Could not delete file <" + file + ">");
                }
            }
            this.action.addLogTrace("Deleted " + c + " files.");
        }
        catch (Exception e) {
            this.action.addLogTrace("Could not delete files.");
        }
    }

    public void setToDoneSuccessfully() {
        this.storeTimeStamp(ENDTIME);
        this.action.setStatus(7);
        this.action.getProcessingContext().set(ApplicationExecutionStatus.done());
        this.action.addLogTrace("Status set to DONE.");
        int exitcode = this.getExitCode();
        this.action.setResult(new ActionResult(3, "Success.", exitcode));
        this.action.addLogTrace("Result: Success.");
        this.deleteFiles();
        this.storeStatistics();
        this.action.addLogTrace(JobProcessor.getTimeProfile(this.action.getProcessingContext()));
        logger.info((Object)("Action " + this.action.getUUID() + " SUCCESSFUL."));
    }

    @Override
    protected void setToDoneAndFailed(String reason) {
        super.setToDoneAndFailed(reason);
        logger.info((Object)("Action " + this.action.getUUID() + " FAILED" + (reason != null ? ": " + reason : ".")));
    }

    protected int getExitCode() {
        Integer i = this.action.getExecutionContext().getExitCode();
        if (i == null) {
            return 0;
        }
        return i;
    }

    @Override
    protected void handleAborting() throws ProcessingException {
        String msg;
        try {
            this.exec.abort(this.action);
        }
        catch (Exception ex) {
            msg = LogUtil.createFaultMessage("Could not abort action on BSS", ex);
            this.action.addLogTrace(msg);
        }
        try {
            this.abortFileTransfers();
        }
        catch (Exception ex) {
            msg = LogUtil.createFaultMessage("Could not abort file transfers", ex);
            this.action.addLogTrace(msg);
        }
        super.handleAborting();
    }

    protected void abortFileTransfers() throws ExecutionException {
        String id = null;
        if (this.action.getStatus() == 1) {
            id = (String)this.action.getProcessingContext().get(subactionkey_in);
        } else if (this.action.getStatus() == 6) {
            id = (String)this.action.getProcessingContext().get(subactionkey_out);
        }
        if (id != null) {
            this.configuration.getEMSManager().abort(id, this.action.getClient());
        }
    }

    @Override
    protected void handleRemoving() throws ProcessingException {
        try {
            if (ActionStatus.canAbort(this.action.getStatus())) {
                this.exec.abort(this.action);
            }
        }
        catch (ExecutionException ex) {
            logger.warn((Object)"Could not abort action", (Throwable)ex);
        }
        super.handleRemoving();
    }

    protected void pauseExecution(int time, TimeUnit units) {
        this.action.setWaiting(true);
        ContinueProcessingEvent e = new ContinueProcessingEvent(this.action.getUUID());
        this.manager.scheduleEvent(e, time, units);
    }
}

