/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.ems;

import de.fzj.unicore.xnjs.util.ErrorCode;
import de.fzj.unicore.xnjs.util.LogUtil;

public class ExecutionException
extends Exception {
    private static final long serialVersionUID = 1L;
    private ErrorCode errorCode;

    public ExecutionException() {
    }

    public ExecutionException(int code, String message) {
        this(new ErrorCode(code, message));
    }

    public ExecutionException(String message) {
        this(new ErrorCode(0, message));
    }

    public ExecutionException(ErrorCode ec) {
        super(ec.toString());
        this.errorCode = ec;
    }

    public ExecutionException(Throwable cause) {
        super(cause);
        this.errorCode = cause instanceof ExecutionException ? ((ExecutionException)cause).getErrorCode() : new ErrorCode(0, LogUtil.getDetailMessage(cause));
    }

    public ExecutionException(String message, Throwable cause) {
        super(message, cause);
        this.errorCode = cause instanceof ExecutionException ? ((ExecutionException)cause).getErrorCode() : new ErrorCode(0, LogUtil.getDetailMessage(cause));
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(ErrorCode errorCode) {
        this.errorCode = errorCode;
    }

    public ErrorCode getRootErrorCode() {
        if (this.getCause() != null && this.getCause() instanceof ExecutionException) {
            ExecutionException ee = (ExecutionException)this.getCause();
            return ee.getErrorCode();
        }
        return this.errorCode;
    }
}

