/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.ems;

import de.fzj.unicore.xnjs.resources.ResourceSet;
import java.io.Serializable;
import java.util.HashMap;

public class ExecutionContext
implements Serializable {
    private static final long serialVersionUID = 11231235534268678L;
    private final String actionID;
    private String workingDirectory;
    private String outcomeDirectory;
    private HashMap<String, String> environment;
    private String location;
    private String stdout = "stdout";
    private String stderr = "stderr";
    private String stdin;
    private String executable;
    private boolean isInteractive;
    private String pidFileName = "UNICORE_SCRIPT_PID";
    private Integer exitCode;
    private Float progress;
    private ResourceSet resourceRequest;
    private String exitCodeFileName = "UNICORE_SCRIPT_EXIT_CODE";
    private String preferredExecutionHost;
    private String umask;

    public ExecutionContext(String actionID) {
        this.actionID = actionID;
        this.environment = new HashMap();
        this.exitCode = null;
        this.setWorkingDirectory(".");
    }

    public HashMap<String, String> getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(HashMap<String, String> environment) {
        this.environment = environment;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public String getOutcomeDirectory() {
        return this.outcomeDirectory != null ? this.outcomeDirectory : this.workingDirectory;
    }

    public void setOutcomeDirectory(String outcomeDirectory) {
        this.outcomeDirectory = outcomeDirectory;
    }

    public String getStderr() {
        return this.stderr;
    }

    public void setStderr(String stderr) {
        this.stderr = stderr;
    }

    public String getStdout() {
        return this.stdout;
    }

    public void setStdout(String stdout) {
        this.stdout = stdout;
    }

    public String getStdin() {
        return this.stdin;
    }

    public void setStdin(String stdin) {
        this.stdin = stdin;
    }

    public Integer getExitCode() {
        return this.exitCode;
    }

    public void setExitCode(int exitCode) {
        this.exitCode = exitCode;
    }

    public String getActionID() {
        return this.actionID;
    }

    public String getExitCodeFileName() {
        return this.exitCodeFileName;
    }

    public void setExitCodeFileName(String exitCodeFileName) {
        this.exitCodeFileName = exitCodeFileName;
    }

    public boolean isInteractive() {
        return this.isInteractive;
    }

    public void setInteractive(boolean isInteractive) {
        this.isInteractive = isInteractive;
    }

    public Float getProgress() {
        return this.progress;
    }

    public void setProgress(Float progress) {
        if (progress != null) {
            if (progress.floatValue() < 0.0f) {
                throw new IllegalArgumentException("Progress value is required to be >=0.");
            }
            if (progress.floatValue() > 1.0f) {
                throw new IllegalArgumentException("Progress value is required to be <=1.");
            }
        }
        this.progress = progress;
    }

    public String getExecutable() {
        return this.executable;
    }

    public void setExecutable(String executable) {
        this.executable = executable;
    }

    public ResourceSet getResourceRequest() {
        return this.resourceRequest;
    }

    public void setResourceRequest(ResourceSet resourceRequest) {
        this.resourceRequest = resourceRequest;
    }

    public String getPreferredExecutionHost() {
        return this.preferredExecutionHost;
    }

    public void setPreferredExecutionHost(String preferredExecutionHost) {
        this.preferredExecutionHost = preferredExecutionHost;
    }

    public String getUmask() {
        return this.umask;
    }

    public void setUmask(String umask) {
        this.umask = umask;
    }

    public String getPIDFileName() {
        return this.pidFileName;
    }

    public void setPIDFileName(String pidFileName) {
        this.pidFileName = pidFileName;
    }
}

