/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.ems;

import de.fzj.unicore.persist.annotations.ID;
import de.fzj.unicore.persist.annotations.Table;
import de.fzj.unicore.xnjs.ems.ActionResult;
import de.fzj.unicore.xnjs.ems.ActionStatus;
import de.fzj.unicore.xnjs.ems.ExecutionContext;
import de.fzj.unicore.xnjs.ems.ProcessingContext;
import de.fzj.unicore.xnjs.io.DataStageInInfo;
import de.fzj.unicore.xnjs.io.DataStageOutInfo;
import de.fzj.unicore.xnjs.jsdl.IncarnatedExecutionEnvironment;
import de.fzj.unicore.xnjs.tsi.ApplicationInfo;
import eu.unicore.security.Client;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;

@Table(name="JOBS")
public class Action
implements Serializable {
    private static final long serialVersionUID = 984059803495L;
    private String UUID;
    private String type;
    private String BSID;
    private Date terminationTime;
    private int status;
    private int transitionalStatus;
    private Client client;
    private String jobName;
    private Serializable ajd;
    private Serializable originalAjd = null;
    private ActionResult result;
    private final List<String> log;
    private ProcessingContext processingContext;
    private ExecutionContext executionContext;
    private IncarnatedExecutionEnvironment executionEnvironment;
    private ApplicationInfo applicationInfo;
    private List<DataStageInInfo> stageIns;
    private List<DataStageOutInfo> stageOuts;
    private volatile transient boolean dirty = false;
    private volatile transient boolean waiting = false;
    private long notBefore;
    private String umask;
    private String rootActionID;
    public static final String AUTO_SUBMIT = "EMS_AUTOSUBMIT";

    public Action(String uuid) {
        this.UUID = uuid;
        if (this.UUID == null) {
            throw new IllegalArgumentException("UUID must be non-null.");
        }
        this.log = new ArrayList<String>();
        this.processingContext = new ProcessingContext();
        this.setResult(new ActionResult());
        this.setStatus(0);
        this.addLogTrace("Created with ID " + this.getUUID());
        this.setDirty();
    }

    public Action() {
        this(java.util.UUID.randomUUID().toString());
    }

    public String getBSID() {
        return this.BSID;
    }

    public void setBSID(String bsid) {
        this.BSID = bsid;
        this.setDirty();
    }

    @ID
    public String getUUID() {
        return this.UUID;
    }

    public int getStatus() {
        return this.status;
    }

    public String getStatusAsString() {
        return ActionStatus.toString(this.status);
    }

    public void setStatus(int status) {
        this.status = status;
        this.setDirty();
    }

    public Date getTerminationTime() {
        return this.terminationTime != null ? (Date)this.terminationTime.clone() : null;
    }

    public void setTerminationTime(Date terminationTime) {
        this.terminationTime = terminationTime != null ? (Date)terminationTime.clone() : null;
        this.setDirty();
    }

    public Object getAjd() {
        return this.ajd;
    }

    public void setAjd(Serializable ajd) {
        this.ajd = ajd;
        this.setDirty();
    }

    public void setUUID(String uuid) {
        this.UUID = uuid;
        this.setDirty();
    }

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
        this.setDirty();
    }

    public void addLogTrace(String tr) {
        this.log.add(new Date().toString() + ": " + tr);
        this.setDirty();
    }

    public void printLogTrace() {
        PrintWriter pw = new PrintWriter(System.out);
        this.printLogTrace(pw);
        pw.flush();
    }

    public void printLogTrace(PrintWriter writer) {
        writer.println("Action id: " + this.getUUID());
        for (String s : this.log) {
            writer.println(s);
        }
    }

    public void appendLogTraceFrom(Action a) {
        if (this.equals(a)) {
            return;
        }
        List<String> l = a.getLog();
        for (String s : l) {
            this.addLogTrace(s);
        }
    }

    public List<String> getLog() {
        return this.log;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
        this.setDirty();
    }

    public ProcessingContext getProcessingContext() {
        return this.processingContext;
    }

    public void setProcessingContext(ProcessingContext processingContext) {
        this.processingContext = processingContext;
        this.setDirty();
    }

    public ActionResult getResult() {
        return this.result;
    }

    public void setResult(ActionResult result) {
        this.result = result;
        this.setDirty();
    }

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public void setExecutionContext(ExecutionContext executionContext) {
        this.executionContext = executionContext;
    }

    public IncarnatedExecutionEnvironment getExecutionEnvironment() {
        return this.executionEnvironment;
    }

    public void setExecutionEnvironment(IncarnatedExecutionEnvironment executionEnvironment) {
        this.executionEnvironment = executionEnvironment;
    }

    public ApplicationInfo getApplicationInfo() {
        return this.applicationInfo;
    }

    public void setApplicationInfo(ApplicationInfo applicationInfo) {
        this.applicationInfo = applicationInfo;
    }

    public List<DataStageInInfo> getStageIns() {
        return this.stageIns;
    }

    public void setStageIns(List<DataStageInInfo> stageIns) {
        this.stageIns = stageIns;
    }

    public List<DataStageOutInfo> getStageOuts() {
        return this.stageOuts;
    }

    public void setStageOuts(List<DataStageOutInfo> stageOuts) {
        this.stageOuts = stageOuts;
    }

    public int getTransitionalStatus() {
        return this.transitionalStatus;
    }

    public void setTransitionalStatus(int transitionalStatus) {
        this.transitionalStatus = transitionalStatus;
        this.setDirty();
    }

    public Serializable getOriginalAjd() {
        return this.originalAjd;
    }

    public void setOriginalAjd(Serializable originalAjd) {
        if (this.originalAjd != null) {
            throw new RuntimeException("Tried setting original job description more than once.");
        }
        this.originalAjd = originalAjd;
        this.setDirty();
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
        this.setDirty();
    }

    public String getUmask() {
        return this.umask;
    }

    public void setUmask(String umask) {
        this.umask = umask;
    }

    public void setDirty() {
        this.dirty = true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void clearDirty() {
        this.dirty = false;
    }

    public boolean isWaiting() {
        return this.waiting;
    }

    public void setWaiting(boolean waiting) {
        this.waiting = waiting;
    }

    public long getNotBefore() {
        return this.notBefore;
    }

    public void setNotBefore(long notBefore) {
        this.notBefore = notBefore;
        this.addLogTrace("Further processing scheduled for " + new Date(notBefore));
        this.setDirty();
    }

    public String getRootActionID() {
        return this.rootActionID != null ? this.rootActionID : this.UUID;
    }

    public void setRootActionID(String rootActionID) {
        this.rootActionID = rootActionID;
    }

    public void fail() {
        this.fail(null);
    }

    public void fail(String errorMessage) {
        String msg = errorMessage != null ? "Failed: " + errorMessage : "Failed.";
        ActionResult res = new ActionResult(2, msg);
        if (this.executionContext != null && this.executionContext.getExitCode() != null) {
            res.setExitCode(this.executionContext.getExitCode());
        }
        this.setResult(res);
        this.addLogTrace("Result: " + msg);
        this.setStatus(7);
        this.addLogTrace("Status set to DONE.");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Action ID       : ").append(this.getUUID()).append("\n");
        sb.append("Action type     : ").append(this.getType()).append("\n");
        sb.append("Status          : ").append(this.getStatusAsString());
        sb.append(" ").append(ActionStatus.transitionalStatus(this.getTransitionalStatus())).append("\n");
        try {
            sb.append("Owner           : ").append(this.getClient().getDistinguishedName()).append("\n");
        }
        catch (Exception e) {
            sb.append("Owner           : not defined.\n");
        }
        if (this.rootActionID != null) {
            sb.append("Root action ID       : ").append(this.rootActionID).append("\n");
        }
        sb.append("Exec. Definition: ").append(this.getAjd()).append("\n");
        sb.append("Orig. Definition: ").append(this.getOriginalAjd()).append("\n");
        return sb.toString();
    }
}

