/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.aaa;

import de.fzj.unicore.xnjs.Configuration;
import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.emi.security.authn.x509.X509Credential;
import eu.emi.security.authn.x509.impl.SocketFactoryCreator;
import eu.unicore.util.httpclient.IPlainClientConfiguration;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;

public class XNJSSocketFactory
extends SocketFactory {
    protected final IPlainClientConfiguration security;
    private final boolean isSSL;
    private SSLContext sslContext = null;

    public XNJSSocketFactory(Configuration config) throws Exception {
        this(config, null);
    }

    public XNJSSocketFactory(Configuration config, Boolean isSSL) throws Exception {
        this.security = config.getComponentInstanceOfType(IPlainClientConfiguration.class);
        if (this.security == null) {
            throw new IllegalStateException("No security configuration found");
        }
        if (isSSL != null) {
            if (isSSL.booleanValue() && !this.security.isSslEnabled()) {
                throw new IllegalStateException("Can not enable SSL for XNJS if the container's SSL configuration is turned off.");
            }
            this.isSSL = isSSL;
        } else {
            this.isSSL = this.security.isSslEnabled();
        }
    }

    public SSLSocketFactory getSSLSocketFactoryForSMTP() throws IOException {
        if (this.useSSL()) {
            return this.getSSLContext().getSocketFactory();
        }
        throw new IOException("SSL is not configured!");
    }

    @Override
    public Socket createSocket(InetAddress source_addr, int port) throws IOException {
        if (this.useSSL()) {
            return this.getSSLContext().getSocketFactory().createSocket(source_addr, port);
        }
        return new Socket(source_addr, port);
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        if (this.useSSL()) {
            return this.getSSLContext().getSocketFactory().createSocket(host, port);
        }
        return new Socket(host, port);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        if (this.useSSL()) {
            return this.getSSLContext().getSocketFactory().createSocket(host, port, localHost, localPort);
        }
        return new Socket(host, port, localHost, localPort);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        if (this.useSSL()) {
            return this.getSSLContext().getSocketFactory().createSocket(address, port, localAddress, localPort);
        }
        return new Socket(address, port, localAddress, localPort);
    }

    protected synchronized SSLContext getSSLContext() throws IOException {
        if (this.sslContext == null) {
            this.sslContext = SocketFactoryCreator.getSSLContext((X509Credential)this.security.getCredential(), (X509CertChainValidator)this.security.getValidator(), (SecureRandom)new SecureRandom());
        }
        return this.sslContext;
    }

    public boolean useSSL() {
        return this.isSSL;
    }
}

