/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.beans.engine.CoreDocument;
import de.fzj.unicore.xnjs.beans.engine.EngineConfigurationDocument;
import de.fzj.unicore.xnjs.beans.engine.ProcessingChainDocument;
import de.fzj.unicore.xnjs.ems.processors.DefaultProcessorFactory;
import de.fzj.unicore.xnjs.jsdl.JSDLProcessor;
import de.fzj.unicore.xnjs.jsdl.JSDLUtils;
import de.fzj.unicore.xnjs.persistence.BasicActionStoreFactory;
import de.fzj.unicore.xnjs.simple.BasicExecution;
import de.fzj.unicore.xnjs.simple.BasicManager;
import de.fzj.unicore.xnjs.simple.BasicTSIFactory;
import de.fzj.unicore.xnjs.simple.InMemoryGrounder;
import de.fzj.unicore.xnjs.simple.LocalECManager;
import de.fzj.unicore.xnjs.util.LogUtil;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Calendar;
import org.apache.log4j.Logger;

public class XNJS {
    private static final Logger logger = LogUtil.getLogger("unicore.xnjs", XNJS.class);
    private final Calendar startTime = Calendar.getInstance();
    private Configuration config;

    public XNJS() throws Exception {
        this(XNJS.minimalConfig().newInputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XNJS(String configFileName) throws Exception {
        FileInputStream config = new FileInputStream(configFileName);
        try {
            this.init(config);
        }
        finally {
            ((InputStream)config).close();
        }
    }

    public XNJS(InputStream configSource) throws Exception {
        this.init(configSource);
    }

    public static final String getVersion() {
        String v = XNJS.class.getPackage().getImplementationVersion();
        if (v == null) {
            v = "(DEVELOPMENT version)";
        }
        return v;
    }

    private void init(InputStream configSource) throws Exception {
        this.config = new Configuration(configSource);
        this.config.init();
    }

    public final Configuration getConfig() {
        return this.config;
    }

    public void start() throws Exception {
        logger.info((Object)("STARTING " + XNJS.writeShortHeader()));
        this.config.start();
    }

    public void stop() throws Exception {
        logger.info((Object)("STOPPING " + XNJS.writeShortHeader()));
        this.config.stop();
    }

    public Calendar getStartTime() throws Exception {
        return this.startTime;
    }

    public static String writeShortHeader() {
        return "XNJS " + XNJS.getVersion() + " (c) Forschungszentrum Juelich 2005-2013";
    }

    private static final EngineConfigurationDocument minimalConfig() {
        EngineConfigurationDocument ecd = EngineConfigurationDocument.Factory.newInstance();
        EngineConfigurationDocument.EngineConfiguration ec = ecd.addNewEngineConfiguration();
        CoreDocument.Core core = ec.addNewCore();
        core.setActionStorageFactory(BasicActionStoreFactory.class.getName());
        core.setExecutionContextManager(LocalECManager.class.getName());
        core.setExecution(BasicExecution.class.getName());
        core.setManager(BasicManager.class.getName());
        core.setTSIFactory(BasicTSIFactory.class.getName());
        core.setProcessorFactory(DefaultProcessorFactory.class.getName());
        core.setGrounder(InMemoryGrounder.class.getName());
        ProcessingChainDocument.ProcessingChain p1 = ProcessingChainDocument.ProcessingChain.Factory.newInstance();
        p1.setActionType("JSDL");
        p1.setJobDescriptionType(JSDLUtils.JSDL_JOBDEFINITION.toString());
        p1.addProcessor(JSDLProcessor.class.getName());
        ec.setProcessingChainArray(new ProcessingChainDocument.ProcessingChain[]{p1});
        ec.addNewProperties();
        return ecd;
    }
}

