/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs;

import de.fzj.unicore.xnjs.XNJSException;
import de.fzj.unicore.xnjs.beans.engine.CoreDocument;
import de.fzj.unicore.xnjs.beans.engine.EngineConfigurationDocument;
import de.fzj.unicore.xnjs.beans.engine.ProcessingChainDocument;
import de.fzj.unicore.xnjs.beans.engine.PropertyDocument;
import de.fzj.unicore.xnjs.ems.Action;
import de.fzj.unicore.xnjs.ems.IExecutionContextManager;
import de.fzj.unicore.xnjs.ems.IProcessorFactory;
import de.fzj.unicore.xnjs.ems.InternalManager;
import de.fzj.unicore.xnjs.ems.Manager;
import de.fzj.unicore.xnjs.ems.Processor;
import de.fzj.unicore.xnjs.ems.processors.AsyncCommandProcessor;
import de.fzj.unicore.xnjs.io.IFileTransferEngine;
import de.fzj.unicore.xnjs.jsdl.Incarnation;
import de.fzj.unicore.xnjs.jsdl.IncarnationDataBase;
import de.fzj.unicore.xnjs.jsdl.SweepInstanceProcessor;
import de.fzj.unicore.xnjs.jsdl.SweepProcessor;
import de.fzj.unicore.xnjs.management.DefaultImplementation;
import de.fzj.unicore.xnjs.management.Dependency;
import de.fzj.unicore.xnjs.management.IServiceConfigurator;
import de.fzj.unicore.xnjs.management.JMX;
import de.fzj.unicore.xnjs.management.Lifecycle;
import de.fzj.unicore.xnjs.management.ManagedComponent;
import de.fzj.unicore.xnjs.persistence.IActionStore;
import de.fzj.unicore.xnjs.persistence.IActionStoreFactory;
import de.fzj.unicore.xnjs.persistence.JDBCActionStoreFactory;
import de.fzj.unicore.xnjs.reception.Reception;
import de.fzj.unicore.xnjs.simple.LocalTS;
import de.fzj.unicore.xnjs.tsi.IExecution;
import de.fzj.unicore.xnjs.tsi.IReservation;
import de.fzj.unicore.xnjs.tsi.TSI;
import de.fzj.unicore.xnjs.tsi.TSIFactory;
import de.fzj.unicore.xnjs.util.LogUtil;
import eu.unicore.security.Client;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.namespace.QName;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.QNameSet;
import org.apache.xmlbeans.QNameSetBuilder;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlString;
import org.picocontainer.Characteristics;
import org.picocontainer.ComponentFactory;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.DefaultPicoContainer;
import org.picocontainer.LifecycleStrategy;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoException;
import org.picocontainer.behaviors.OptInCaching;
import org.picocontainer.lifecycle.StartableLifecycleStrategy;
import org.picocontainer.monitors.NullComponentMonitor;

public final class Configuration {
    protected static final Logger logger = LogUtil.getLogger("unicore.xnjs", Configuration.class);
    public static final String CONFIG_AUTOSUBMIT_WHEN_READY = "XNJS.autosubmit";
    public static final String CONFIG_SERVICES = "XNJS.services";
    public static final String CONFIG_FILESPACE = "XNJS.filespace";
    public static final String CONFIG_STATEDIR = "XNJS.statedir";
    public static final String CONFIG_LOGFILE = "XNJS.logfile";
    public static final String CONFIG_RESUBMIT_COUNT = "XNJS.bssResubmitCount";
    public static final String CONFIG_RESUBMIT_DELAY = "XNJS.bssResubmitDelay";
    private final MutablePicoContainer pico;
    private volatile boolean stopped = true;
    private EngineConfigurationDocument.EngineConfiguration config;
    private Hashtable<String, String> jobTypeCache;
    private Hashtable<String, String[]> processorChainCache;
    private CacheManager cacheManager;
    private Cache aclSupportCache;
    private InputStream sourceStream;
    private Properties configProperties;
    private IServiceConfigurator scr;
    private List<Reception> receptions = new ArrayList<Reception>();
    private final ScheduledExecutorService es = Executors.newScheduledThreadPool(1);
    private static final AtomicInteger id = new AtomicInteger(0);
    private final String uniqueID;
    private int bssResubmitCount;
    private int bssResubmitDelay;

    public Configuration(InputStream configurationSource) {
        this.configProperties = new Properties();
        this.uniqueID = String.valueOf(id.incrementAndGet());
        this.sourceStream = configurationSource;
        this.initCache();
        this.pico = new DefaultPicoContainer((ComponentFactory)new OptInCaching(), (LifecycleStrategy)new StartableLifecycleStrategy((ComponentMonitor)new NullComponentMonitor()), null);
        this.pico.addComponent((Object)this);
    }

    private void initCache() {
        net.sf.ehcache.config.Configuration conf = new net.sf.ehcache.config.Configuration();
        CacheConfiguration cc = new CacheConfiguration();
        conf.setUpdateCheck(false);
        conf.setDefaultCacheConfiguration(cc);
        this.cacheManager = new CacheManager(conf);
        this.aclSupportCache = new Cache("aclSupportCache", 20, false, false, 180L, 180L);
        this.cacheManager.addCache(this.aclSupportCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws Exception {
        try {
            this.readConfig();
        }
        finally {
            if (this.sourceStream != null) {
                try {
                    this.sourceStream.close();
                }
                catch (IOException ioe) {}
            }
        }
        this.buildProperties();
        this.doRegister();
        String serviceConfig = this.getProperty(CONFIG_SERVICES);
        if (serviceConfig != null) {
            logger.debug((Object)("Reading " + serviceConfig));
            this.scr = (IServiceConfigurator)this.pico.getComponent(IServiceConfigurator.class);
            if (this.scr != null) {
                this.scr.configureServices(new FileInputStream(new File(serviceConfig)));
            } else {
                logger.debug((Object)"No front-end service configured.");
            }
        } else {
            logger.debug((Object)"No front-end service configuration read.");
        }
        logger.debug((Object)("Initial Configuration: \n" + this.config.toString()));
    }

    private void buildProperties() {
        PropertyDocument.Property[] ps;
        for (PropertyDocument.Property p : ps = this.config.getProperties().getPropertyArray()) {
            String name = p.getName();
            String value = p.getValue();
            if (name == null || value == null) continue;
            this.configProperties.put(name, value);
        }
        try {
            this.bssResubmitCount = Integer.parseInt(this.getProperty(CONFIG_RESUBMIT_COUNT, "3"));
            if (this.bssResubmitCount < 0) {
                throw new IllegalArgumentException("BSS resubmit count can not be negative!");
            }
        }
        catch (Exception e) {
            this.bssResubmitCount = 3;
            logger.warn((Object)("Problem parsing XNJS.bssResubmitCount value (using: " + this.bssResubmitCount + ")."), (Throwable)e);
        }
        try {
            this.bssResubmitDelay = Integer.parseInt(this.getProperty(CONFIG_RESUBMIT_DELAY, "10"));
            if (this.bssResubmitDelay < 1) {
                throw new IllegalArgumentException("BSS resubmit dalay must be positive!");
            }
        }
        catch (Exception e) {
            this.bssResubmitDelay = 10;
            logger.warn((Object)("Problem parsing XNJS.bssResubmitDelay value (using: " + this.bssResubmitDelay + ")."), (Throwable)e);
        }
    }

    private void readConfig() throws Exception {
        if (this.sourceStream != null) {
            EngineConfigurationDocument ecd = EngineConfigurationDocument.Factory.parse(this.sourceStream);
            this.config = ecd.getEngineConfiguration();
        } else {
            this.config = EngineConfigurationDocument.EngineConfiguration.Factory.newInstance();
        }
        this.buildConfigCaches();
    }

    private void doRegister() throws Exception {
        String name = this.getProperty("XNJS.tsiclass");
        if (name == null) {
            name = LocalTS.class.getName();
        }
        Class<?> tsiClazz = Class.forName(name);
        this.doRegister(tsiClazz);
        CoreDocument.Core core = this.config.getCore();
        QNameSetBuilder qnsb = new QNameSetBuilder();
        qnsb.addNamespace("http://www.fz-juelich.de/unicore/xnjs/engine");
        QNameSet qns = qnsb.toQNameSet();
        XmlObject[] obs = core.selectChildren(qns);
        String clazz = "";
        for (XmlObject o : obs) {
            try {
                clazz = ((XmlString)o).getStringValue();
                if ("".equals(clazz) || clazz == null || (clazz = this.checkDeprecated(clazz)) == null) continue;
                Class<?> c = Class.forName(clazz);
                this.doRegister(c);
            }
            catch (PicoException pe) {
                logger.warn((Object)("Component registration exception: " + clazz + ", ignored."));
            }
            catch (Exception ex) {
                LogUtil.logException("Problems processing configuration value: " + o, ex, logger);
            }
        }
    }

    private String checkDeprecated(String clazz) {
        String[] old;
        String hDB = "de.fzj.unicore.xnjs.persistence.HsqldbActionStoreFactory";
        if (hDB.equals(clazz)) {
            clazz = JDBCActionStoreFactory.class.getName();
            logger.warn((Object)("CONFIG: old value <" + hDB + "> used, please use <" + clazz + "> instead."));
        }
        for (String o : old = new String[]{"de.fzj.unicore.xnjs.simple.BasicAuthenticator", "de.fzj.unicore.xnjs.simple.BasicPolicyManager", "de.fzj.unicore.xnjs.simple.BasicResourceChecker"}) {
            if (!clazz.equals(o)) continue;
            logger.warn((Object)("CONFIG: old value <" + o + "> used, please remove that line."));
            clazz = null;
        }
        return clazz;
    }

    private void doRegister(Class<?> c) throws Exception {
        this.registerDependencies(c);
        if (Reception.class.isAssignableFrom(c)) {
            this.receptions.add((Reception)c.newInstance());
        } else {
            Lifecycle lc = c.getAnnotation(Lifecycle.class);
            if (lc == null || lc.isSingleton()) {
                this.pico.as(new Properties[]{Characteristics.CACHE}).addComponent(c);
            } else {
                this.pico.addComponent(c);
            }
        }
    }

    private void registerDependencies(Class<? extends Object> c) {
        Dependency d = c.getAnnotation(Dependency.class);
        if (d != null) {
            Class<?>[] cs;
            for (Class<?> clazz2 : cs = d.classes()) {
                try {
                    logger.debug((Object)("Registering " + clazz2.getName()));
                    this.doRegister(clazz2);
                }
                catch (PicoException e1) {
                    logger.debug((Object)("Duplicate component registration: " + clazz2 + ", ignored."));
                }
                catch (Exception e) {
                    logger.fatal((Object)("Error in component registration for: " + clazz2));
                }
            }
        }
    }

    private void buildConfigCaches() {
        ProcessingChainDocument.ProcessingChain[] pc;
        this.jobTypeCache = new Hashtable();
        this.processorChainCache = new Hashtable();
        for (ProcessingChainDocument.ProcessingChain p : pc = this.config.getProcessingChainArray()) {
            String jdt = p.getJobDescriptionType();
            String at = p.getActionType();
            if (jdt != null) {
                this.jobTypeCache.put(p.getJobDescriptionType(), at);
            }
            this.processorChainCache.put(at, p.getProcessorArray());
        }
    }

    protected void assureDefaultProcessingAvailable() {
        if (!this.haveProcessingFor("ASYNC_COMMAND")) {
            this.setProcessingChain("ASYNC_COMMAND", null, new String[]{AsyncCommandProcessor.class.getName()});
        }
        if (!this.haveProcessingFor("jsdl_parameter_sweep")) {
            this.setProcessingChain("jsdl_parameter_sweep", null, new String[]{SweepProcessor.class.getName()});
        }
        if (!this.haveProcessingFor("JSDL-sweep-instance")) {
            this.setProcessingChain("JSDL-sweep-instance", null, new String[]{SweepInstanceProcessor.class.getName()});
        }
    }

    public String getProperty(String key) {
        return this.configProperties.getProperty(key);
    }

    public Properties getProperties() {
        return this.configProperties;
    }

    public String getProperty(String key, String def) {
        return this.configProperties.getProperty(key, def);
    }

    public void setProperty(String key, String value) {
        if (value != null) {
            this.configProperties.setProperty(key, value);
        } else {
            this.configProperties.remove(key);
        }
    }

    public void start() {
        if (this.stopped) {
            logger.info((Object)"Starting up.");
            this.assureDefaultProcessingAvailable();
            this.pico.start();
            for (Reception r : this.receptions) {
                r.start();
            }
            this.stopped = false;
        } else {
            logger.info((Object)"Already started.");
        }
    }

    public void stop() {
        if (this.stopped) {
            logger.info((Object)"Already stopped.");
            return;
        }
        this.stopped = true;
        for (Reception r : this.receptions) {
            r.stop();
        }
        this.es.shutdown();
        this.getEMSManager().stop();
        this.pico.stop();
    }

    public final String getID() {
        return this.uniqueID;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized <T> T getComponentInstanceOfType(Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("Component class cannot be null!");
        }
        try {
            Object o = this.pico.getComponent(clazz);
            if (o == null) {
                logger.debug((Object)("Component <" + clazz.getName() + "> is not registered."));
                DefaultImplementation di = clazz.getAnnotation(DefaultImplementation.class);
                if (di == null) return null;
                Class<?> clazz2 = di.clazz();
                this.doRegister(clazz2);
                logger.info((Object)("Registered: " + clazz2 + " as default implementation of " + clazz));
                o = this.pico.getComponent(clazz2);
                this.setupComponent(o);
                return (T)o;
            } else {
                this.setupComponent(o);
            }
            return (T)o;
        }
        catch (Exception ex) {
            LogUtil.logException("Error setting up the requested component <" + clazz.getName() + ">", ex, logger);
            if (!(ex instanceof RuntimeException)) throw new RuntimeException("Error setting up the requested component <" + clazz.getName() + ">", ex);
            throw (RuntimeException)ex;
        }
    }

    private void setupComponent(Object o) {
        if (o.getClass().getAnnotation(ManagedComponent.class) != null) {
            JMX.registerMBean(o);
        }
    }

    public void registerComponent(Object component) {
        if (component == null) {
            throw new NullPointerException("Component cannot be null!");
        }
        try {
            this.pico.addComponent(component);
        }
        catch (PicoException e1) {
            logger.warn((Object)("Duplicate component registration: " + component.getClass() + ", ignored."));
        }
    }

    public List<Reception> getReceptions() {
        return this.receptions;
    }

    public Manager getEMSManager() {
        return this.getComponentInstanceOfType(Manager.class);
    }

    public InternalManager getInternalManager() {
        return this.getComponentInstanceOfType(InternalManager.class);
    }

    public Processor createProcessor(String actionType) {
        try {
            IProcessorFactory pf = this.getProcessorFactory();
            return pf.getProcessor(actionType);
        }
        catch (Exception ex) {
            LogUtil.logException("Can't create processor for action type " + actionType + ", continuing...", ex, logger);
            return null;
        }
    }

    public IProcessorFactory getProcessorFactory() {
        return this.getComponentInstanceOfType(IProcessorFactory.class);
    }

    public String[] getProcessorChain(String type) {
        return this.processorChainCache.get(type);
    }

    public boolean haveProcessingFor(String actionType) {
        return this.getProcessorChain(actionType) != null;
    }

    public void setProcessingChain(String actionType, QName jobDescriptionType, String[] chain) {
        this.processorChainCache.put(actionType, chain);
        if (jobDescriptionType != null) {
            this.jobTypeCache.put(actionType, jobDescriptionType.toString());
        }
    }

    public String getJobType(String qname) {
        return this.jobTypeCache.get(qname);
    }

    public Action makeAction(XmlObject job) {
        return this.makeAction(job, UUID.randomUUID().toString());
    }

    public Action makeAction(XmlObject job, String uuid) {
        Action a = new Action(uuid);
        XmlCursor c = job.newCursor();
        c.toFirstChild();
        String qn = c.getName().toString();
        String type = this.getJobType(qn);
        if (type == null) {
            return null;
        }
        a.setAjd((Serializable)job);
        a.setOriginalAjd((Serializable)job.copy());
        a.setType(type);
        return a;
    }

    public IExecutionContextManager getExecutionContextMgr() {
        return this.getComponentInstanceOfType(IExecutionContextManager.class);
    }

    public IExecution getExecutionInterface() {
        return this.getComponentInstanceOfType(IExecution.class);
    }

    public TSI getTargetSystemInterface(Client client) {
        return this.getTargetSystemInterface(client, null);
    }

    public TSI getTargetSystemInterface(Client client, String preferredTSINode) {
        TSI tsi = null;
        TSIFactory tsif = this.getComponentInstanceOfType(TSIFactory.class);
        if (tsif == null) {
            throw new RuntimeException("No TSIFactory.");
        }
        tsi = tsif.getTSI(client, preferredTSINode);
        return tsi;
    }

    public TSIFactory getTSIFactory() {
        return this.getComponentInstanceOfType(TSIFactory.class);
    }

    public TSI getStorageTSI(String storageRoot, Client client) {
        TSIFactory tsif = this.getComponentInstanceOfType(TSIFactory.class);
        if (tsif == null) {
            throw new RuntimeException("No TSIFactory");
        }
        TSI tsi = tsif.getTSI(storageRoot, client);
        return tsi;
    }

    public Incarnation getGrounder() {
        return this.getComponentInstanceOfType(Incarnation.class);
    }

    public IncarnationDataBase getIDB() {
        return this.getComponentInstanceOfType(IncarnationDataBase.class);
    }

    public IActionStore getActionStore(String id) {
        try {
            IActionStoreFactory asf = this.getComponentInstanceOfType(IActionStoreFactory.class);
            return asf.getInstance(id, this);
        }
        catch (Exception ex) {
            String msg = "Config error: requested component not available.";
            LogUtil.logException(msg, ex, logger);
            throw new XNJSException(msg, ex);
        }
    }

    public IFileTransferEngine getFileTransferEngine() {
        IFileTransferEngine fte = this.getComponentInstanceOfType(IFileTransferEngine.class);
        if (fte != null) {
            return fte;
        }
        String msg = "Config error: requested component not available.";
        throw new XNJSException(msg);
    }

    public IReservation getReservationInterface() {
        return this.getComponentInstanceOfType(IReservation.class);
    }

    public final ScheduledExecutorService getScheduledExecutor() {
        return this.es;
    }

    public boolean isAutoSubmitToBSS() {
        return Boolean.parseBoolean(this.getProperty(CONFIG_AUTOSUBMIT_WHEN_READY));
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void cacheACLSupport(String root, String path, Boolean value) {
        this.aclSupportCache.put(new Element((Serializable)((Object)(root + path)), (Serializable)value));
    }

    public Boolean getACLCachedSupport(String root, String path) {
        Element ret = this.aclSupportCache.get((Serializable)((Object)(root + path)));
        if (ret == null) {
            return null;
        }
        return (Boolean)ret.getValue();
    }

    public int getBSSResubmissionCount() {
        return this.bssResubmitCount;
    }

    public int getBSSResubmissionDelay() {
        return this.bssResubmitDelay;
    }
}

