/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uftp.server;

import eu.unicore.uftp.dpc.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Properties;
import org.apache.log4j.Logger;

public class UFTPTransferRequest {
    private static final Logger logger = Logger.getLogger(UFTPTransferRequest.class);
    private final InetAddress clientAddress;
    private final boolean send;
    private final File file;
    private final int streams;
    private final String secret;
    private final String user;
    private final String group;
    private final long createdTime;
    private final byte[] key;
    private final boolean append;

    public UFTPTransferRequest(InetAddress client, boolean send, int numCons, File file, boolean append, String secret, String user, String group, byte[] key) {
        this.clientAddress = client;
        this.send = send;
        this.file = file;
        this.streams = numCons;
        this.secret = secret;
        this.user = user;
        this.group = group;
        this.key = key;
        this.append = append;
        this.createdTime = System.currentTimeMillis();
    }

    public UFTPTransferRequest(Properties properties) throws UnknownHostException, IOException {
        this.clientAddress = InetAddress.getByName(properties.getProperty("client-ip"));
        this.send = Boolean.parseBoolean(properties.getProperty("send"));
        this.file = new File(properties.getProperty("file"));
        this.append = Boolean.parseBoolean(properties.getProperty("append"));
        this.streams = Integer.parseInt(properties.getProperty("streams", "2"));
        this.secret = properties.getProperty("secret");
        this.user = properties.getProperty("user");
        this.group = properties.getProperty("group");
        this.key = Utils.decodeBase64(properties.getProperty("key"));
        this.createdTime = System.currentTimeMillis();
    }

    public UFTPTransferRequest(String properties) throws UnknownHostException, IOException {
        this(UFTPTransferRequest.loadProperties(properties));
    }

    private static Properties loadProperties(String props) throws IOException {
        StringReader r = new StringReader(props);
        Properties p = new Properties();
        p.load(r);
        return p;
    }

    public InetAddress getClient() {
        return this.clientAddress;
    }

    public boolean isSendJob() {
        return this.send;
    }

    public File getFile() {
        return this.file;
    }

    public boolean isAppend() {
        return this.append;
    }

    public int getNumCons() {
        return this.streams;
    }

    public String getSecret() {
        return this.secret;
    }

    public String getUser() {
        return this.user;
    }

    public String getGroup() {
        return this.group;
    }

    public byte[] getKey() {
        return this.key;
    }

    public void writeEncoded(OutputStream os) throws IOException {
        os.write("request-type=uftp-transfer-request\n".getBytes());
        os.write(("client-ip=" + this.clientAddress.getHostAddress()).getBytes());
        os.write("\n".getBytes());
        os.write(("send=" + String.valueOf(this.send)).getBytes());
        os.write("\n".getBytes());
        os.write(("file=" + this.file.getPath()).getBytes());
        os.write("\n".getBytes());
        os.write(("append=" + String.valueOf(this.append)).getBytes());
        os.write("\n".getBytes());
        os.write(("streams=" + String.valueOf(this.streams)).getBytes());
        os.write("\n".getBytes());
        os.write(("secret=" + this.secret).getBytes());
        os.write("\n".getBytes());
        os.write(("user=" + this.user).getBytes());
        os.write("\n".getBytes());
        os.write(("group=" + this.group).getBytes());
        os.write("\n".getBytes());
        if (this.key != null) {
            os.write(("key=" + Utils.encodeBase64(this.key)).getBytes());
            os.write("\n".getBytes());
        }
        os.write("END\n".getBytes());
        os.flush();
    }

    public String toString() {
        return "UFTPRequest for client=" + this.clientAddress.getHostAddress() + " send=" + this.send + " file=" + this.file.getPath() + " user=" + this.user + " group=" + this.group + " streams=" + this.streams + " encrypted=" + (this.key != null);
    }

    public String sendTo(InetAddress server, int port) throws IOException {
        Socket s = new Socket(server, port);
        logger.info((Object)("Sending to " + server.getHostAddress() + ":" + port + " : " + this));
        this.writeEncoded(s.getOutputStream());
        String res = this.readResponse(s.getInputStream());
        s.close();
        logger.debug((Object)("Finished sending request, got response '" + res + "'"));
        return res;
    }

    public String sendTo(Socket s) throws IOException {
        logger.info((Object)("Sending to " + s.getInetAddress().getHostAddress() + ":" + s.getPort() + " : " + this));
        this.writeEncoded(s.getOutputStream());
        String res = this.readResponse(s.getInputStream());
        s.close();
        logger.debug((Object)("Finished sending request, got response '" + res + "'"));
        return res;
    }

    protected String readResponse(InputStream is) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        String line = br.readLine();
        return line;
    }

    public long getCreatedTime() {
        return this.createdTime;
    }
}

