/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.utils.deployment;

import de.fzj.unicore.wsrflite.ContainerProperties;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.Service;
import de.fzj.unicore.wsrflite.ServiceConfiguration;
import de.fzj.unicore.wsrflite.ServiceFactory;
import de.fzj.unicore.wsrflite.ThreadingServices;
import de.fzj.unicore.wsrflite.events.PropertyFileChangeEvent;
import de.fzj.unicore.wsrflite.exceptions.ServiceDeploymentException;
import de.fzj.unicore.wsrflite.utils.FileWatcher;
import de.fzj.unicore.wsrflite.utils.deployment.IServiceConfigurator;
import de.fzj.unicore.wsrflite.utils.deployment.ServiceClassLoader;
import eu.unicore.util.Log;
import eu.unicore.util.configuration.ConfigurationException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ServiceConfigReader
extends DefaultHandler
implements IServiceConfigurator {
    private static final Logger logger = Log.getLogger((String)"unicore.wsrflite", ServiceConfigReader.class);
    private String current;
    private String type;
    private String iFace;
    private String clazz;
    private boolean isPersistent;
    private boolean enabled = true;
    private String handlerType;
    private String handlerClass;
    protected String monitorName;
    protected String jarFilePath;
    protected String initTask;
    protected String shutdownTask;
    private final ArrayList<String> inhandlers = new ArrayList();
    private final ArrayList<String> outhandlers = new ArrayList();
    private final ArrayList<String> globalOutHandlers = new ArrayList();
    private final ArrayList<String> globalInHandlers = new ArrayList();
    private final ArrayList<Runnable> initTasks = new ArrayList();
    private String wsdlLocation = null;
    private final File configFile;
    private File xmlConfigFile;
    private FileWatcher configFileWatcher = null;
    private final Kernel kernel;

    public ServiceConfigReader(Kernel kernel, File config) throws FileNotFoundException {
        this.kernel = kernel;
        this.configFile = config;
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    logger.info((Object)("RE-READING UNICORE Container (USE) configuration from <" + ServiceConfigReader.this.configFile.getAbsolutePath() + ">"));
                    ServiceConfigReader.this.reInit();
                    ServiceConfigReader.this.initTasks.clear();
                    Properties newProperties = ServiceConfigReader.this.loadProperties();
                    ServiceConfigReader.this.kernel.notifyObservers(new PropertyFileChangeEvent(ServiceConfigReader.this.configFile.getAbsolutePath(), newProperties));
                    ServiceConfigReader.this.configureServices();
                    for (Runnable r : ServiceConfigReader.this.getInitTasks()) {
                        try {
                            r.run();
                        }
                        catch (Exception ex) {
                            logger.error((Object)("Error running startup task <" + r.getClass().getName() + ">"), (Throwable)ex);
                        }
                    }
                }
                catch (Exception fex) {
                    throw new RuntimeException(fex);
                }
            }
        };
        this.configFileWatcher = new FileWatcher(this.configFile, r);
    }

    @Override
    public void startConfigMonitoring(ThreadingServices ts, long period) {
        if (period > 0L) {
            ts.getScheduledExecutorService().scheduleWithFixedDelay(this.configFileWatcher, 5L * period, period, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties loadProperties() throws IOException, XMLStreamException, ConfigurationException {
        Properties p = new Properties();
        FileInputStream fis = new FileInputStream(this.configFile);
        this.xmlConfigFile = null;
        try {
            p.load(fis);
            String xmlConfigPath = p.getProperty("container.configfile");
            if (xmlConfigPath != null) {
                this.xmlConfigFile = new File(xmlConfigPath);
            } else if (p.size() > 0 && !((String)p.propertyNames().nextElement()).startsWith("<")) {
                throw new ConfigurationException("If Java properties file is used as the main configuration file, then XML configuration of the USE container must be referenced from this file with the container.configfile property");
            }
        }
        catch (IOException ex) {
            p = new Properties();
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException ignored) {}
        }
        if (this.xmlConfigFile != null) {
            logger.info((Object)("Loaded properties from file <" + this.configFile + ">"));
            if (this.configFileWatcher != null) {
                this.configFileWatcher.addTarget(this.xmlConfigFile);
            }
        } else {
            this.xmlConfigFile = new File(this.configFile.getAbsolutePath());
        }
        logger.info((Object)("Reading UNICORE Container (USE) configuration from " + this.xmlConfigFile));
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(this.xmlConfigFile));
        try {
            this.loadProperties(is, p);
        }
        finally {
            ((InputStream)is).close();
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configureServices() throws Exception {
        if (this.xmlConfigFile == null) {
            throw new IllegalStateException("loadProperties() must be invoked prior to this method");
        }
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(this.xmlConfigFile));
        try {
            is = new BufferedInputStream(new FileInputStream(this.xmlConfigFile));
            this.configureServices(is);
            this.addUserDefinedStartupTasks();
        }
        finally {
            ((InputStream)is).close();
        }
    }

    private void addUserDefinedStartupTasks() throws Exception {
        ContainerProperties settings = this.kernel.getContainerProperties();
        List values = settings.getListOfValues("onstartup.");
        if (settings.isSet("onstartup")) {
            values.add(0, settings.getValue("onstartup"));
        }
        for (String value : values) {
            String[] classes;
            if (value == null) continue;
            for (String c : classes = value.split(" ")) {
                try {
                    c = c.trim();
                    if (c.length() == 0) continue;
                    logger.info((Object)("Found startup task <" + c + ">"));
                    Class<?> clazz = Class.forName(c);
                    Object o = this.kernel.load(clazz);
                    this.initTasks.add((Runnable)o);
                }
                catch (Exception e) {
                    Log.logException((String)("Error setting up startup task " + c), (Throwable)e, (Logger)logger);
                    throw e;
                }
            }
        }
    }

    private void loadProperties(InputStream is, Properties target) throws IOException, XMLStreamException {
        StartElement entry;
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLEventReader reader = null;
        try {
            reader = factory.createXMLEventReader(new BufferedInputStream(is));
        }
        catch (XMLStreamException e) {
            throw new IOException("Can't initialize XML parser: " + e.toString());
        }
        String mainEl = "services";
        StartElement start = this.getNextElement(reader, mainEl);
        if (start == null) {
            throw new IOException("File must start with " + mainEl + " element.");
        }
        while (reader.hasNext() && (entry = this.getNextElement(reader, "property")) != null) {
            Attribute a = entry.getAttributeByName(new QName("name"));
            if (a == null) {
                throw new IOException("Got property element without name attribute");
            }
            String name = a.getValue();
            a = entry.getAttributeByName(new QName("value"));
            if (a == null) {
                throw new IOException("Got property element without value attribute");
            }
            String value = a.getValue();
            logger.debug((Object)("Setting " + name + "='" + value + "'"));
            target.setProperty(name, value);
        }
    }

    private StartElement getNextElement(XMLEventReader reader, String searchedElement) throws IOException, XMLStreamException {
        while (reader.hasNext()) {
            StartElement el;
            XMLEvent event = reader.nextEvent();
            if (!(event instanceof StartElement) || !(el = (StartElement)event).getName().getLocalPart().equals(searchedElement)) continue;
            return el;
        }
        return null;
    }

    private void configureServices(InputStream is) throws SAXException, ParserConfigurationException, IOException {
        InputSource source = new InputSource(is);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        SAXParser parser = factory.newSAXParser();
        parser.parse(source, (DefaultHandler)this);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("serviceFactory".equals(localName)) {
            String sfClass = attributes.getValue("class");
            this.doRegisterServiceFactory(sfClass);
        }
        if ("globalHandler".equals(localName)) {
            String globalHandlerType = attributes.getValue("type");
            String globalHandlerClass = attributes.getValue("class");
            if (globalHandlerClass != null) {
                if ("in".equalsIgnoreCase(globalHandlerType)) {
                    this.globalInHandlers.add(globalHandlerClass);
                } else if ("out".equalsIgnoreCase(globalHandlerType)) {
                    this.globalOutHandlers.add(globalHandlerClass);
                }
            }
        } else if ("service".equals(qName)) {
            this.type = attributes.getValue("type");
            this.current = attributes.getValue("name");
            this.isPersistent = Boolean.parseBoolean(attributes.getValue("persistent"));
            this.wsdlLocation = attributes.getValue("wsdlLocation");
            if (attributes.getValue("enabled") != null) {
                this.enabled = Boolean.parseBoolean(attributes.getValue("enabled"));
            }
        } else if ("interface".equals(localName)) {
            this.iFace = attributes.getValue("class");
        } else if ("implementation".equals(localName)) {
            this.clazz = attributes.getValue("class");
        } else if ("jarFileInfo".equals(localName)) {
            this.jarFilePath = attributes.getValue("path");
        } else if ("initTask".equals(localName)) {
            this.initTask = attributes.getValue("class");
        } else if ("shutdownTask".equals(localName)) {
            this.shutdownTask = attributes.getValue("class");
        } else if ("monitor".equals(localName)) {
            this.monitorName = attributes.getValue("name");
        } else if ("handler".equals(localName)) {
            this.handlerType = attributes.getValue("type");
            this.handlerClass = attributes.getValue("class");
            if (this.handlerClass != null) {
                if ("in".equalsIgnoreCase(this.handlerType)) {
                    this.inhandlers.add(this.handlerClass);
                } else if ("out".equalsIgnoreCase(this.handlerType)) {
                    this.outhandlers.add(this.handlerClass);
                }
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException, ServiceDeploymentException {
        if ("service".equals(localName)) {
            this.doDeployService();
        } else if ("monitor".equals(localName)) {
            this.kernel.registerMonitorMetric(this.monitorName);
        }
    }

    private void doDeployService() {
        block14: {
            try {
                if (this.enabled) {
                    if (this.kernel.getService(this.current) == null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Configuring service " + this.current + ".\nService interface: " + this.iFace + ", implementation: " + this.clazz + ", isPersistent=" + this.isPersistent));
                        }
                        this.deployService();
                        if (this.initTask != null) {
                            Class<?> t = Class.forName(this.initTask);
                            Runnable r = (Runnable)this.kernel.load(t);
                            this.initTasks.add(r);
                        }
                    }
                    break block14;
                }
                logger.info((Object)("Disabling service <" + this.current + ">"));
                Service s = this.kernel.getService(this.current);
                if (s == null) break block14;
                try {
                    if (this.shutdownTask != null) {
                        Class<?> t = Class.forName(this.shutdownTask);
                        try {
                            ((Runnable)this.kernel.load(t)).run();
                        }
                        catch (Exception ex) {
                            Log.logException((String)("Error running shutdown task <" + this.shutdownTask + ">"), (Throwable)ex, (Logger)logger);
                        }
                    }
                    s.stop();
                }
                catch (Exception ex) {
                    Log.logException((String)("Cannot un-register service <" + this.current + ">"), (Throwable)ex, (Logger)logger);
                }
            }
            catch (Exception ex) {
                String msg = "Cannot deploy service <" + this.current + ">";
                Log.logException((String)msg, (Throwable)ex, (Logger)logger);
                throw new ServiceDeploymentException(msg, ex);
            }
            finally {
                this.reInit();
            }
        }
    }

    private void doRegisterServiceFactory(String clazz) throws ServiceDeploymentException {
        try {
            ServiceFactory sf = (ServiceFactory)Class.forName(clazz).newInstance();
            this.kernel.registerServiceFactory(sf);
        }
        catch (Exception ex) {
            throw new ServiceDeploymentException("Can't register '" + clazz + "' as a service factory.", ex);
        }
    }

    protected void reInit() {
        this.inhandlers.clear();
        this.outhandlers.clear();
        this.wsdlLocation = null;
        this.isPersistent = false;
        this.enabled = true;
        this.jarFilePath = null;
        this.clazz = null;
        this.iFace = null;
        this.type = null;
    }

    protected Service deployService() throws Exception {
        ServiceConfiguration config = new ServiceConfiguration(this.kernel, this.current);
        if (this.type == null) {
            this.type = "xfire";
        }
        config.setType(this.type);
        ArrayList<String> effectiveInhandlers = new ArrayList<String>();
        effectiveInhandlers.addAll(this.globalInHandlers);
        effectiveInhandlers.addAll(this.inhandlers);
        config.setInHandlers(effectiveInhandlers);
        ArrayList<String> effectiveOuthandlers = new ArrayList<String>();
        effectiveOuthandlers.addAll(this.globalOutHandlers);
        effectiveOuthandlers.addAll(this.outhandlers);
        config.setOutHandlers(effectiveOuthandlers);
        config.setInterfaceClass(this.iFace);
        config.setImplementationClass(this.clazz);
        config.setWsdlLocation(this.wsdlLocation);
        config.setPersistent(this.isPersistent);
        ServiceClassLoader classLoader = new ServiceClassLoader();
        config.setClassLoader(classLoader);
        if (this.isPersistent) {
            this.kernel.getContainerProperties().setProperty("unicore.wsrflite.isPersistent." + this.current, "true");
        }
        ServiceFactory f = this.kernel.getServiceFactory(this.type);
        Service service = f.build(config);
        this.kernel.getDeploymentManager().deployService(service);
        return null;
    }

    @Override
    public List<Runnable> getInitTasks() {
        return this.initTasks;
    }

    @Override
    public long getLastConfigFileUpdateTime() {
        return this.configFile != null ? this.configFile.lastModified() : -1L;
    }
}

