/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.utils;

import de.fzj.unicore.wsrflite.ContainerProperties;
import java.net.URI;
import java.net.URL;
import java.util.UUID;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;

public class Utilities {
    protected Utilities() {
    }

    public static String newUniqueID() {
        return UUID.randomUUID().toString();
    }

    public static String extractServiceName(String url) {
        try {
            URI u = new URI(url);
            String[] path = u.getPath().split("/");
            return path[path.length - 1];
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean validateIntegerRange(String value, int minValue, int maxValue) {
        try {
            if (value == null) {
                return false;
            }
            Integer i = Integer.parseInt(value);
            if (i < minValue || i > maxValue) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static String getPhysicalServerAddress(ContainerProperties cfg, boolean isSSLEnabled) {
        String host = cfg.getValue("host");
        String port = cfg.getValue("port");
        String proto = "http";
        if (isSSLEnabled) {
            proto = "https";
        }
        return proto + "://" + host + ":" + port;
    }

    public static String getGatewayAddress(ContainerProperties cfg) throws Exception {
        URL u = new URL(cfg.getValue("baseurl"));
        return u.toString().split(u.getPath())[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String extractElementTextAsString(XmlObject source) {
        XmlCursor c = null;
        try {
            c = source.newCursor();
            while (c.hasNextToken()) {
                if (!c.toNextToken().equals(XmlCursor.TokenType.TEXT)) continue;
                String string = c.getChars();
                return string;
            }
            String string = "";
            return string;
        }
        finally {
            try {
                c.dispose();
            }
            catch (Exception e) {}
        }
    }
}

