/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.security.util;

import de.fzj.unicore.wsrflite.security.IAttributeSource;
import de.fzj.unicore.wsrflite.security.IAttributeSourceBase;
import de.fzj.unicore.wsrflite.security.IDynamicAttributeSource;
import eu.unicore.util.Log;
import eu.unicore.util.configuration.ConfigurationException;
import eu.unicore.util.configuration.PropertyGroupHelper;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class AttributeSourceConfigurator {
    private static final Logger logger = Log.getLogger((String)"unicore.security", AttributeSourceConfigurator.class);

    public static IAttributeSource configureAttributeSource(String name, String subPrefix, Properties properties) {
        IAttributeSource auth;
        String dotName = "container.security." + subPrefix + "." + name + ".";
        String clazz = properties.getProperty(dotName + "class");
        if (clazz == null) {
            throw new IllegalArgumentException("Inconsistent attribute sources chain definition: expected <" + dotName + "class> property with attribute source implementation.");
        }
        logger.debug((Object)("Creating attribute source " + name + " served by class <" + clazz + ">"));
        try {
            auth = (IAttributeSource)Class.forName(clazz).newInstance();
        }
        catch (Exception e) {
            throw new ConfigurationException("Can't load attribute source implementation, configured as <" + clazz + ">: " + e.toString(), (Throwable)e);
        }
        AttributeSourceConfigurator.configureCommon(dotName, properties, auth);
        return auth;
    }

    public static IDynamicAttributeSource configureDynamicAttributeSource(String name, String subPrefix, Properties properties) {
        IDynamicAttributeSource auth;
        String dotName = "container.security." + subPrefix + "." + name + ".";
        String clazz = properties.getProperty(dotName + "class");
        if (clazz == null) {
            throw new IllegalArgumentException("Inconsistent dynamic attribute sources chain definition: expected <" + dotName + "class> property with dynamic attribute source implementation.");
        }
        logger.debug((Object)("Creating dynamic attribute source " + name + " served by class <" + clazz + ">"));
        try {
            auth = (IDynamicAttributeSource)Class.forName(clazz).newInstance();
        }
        catch (Exception e) {
            throw new ConfigurationException("Can't load dynamic attribute source implementation, configured as <" + clazz + ">: " + e.toString(), (Throwable)e);
        }
        AttributeSourceConfigurator.configureCommon(dotName, properties, auth);
        return auth;
    }

    private static void configureCommon(String dotName, Properties properties, IAttributeSourceBase auth) {
        Map params = new PropertyGroupHelper((Map)properties, new String[]{dotName}).getFilteredMap();
        params.remove(dotName + "class");
        AttributeSourceConfigurator.mapParams(auth, params);
        Method propsSetter = AttributeSourceConfigurator.findSetter(auth.getClass(), "properties");
        if (propsSetter != null && propsSetter.getParameterTypes()[0].isAssignableFrom(Properties.class)) {
            try {
                propsSetter.invoke((Object)auth, properties);
            }
            catch (Exception e) {
                throw new RuntimeException("Bug: can't set properties on chain: " + e.toString(), e);
            }
        }
    }

    private static void mapParams(Object obj, Map<String, String> params) {
        Class<?> clazz = obj.getClass();
        for (Map.Entry<String, String> en : params.entrySet()) {
            String s = en.getKey();
            String paramName = s.substring(s.lastIndexOf(".") + 1);
            Method m = AttributeSourceConfigurator.findSetter(clazz, paramName);
            if (m == null) {
                logger.warn((Object)("Can't map parameter <" + s + ">"));
                continue;
            }
            try {
                AttributeSourceConfigurator.setParam(obj, m, en.getValue());
            }
            catch (Exception ex) {
                logger.warn((Object)("Can't set value <" + en.getValue() + "> for parameter <" + s + ">"));
            }
        }
    }

    private static Method findSetter(Class<?> clazz, String paramName) {
        for (Method m : clazz.getMethods()) {
            if (!m.getName().equalsIgnoreCase("set" + paramName) || m.getParameterTypes().length <= 0) continue;
            return m;
        }
        return null;
    }

    private static void setParam(Object obj, Method m, String valueString) throws Exception {
        Object arg = valueString;
        if (m.getParameterTypes()[0].isAssignableFrom(Integer.TYPE)) {
            arg = Integer.parseInt(valueString);
        } else if (m.getParameterTypes()[0].isAssignableFrom(Integer.class)) {
            arg = Integer.parseInt(valueString);
        } else if (m.getParameterTypes()[0].isAssignableFrom(Long.TYPE)) {
            arg = Long.parseLong(valueString);
        } else if (m.getParameterTypes()[0].isAssignableFrom(Long.class)) {
            arg = Long.parseLong(valueString);
        } else if (m.getParameterTypes()[0].isAssignableFrom(Boolean.TYPE)) {
            arg = Boolean.valueOf(valueString);
        } else if (m.getParameterTypes()[0].isAssignableFrom(Boolean.class)) {
            arg = Boolean.valueOf(valueString);
        }
        m.invoke(obj, arg);
    }
}

