/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.security;

import eu.unicore.security.Client;
import eu.unicore.security.SecurityTokens;
import eu.unicore.util.httpclient.ETDClientSettings;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.util.List;
import javax.security.auth.x500.X500Principal;

public class ETDAssertionForwarding {
    public static boolean configureETD(Client client, IClientConfiguration properties) {
        SecurityTokens tokens = client.getSecurityTokens();
        if (tokens == null) {
            return false;
        }
        List tds = tokens.getTrustDelegationTokens();
        if (tds == null || tds.size() == 0) {
            return false;
        }
        ETDClientSettings etdSettings = properties.getETDSettings();
        etdSettings.setExtendTrustDelegation(false);
        etdSettings.setTrustDelegationTokens(tds);
        etdSettings.setRequestedUser(tokens.getEffectiveUserName().getName());
        return true;
    }

    public static boolean configureETDChainExtension(Client client, IClientConfiguration config, X500Principal receiver) {
        boolean ret = ETDAssertionForwarding.configureETD(client, config);
        if (!ret) {
            return false;
        }
        ETDClientSettings etdSettings = config.getETDSettings();
        etdSettings.setExtendTrustDelegation(true);
        etdSettings.setIssuerCertificateChain(config.getCredential().getCertificateChain());
        etdSettings.setReceiver(receiver);
        return true;
    }
}

