/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.security;

import de.fzj.unicore.wsrflite.security.util.ResourceDescriptor;
import eu.unicore.security.AuthenticationException;
import eu.unicore.security.SecurityTokens;
import eu.unicore.security.SignatureStatus;
import eu.unicore.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public class DSignCheck {
    private static final Logger logger = Log.getLogger((String)"unicore.security", DSignCheck.class);
    private final List<String> actionsRequiringSignatures = new ArrayList<String>();
    private boolean dsigCheckingEnabled;

    public DSignCheck(boolean dsigCheckingEnabled) {
        logger.debug((Object)"Initialise checking of digital signature status.");
        this.dsigCheckingEnabled = dsigCheckingEnabled;
    }

    public void addSOAPActionsRequiringSignatures(String ... actions) {
        this.actionsRequiringSignatures.addAll(Arrays.asList(actions));
    }

    public boolean needSignature(String action) {
        if (action == null) {
            return false;
        }
        if (!this.dsigCheckingEnabled) {
            return false;
        }
        boolean b = this.actionsRequiringSignatures.contains(action);
        logger.debug((Object)("Checking signatures for <" + action + "> = " + b));
        return b;
    }

    public void checkDigitalSignature(SecurityTokens tokens, String action, ResourceDescriptor d) throws AuthenticationException {
        String method = null;
        if (d != null && d.getServiceName() != null && action != null) {
            method = d.getServiceName() + "." + action;
        }
        String soapAction = (String)tokens.getContext().get("REQUEST.soapAction");
        if (SignatureStatus.WRONG.equals((Object)tokens.getMessageSignatureStatus())) {
            String msg = "Non repudiation/integrity check failed on <" + d.toString() + ">: digital signature is present but INVALID";
            logger.info((Object)msg);
            throw new AuthenticationException(msg);
        }
        if (SignatureStatus.OK.equals((Object)tokens.getMessageSignatureStatus())) {
            logger.debug((Object)("Non repudiation/integrity check was SUCCESSFUL on <" + d.toString() + ">"));
            return;
        }
        logger.debug((Object)("Checking whether signature verification is mandatory for invocation of [soap action=<" + soapAction + "> or method=<" + method + ">]"));
        if (!this.needSignature(soapAction) && !this.needSignature(method)) {
            return;
        }
        logger.debug((Object)("Signature verification is mandatory for invocation of [soap action=<" + soapAction + "> or method=<" + method + ">]"));
        String msg = "Non repudiation/integrity check failed on <" + d.toString() + ">: signature is required for <" + action + ">";
        logger.info((Object)msg);
        throw new AuthenticationException(msg);
    }
}

