/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.security;

import de.fzj.unicore.wsrflite.security.DefaultContainerSecurityConfiguration;
import de.fzj.unicore.wsrflite.security.IAttributeSource;
import de.fzj.unicore.wsrflite.security.IDynamicAttributeSource;
import de.fzj.unicore.wsrflite.security.NullAttributeSource;
import de.fzj.unicore.wsrflite.security.pdp.AcceptingPdp;
import de.fzj.unicore.wsrflite.security.pdp.UnicoreXPDP;
import de.fzj.unicore.wsrflite.security.util.AttributeSourcesChain;
import de.fzj.unicore.wsrflite.security.util.DynamicAttributeSourcesChain;
import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.emi.security.authn.x509.impl.CertificateUtils;
import eu.unicore.security.canl.AuthnAndTrustProperties;
import eu.unicore.security.canl.IAuthnAndTrustConfiguration;
import eu.unicore.security.canl.LoggingStoreUpdateListener;
import eu.unicore.security.canl.TruststoreProperties;
import eu.unicore.util.Log;
import eu.unicore.util.configuration.ConfigurationException;
import eu.unicore.util.configuration.DocumentationReferenceMeta;
import eu.unicore.util.configuration.DocumentationReferencePrefix;
import eu.unicore.util.configuration.PropertiesHelper;
import eu.unicore.util.configuration.PropertyMD;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ContainerSecurityProperties
extends DefaultContainerSecurityConfiguration {
    private static final Logger logger = Log.getLogger((String)"unicore.security", ContainerSecurityProperties.class);
    private static final Logger propsLogger = Log.getLogger((String)"unicore.configuration", ContainerSecurityProperties.class);
    @DocumentationReferencePrefix
    public static final String PREFIX = "container.security.";
    public static final String PROP_SSL_ENABLED = "sslEnabled";
    public static final String PROP_CHECKACCESS = "accesscontrol";
    public static final String PROP_CHECKACCESS_PDP = "accesscontrol.pdp";
    public static final String PROP_CHECKACCESS_PDPCONFIG = "accesscontrol.pdpConfig";
    public static final String PROP_GATEWAY_AUTHN = "gateway.enable";
    public static final String PROP_CHECK_CONSIGNOR_SIGNATURE = "gateway.checkSignature";
    public static final String PROP_GATEWAY_CERT = "gateway.certificate";
    public static final String PROP_AUTOREGISTER_WITH_GATEWAY = "gateway.registration";
    public static final String PROP_AUTOREGISTER_WITH_GATEWAY_UPDATE = "gateway.registrationUpdateInterval";
    public static final String PROP_GATEWAY_WAIT = "gateway.waitOnStartup";
    public static final String PROP_GATEWAY_WAITTIME = "gateway.waitTime";
    public static final String PROP_REQUIRE_SIGNATURES = "signatures";
    public static final String PROP_DEFAULT_VOS = "defaultVOs.";
    public static final String PROP_AIP_PREFIX = "attributes";
    public static final String PROP_AIP_ORDER = "attributes.order";
    public static final String PROP_AIP_COMBINING_POLICY = "attributes.combiningPolicy";
    public static final String PROP_DAP_PREFIX = "dynamicAttributes";
    public static final String PROP_DAP_ORDER = "dynamicAttributes.order";
    public static final String PROP_DAP_COMBINING_POLICY = "dynamicAttributes.combiningPolicy";
    public static final String PROP_SEPARATE_ETD_TRUSTSTORE = "separateDelegationTruststore";
    public static final String PROP_ETD_TRUSTSTORE_PFX = "delegationTruststore.";
    @DocumentationReferenceMeta
    public static final Map<String, PropertyMD> META = new HashMap<String, PropertyMD>();
    private PropertiesHelper properties;
    private AuthnAndTrustProperties authAndTrustProperties = null;

    public ContainerSecurityProperties(Properties p) throws ConfigurationException {
        this(p, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ContainerSecurityProperties(Properties source, IAuthnAndTrustConfiguration authAndTrust) throws ConfigurationException {
        boolean trustNeeded;
        this.properties = new PropertiesHelper(PREFIX, source, META, propsLogger);
        this.setSslEnabled(this.properties.getBooleanValue(PROP_SSL_ENABLED));
        this.setAccessControlEnabled(this.properties.getBooleanValue(PROP_CHECKACCESS));
        this.setSigningRequired(this.properties.getBooleanValue(PROP_REQUIRE_SIGNATURES));
        this.setGatewayAuthnEnabled(this.properties.getBooleanValue(PROP_GATEWAY_AUTHN));
        boolean credNeeded = this.isSslEnabled();
        boolean bl = trustNeeded = this.isSslEnabled() || this.isAccessControlEnabled() || this.isSigningRequired() || this.isGatewayAuthnEnabled();
        if (authAndTrust == null) {
            this.authAndTrustProperties = new AuthnAndTrustProperties(source, "container.security.truststore.", "container.security.credential.", !trustNeeded, !credNeeded);
            authAndTrust = this.authAndTrustProperties;
        }
        this.setValidator(authAndTrust.getValidator());
        this.setCredential(authAndTrust.getCredential());
        if (this.properties.getBooleanValue(PROP_SEPARATE_ETD_TRUSTSTORE).booleanValue()) {
            TruststoreProperties etdTrustProperties = new TruststoreProperties(source, Collections.singleton(new LoggingStoreUpdateListener()), "container.security.delegationTruststore.");
            this.setETDValidator((X509CertChainValidator)etdTrustProperties.getValidator());
        } else {
            this.setETDValidator((X509CertChainValidator)this.getValidator());
        }
        List defaultVos = this.properties.getListOfValues(PROP_DEFAULT_VOS);
        this.setDefaultVOs(defaultVos.toArray(new String[0]));
        if (this.isGatewayAuthnEnabled()) {
            logger.info((Object)"Enabling gateway support");
            this.setGatewayRegistrationEnabled(this.properties.getBooleanValue(PROP_AUTOREGISTER_WITH_GATEWAY));
            if (this.isGatewayRegistrationEnabled()) {
                this.setGatewayRegistrationUpdateInterval(this.properties.getIntValue(PROP_AUTOREGISTER_WITH_GATEWAY_UPDATE));
            }
            this.setGatewayWaitingEnabled(this.properties.getBooleanValue(PROP_GATEWAY_WAIT));
            if (this.isGatewayWaitingEnabled()) {
                this.setGatewayWaitTime(this.properties.getIntValue(PROP_GATEWAY_WAITTIME));
            }
            this.setGatewaySignatureCheckingEnabled(this.properties.getBooleanValue(PROP_CHECK_CONSIGNOR_SIGNATURE));
            if (this.isGatewaySignatureCheckingEnabled()) {
                String certFile = this.properties.getValue(PROP_GATEWAY_CERT);
                if (certFile == null) {
                    if (!this.isGatewayWaitingEnabled()) throw new ConfigurationException("Gateway's assertion checking is enabled but neither the gateway's certificate is configured nor its autodetection is turned on.");
                    logger.info((Object)"Gateway's assertion checking is enabled but gateway's certificate is not configured. Will try to discover it later by connecting to gateway.");
                } else {
                    this.setGatewayCertificate(this.loadGatewayCertificate(certFile));
                }
            } else {
                logger.info((Object)"IMPORTANT! Gateway assertions verification is turned OFF. This is OK only if your UNICORE/X installation is protected by a firewall, and the only physical way of accessing it is through the gateway. If this is not true then you SHOULD turn on the gateway assertion verification to prevent unauthorized access.");
            }
        } else {
            logger.info((Object)"Gateway support is turned OFF globally, none of gateway settings will be used.");
            this.setGatewayRegistrationEnabled(false);
            this.setGatewayWaitingEnabled(false);
        }
        this.setAip(this.createAttributeSource(source));
        this.setDap(this.createDynamicAttributeSource(source));
        this.setPdp(this.createPDP(this.properties));
    }

    public void updateProperties(Properties newProperties) {
        this.properties.setProperties(newProperties);
        if (this.authAndTrustProperties != null && this.authAndTrustProperties.getTruststoreProperties() != null) {
            this.authAndTrustProperties.getTruststoreProperties().setProperties(newProperties);
        }
        if (this.getValidator() == null && this.isAccessControlEnabled()) {
            logger.warn((Object)"Can't enable access control without truststore settings.");
            this.setAccessControlEnabled(false);
        }
    }

    private X509Certificate loadGatewayCertificate(String certFile) {
        CertificateUtils.Encoding encoding = certFile.endsWith(".der") ? CertificateUtils.Encoding.DER : CertificateUtils.Encoding.PEM;
        InputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(certFile));
            X509Certificate x509Certificate = CertificateUtils.loadCertificate((InputStream)is, (CertificateUtils.Encoding)encoding);
            return x509Certificate;
        }
        catch (IOException e) {
            throw new ConfigurationException("Can not load the gateway's certificate '" + certFile + "'", (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private IAttributeSource createAttributeSource(Properties raw) throws ConfigurationException {
        String order = this.properties.getValue(PROP_AIP_ORDER);
        if (order == null) {
            logger.info((Object)"No attribute source is defined in the configuration, users won't have any authorisation attributes assigned");
            return new NullAttributeSource();
        }
        logger.debug((Object)"Creating main attribute sources chain");
        AttributeSourcesChain ret = new AttributeSourcesChain();
        ret.setCombiningPolicy(this.properties.getValue(PROP_AIP_COMBINING_POLICY));
        ret.setOrder(order);
        ret.setProperties(raw);
        ret.configure(null);
        ret.checkVOConsistency();
        return ret;
    }

    private IDynamicAttributeSource createDynamicAttributeSource(Properties raw) throws ConfigurationException {
        String order = this.properties.getValue(PROP_DAP_ORDER);
        if (order == null) {
            logger.info((Object)"No dynamic attribute source is defined in the configuration, users won't have any dynamic incarnation attributes assigned");
            return new NullAttributeSource();
        }
        logger.debug((Object)"Creating the main dynamic attribute sources chain");
        DynamicAttributeSourcesChain ret = new DynamicAttributeSourcesChain();
        ret.setCombiningPolicy(this.properties.getValue(PROP_DAP_COMBINING_POLICY));
        ret.setOrder(order);
        ret.setProperties(raw);
        ret.configure(null);
        return ret;
    }

    private UnicoreXPDP createPDP(PropertiesHelper properties) throws ConfigurationException {
        Class<?> pdpClazz;
        if (!this.isAccessControlEnabled()) {
            return new AcceptingPdp();
        }
        if (properties.isSet(PROP_CHECKACCESS_PDPCONFIG)) {
            String conf = properties.getValue(PROP_CHECKACCESS_PDPCONFIG);
            this.setPdpConfigurationFile(conf);
        }
        if ((pdpClazz = properties.getClassValue(PROP_CHECKACCESS_PDP, UnicoreXPDP.class)) == null) {
            try {
                pdpClazz = Class.forName("eu.unicore.uas.pdp.local.LocalHerasafPDP");
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException("The default eu.unicore.uas.pdp.local.LocalHerasafPDP PDP is not available and PDP was not configured.");
            }
        }
        try {
            Constructor<?> constructor = pdpClazz.getConstructor(new Class[0]);
            logger.info((Object)("Using PDP class <" + pdpClazz.getName() + ">"));
            UnicoreXPDP pdp = (UnicoreXPDP)constructor.newInstance(new Object[0]);
            return pdp;
        }
        catch (Exception e) {
            throw new ConfigurationException("Can't create a PDP.", (Throwable)e);
        }
    }

    @Override
    public boolean isAccessControlEnabled(String service) {
        return this.properties.getSubkeyBooleanValue(PROP_CHECKACCESS, service);
    }

    static {
        META.put(PROP_SSL_ENABLED, new PropertyMD("true").setDescription("Controls whether secure SSL mode is enabled."));
        META.put(PROP_CHECKACCESS, new PropertyMD("true").setUpdateable().setCanHaveSubkeys().setDescription("Controls whether access checking (authorisation) is enabled. Can be used per service after adding dot and service name to the property key."));
        META.put(PROP_CHECKACCESS_PDP, new PropertyMD().setClass(UnicoreXPDP.class).setDescription("Controls which Policy Decision Point (PDP, the authorisation engine) should be used. Default value is determined as follows: if eu.unicore.uas.pdp.local.LocalHerasafPDP is available then it is used. If not then this option becomes mandatory."));
        META.put(PROP_CHECKACCESS_PDPCONFIG, new PropertyMD().setPath().setDescription("Path of the PDP configuration file"));
        META.put(PROP_DEFAULT_VOS, new PropertyMD("").setList(true).setDescription("List of default VOs, which should be assigned for a request without a VO set. The first VO on the list where the user is member will be used."));
        META.put(PROP_GATEWAY_AUTHN, new PropertyMD("true").setDescription("Whether to accpet gateway-based authentication. Note that if it is enabled either the site must be secured (usually via firewall) to disable non-gateway access or the verification of gateway's assertions must be enabled."));
        META.put(PROP_CHECK_CONSIGNOR_SIGNATURE, new PropertyMD("true").setDescription("Controls whether gateway's authentication assertions are verified."));
        META.put(PROP_GATEWAY_CERT, new PropertyMD().setPath().setDescription("Path to gateway's certificate file in PEM or DER format. Note that DER format is used only for files with '.der' extension. It is used only for gateway's authentication assertions verification (if enabled). Note that this is not needed to set it if waiting for gateway on startup is turned on."));
        META.put(PROP_AUTOREGISTER_WITH_GATEWAY, new PropertyMD("false").setDescription("Whther the site should try to autoregister itself with the Gateway. This must be also configured on the Gateway side."));
        META.put(PROP_AUTOREGISTER_WITH_GATEWAY_UPDATE, new PropertyMD("30").setMin(10L).setDescription("How often the automatic gateway registration should be refreshed."));
        META.put(PROP_GATEWAY_WAITTIME, new PropertyMD("180").setPositive().setDescription("Controls for how long to wait for the gateway on startup (in seconds)."));
        META.put(PROP_GATEWAY_WAIT, new PropertyMD("true").setDescription("Controls whether to wait for the gateway at startup."));
        META.put(PROP_REQUIRE_SIGNATURES, new PropertyMD("true").setDescription("Controls whther signatures (providing non-repudiation guarantees) on key requests should be required."));
        META.put(PROP_AIP_PREFIX, new PropertyMD().setCanHaveSubkeys().setDescription("Prefix used for configurations of particular attribute sources."));
        META.put(PROP_AIP_ORDER, new PropertyMD().setDescription("Attribute sources in invocation order."));
        META.put(PROP_AIP_COMBINING_POLICY, new PropertyMD("MERGE_LAST_OVERRIDES").setDescription("What algorithm should be used for combining the attributes from multiple attribute sources (if more then one is defined)."));
        META.put(PROP_DAP_PREFIX, new PropertyMD().setCanHaveSubkeys().setDescription("Prefix used for configurations of particular dynamic attribute sources."));
        META.put(PROP_DAP_ORDER, new PropertyMD().setDescription("Dynamic attribute sources in invocation order."));
        META.put(PROP_DAP_COMBINING_POLICY, new PropertyMD("MERGE_LAST_OVERRIDES").setDescription("What algorithm should be used for combining the attributes from multiple dynamic attribute sources (if more then one is defined)."));
        META.put(PROP_SEPARATE_ETD_TRUSTSTORE, new PropertyMD("false").setDescription("Significant for XSEDE integration: when turned on, allows for using a separate truststore for delegation checking then the one used for SSL connections checking."));
        META.put(PROP_ETD_TRUSTSTORE_PFX, new PropertyMD().setCanHaveSubkeys().setDescription("When separateDelegationTruststore is true allows to configure the trust delegation truststore (using normal truststore properties with this prefix)."));
        META.put("truststore.", new PropertyMD().setCanHaveSubkeys().setDescription("Properties with this prefix are used to configure container's trust settings and certificates validation. See separate documentation for details."));
        META.put("credential.", new PropertyMD().setCanHaveSubkeys().setDescription("Properties with this prefix are used to configure the credential used by the container. See separate documentation for details."));
    }
}

