/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.persistence;

import de.fzj.unicore.persist.impl.LockSupport;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.persistence.InMemory;
import de.fzj.unicore.wsrflite.persistence.PersistenceSettings;
import de.fzj.unicore.wsrflite.persistence.Store;
import eu.unicore.util.Log;
import eu.unicore.util.configuration.ConfigurationException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class PersistenceManager {
    private static final Logger logger = Log.getLogger((String)"unicore.wsrflite.persistence", PersistenceManager.class);
    private Class<?> persistClass = null;
    private boolean haveInit = false;
    final Map<String, Store> persistMap = Collections.synchronizedMap(new HashMap());
    private final Map<Class<?>, PersistenceSettings> persistenceSettings = Collections.synchronizedMap(new HashMap());
    private LockSupport lockSupport;
    private final Kernel kernel;

    public PersistenceManager(Kernel kernel) {
        this.kernel = kernel;
    }

    synchronized void init() {
        if (!this.haveInit) {
            this.haveInit = true;
            try {
                String clazz = this.kernel.getContainerProperties().getValue("wsrf.persistence.persist");
                this.persistClass = Class.forName(clazz);
                logger.info((Object)("Using '" + this.persistClass.getName() + "' for permanent storage."));
            }
            catch (Exception e) {
                String message = Log.createFaultMessage((String)"Error configuring persistence! Please check the configuration and the latest documentation.", (Throwable)e);
                throw new ConfigurationException(message, (Throwable)e);
            }
        }
    }

    public void persist(Resource inst) throws Exception {
        this.getPersist(inst.getServiceName()).persist(inst);
        inst.clearChangeFlag();
    }

    public synchronized Store getPersist(String serviceName) {
        Store p;
        if (this.persistClass == null) {
            this.init();
        }
        if ((p = this.persistMap.get(serviceName)) == null) {
            try {
                boolean doPersist = this.kernel.getContainerProperties().getSubkeyBooleanValue("unicore.wsrflite.isPersistent", serviceName);
                logger.info((Object)("Persistence=" + doPersist));
                p = doPersist ? (Store)this.persistClass.newInstance() : (Store)InMemory.class.newInstance();
                p.init(this.kernel, serviceName);
                this.persistMap.put(serviceName, p);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot create instance of persistence class", e);
            }
        }
        return p;
    }

    public synchronized PersistenceSettings getPersistenceSettings(Class<?> service) {
        PersistenceSettings ps = this.persistenceSettings.get(service);
        if (ps == null) {
            ps = PersistenceSettings.get(service);
            this.persistenceSettings.put(service, ps);
        }
        return ps;
    }

    public void removePersist(String serviceName) {
        this.persistMap.remove(serviceName);
    }

    public synchronized LockSupport getLockSupport() {
        if (this.lockSupport == null) {
            String config = this.kernel.getPersistenceProperties().getValue("cluster.config");
            this.lockSupport = new LockSupport(config, "__wsrflite_internal__");
        }
        return this.lockSupport;
    }
}

