/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.persistence;

import de.fzj.unicore.persist.DataVersionException;
import de.fzj.unicore.persist.Persist;
import de.fzj.unicore.persist.PersistenceException;
import de.fzj.unicore.persist.PersistenceFactory;
import de.fzj.unicore.persist.PersistenceProperties;
import de.fzj.unicore.persist.impl.DeserialisationErrorHandler;
import de.fzj.unicore.persist.impl.PersistImpl;
import de.fzj.unicore.persist.impl.PersistenceDescriptor;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.ThreadingServices;
import de.fzj.unicore.wsrflite.exceptions.UnableToSetTerminationTimeException;
import de.fzj.unicore.wsrflite.persistence.AbstractStore;
import de.fzj.unicore.wsrflite.persistence.InstanceInfoBean;
import de.fzj.unicore.wsrflite.persistence.ResourceBean;
import eu.unicore.util.Log;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;

public class Persistence
extends AbstractStore {
    private static final Logger logger = Log.getLogger((String)"unicore.wsrflite.persistence", Persistence.class);
    private Persist<ResourceBean> p;
    private PersistenceProperties persistenceProperties;
    private static Persist<InstanceInfoBean> terminationTime;
    private Map<String, Serializable> persistentInformation;
    private DeserialisationErrorHandler errorHandler;
    private volatile boolean isShutdown = false;
    private static final String info_id = "___internal_service_information___";

    @Override
    public void init(Kernel kernel, String serviceName) {
        super.init(kernel, serviceName);
        this.persistenceProperties = kernel.getPersistenceProperties();
        try {
            PersistenceDescriptor pd = PersistenceDescriptor.get(ResourceBean.class);
            pd.setTableName(serviceName);
            this.p = PersistenceFactory.get((PersistenceProperties)this.persistenceProperties).getPersist(ResourceBean.class, pd);
            this.checkVersion(this.p, serviceName);
            this.initTerminationTimeStore();
        }
        catch (Exception e) {
            Log.logException((String)("Error initialising database for <" + serviceName + ">"), (Throwable)e, (Logger)logger);
            this.p = null;
            terminationTime = null;
            throw new RuntimeException(e);
        }
    }

    protected void checkVersion(Persist<?> p, String tableName) throws PersistenceException {
        block8: {
            Set ids = p.getIDs();
            try {
                if (ids.size() <= 0) break block8;
                p.read((String)ids.iterator().next());
            }
            catch (DataVersionException v) {
                if (!Boolean.getBoolean("unicore.update.force")) {
                    throw v;
                }
                logger.info((Object)("Removing unreadable data from table " + tableName));
                for (String id : ids) {
                    try {
                        p.read(id);
                    }
                    catch (DataVersionException ex) {
                        try {
                            p.remove(id);
                        }
                        catch (PersistenceException pe) {
                            Log.logException((String)("Error removing " + id), (Throwable)pe);
                        }
                    }
                }
            }
        }
    }

    @Override
    public Set<String> getUniqueIDs() throws PersistenceException {
        Set res = this.p.getIDs();
        res.remove(info_id);
        return res;
    }

    @Override
    protected void _persist(ResourceBean data) throws PersistenceException {
        this.p.write((Object)data);
    }

    @Override
    protected ResourceBean _read(String uniqueID) throws PersistenceException {
        return (ResourceBean)this.p.read(uniqueID);
    }

    @Override
    protected ResourceBean _getForUpdate(String uniqueID, long time, TimeUnit timeUnit) throws PersistenceException, InterruptedException, TimeoutException {
        return (ResourceBean)this.p.getForUpdate(uniqueID, time, timeUnit);
    }

    @Override
    protected void _remove(String uniqueID) throws PersistenceException {
        try {
            this.p.remove(uniqueID);
        }
        catch (Exception e) {
            Log.logException((String)"Error", (Throwable)e, (Logger)logger);
        }
        try {
            terminationTime.remove(uniqueID);
        }
        catch (Exception e) {
            Log.logException((String)"Error removing TT entry", (Throwable)e, (Logger)logger);
        }
    }

    @Override
    public void purgePersistentData() {
        this.p.purge();
    }

    @Override
    protected void _unlock(ResourceBean dao) throws PersistenceException {
        this.p.unlock((Object)dao);
    }

    public void removeAll() throws PersistenceException {
        this.p.removeAll();
    }

    @Override
    public void shutdown() {
        try {
            this.writePersistentInformation();
            this.isShutdown = true;
            this.p.shutdown();
        }
        catch (PersistenceException pe) {
            logger.error((Object)("Error shutting down persistence for <" + this.getServiceName() + ">"), (Throwable)pe);
        }
    }

    @Override
    public Map<String, Calendar> getTerminationTimes() {
        ConcurrentHashMap<String, Calendar> tt = new ConcurrentHashMap<String, Calendar>();
        try {
            Map tts = terminationTime.getColumnValues("millis");
            for (Map.Entry e : tts.entrySet()) {
                tt.put((String)e.getKey(), InstanceInfoBean.getCalendar((String)e.getValue()));
            }
        }
        catch (PersistenceException pe) {
            Log.logException((String)"Error getting termination times from data base.", (Throwable)pe, (Logger)logger);
        }
        return tt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTerminationTime(String uniqueID, Calendar c) throws UnableToSetTerminationTimeException {
        try {
            InstanceInfoBean t = (InstanceInfoBean)terminationTime.getForUpdate(uniqueID, 100L, TimeUnit.MILLISECONDS);
            try {
                t = new InstanceInfoBean(uniqueID, this.serviceName, c);
            }
            finally {
                terminationTime.write((Object)t);
            }
        }
        catch (Exception ex) {
            throw new UnableToSetTerminationTimeException("Cannot set termination time.", ex);
        }
    }

    private synchronized void initTerminationTimeStore() throws PersistenceException, InstantiationException, ClassNotFoundException, IllegalAccessException {
        if (terminationTime != null) {
            return;
        }
        PersistenceDescriptor pd = PersistenceDescriptor.get(InstanceInfoBean.class);
        pd.setTableName("TerminationTimes");
        terminationTime = PersistenceFactory.get((PersistenceProperties)this.persistenceProperties).getPersist(InstanceInfoBean.class, pd);
        this.checkVersion(terminationTime, "TerminationTimes");
    }

    @Override
    public long getCacheHits() {
        return ((PersistImpl)this.p).getCacheHits();
    }

    @Override
    public void putData(String key, Object value) {
        this.getOrCreateResourceBean();
        this.persistentInformation.put(key, (Serializable)value);
    }

    @Override
    public Object getData(String key) {
        this.getOrCreateResourceBean();
        return this.persistentInformation.get(key);
    }

    public void setErrorHandler(DeserialisationErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        this.p.setErrorHandler(errorHandler);
    }

    public DeserialisationErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    private synchronized void getOrCreateResourceBean() {
        if (this.persistentInformation != null) {
            return;
        }
        try {
            ResourceBean b = (ResourceBean)this.p.read(info_id);
            if (b != null) {
                this.persistentInformation = b.getState();
            }
        }
        catch (PersistenceException pe) {
            Log.logException((String)"Error reading information.", (Throwable)pe, (Logger)logger);
        }
        if (this.persistentInformation == null) {
            this.persistentInformation = Collections.synchronizedMap(new HashMap());
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                Persistence.this.writePersistentInformation();
            }
        };
        ThreadingServices ts = this.kernel.getContainerProperties().getThreadingServices();
        ts.getScheduledExecutorService().scheduleWithFixedDelay(r, 30000L, 30000L, TimeUnit.MICROSECONDS);
    }

    private void writePersistentInformation() {
        try {
            if (this.isShutdown) {
                return;
            }
            ResourceBean b = new ResourceBean(info_id, this.getServiceName(), "no.class", this.persistentInformation);
            this._persist(b);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Saved information for service <" + this.getServiceName() + ">"));
            }
        }
        catch (Exception ex) {
            Log.logException((String)"Error saving information.", (Throwable)ex, (Logger)logger);
        }
    }

    @Override
    public void flush() {
        this.writePersistentInformation();
        this.p.flush();
    }
}

