/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.persistence;

import de.fzj.unicore.persist.annotations.Column;
import de.fzj.unicore.persist.annotations.ID;
import de.fzj.unicore.persist.annotations.Table;
import java.io.Serializable;
import java.util.Calendar;

@Table(name="WSRFInstanceInformation")
public class InstanceInfoBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    @ID
    public String uniqueID;
    @Column(name="service")
    public String serviceName;
    @Column(name="terminates")
    public String terminates;
    @Column(name="millis")
    private long date;
    private long subscriberCount = 0L;

    public InstanceInfoBean(String uniqueID, String serviceName, Calendar terminationTime) {
        this.uniqueID = uniqueID;
        this.serviceName = serviceName;
        if (terminationTime != null) {
            this.terminates = terminationTime.getTime().toString();
            this.date = terminationTime.getTimeInMillis();
        } else {
            this.terminates = "infinite";
            this.date = 0L;
        }
    }

    public Calendar getTerminationTime() {
        Calendar tt = null;
        if (this.date > 0L) {
            tt = Calendar.getInstance();
            tt.setTimeInMillis(this.date);
        }
        return tt;
    }

    public String getUniqueID() {
        return this.uniqueID;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getTerminates() {
        return this.terminates;
    }

    public String getDate() {
        return String.valueOf(this.date);
    }

    public String getSubscriberCount() {
        return String.valueOf(this.subscriberCount);
    }

    public void incrementSubscriberCount() {
        ++this.subscriberCount;
    }

    public void decrementSubscriberCount() {
        --this.subscriberCount;
        if (this.subscriberCount < 0L) {
            this.subscriberCount = 0L;
        }
    }

    public static Calendar getCalendar(String dateMillis) {
        Calendar tt = null;
        long millis = Long.valueOf(dateMillis);
        if (millis > 0L) {
            tt = Calendar.getInstance();
            tt.setTimeInMillis(millis);
        }
        return tt;
    }
}

