/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.persistence;

import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.persistence.PersistenceSettings;
import de.fzj.unicore.wsrflite.persistence.Store;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class InMemory
implements Store {
    private Map<String, Object> dataStorage;
    private Map<String, Resource> storage;
    protected static Map<String, Calendar> terminationTimes = new ConcurrentHashMap<String, Calendar>();
    private PersistenceSettings ps = PersistenceSettings.getDefaultSettings();
    private Kernel kernel;
    private String serviceName;

    @Override
    public void init(Kernel k, String serviceName) {
        this.kernel = k;
        this.serviceName = serviceName;
        this.storage = Collections.synchronizedMap(new HashMap());
        this.dataStorage = Collections.synchronizedMap(new HashMap());
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void persist(Resource inst) {
        inst.passivate();
        this.storage.put(inst.getUniqueID(), inst);
    }

    @Override
    public Set<String> getUniqueIDs() {
        return this.storage.keySet();
    }

    @Override
    public Resource read(String uniqueID) {
        Resource r = this.storage.get(uniqueID);
        if (r != null) {
            r.setKernel(this.kernel);
        }
        return r;
    }

    @Override
    public Resource getForUpdate(String uniqueID, long time, TimeUnit timeUnit) {
        Resource r = this.storage.get(uniqueID);
        if (r != null) {
            r.setKernel(this.kernel);
            r.setHome(this.kernel.getHome(this.serviceName));
            r.postActivate();
        }
        return r;
    }

    @Override
    public void remove(String uniqueID) {
        this.storage.remove(uniqueID);
    }

    @Override
    public void unlock(Resource i) {
    }

    @Override
    public int size() {
        return this.storage.size();
    }

    public void setPersistenceSettings(PersistenceSettings ps) {
    }

    public PersistenceSettings getPersistenceSettings() {
        return this.ps;
    }

    @Override
    public Map<String, Calendar> getTerminationTimes() {
        return terminationTimes;
    }

    @Override
    public void setTerminationTime(String uniqueID, Calendar c) {
        if (c == null) {
            terminationTimes.remove(uniqueID);
        } else {
            terminationTimes.put(uniqueID, c);
        }
    }

    @Override
    public void purgePersistentData() {
    }

    @Override
    public void putData(String key, Object value) {
        this.dataStorage.put(key, value);
    }

    @Override
    public Object getData(String key) {
        return this.dataStorage.get(key);
    }

    @Override
    public void flush() {
    }
}

