/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.messaging;

import de.fzj.unicore.persist.Persist;
import de.fzj.unicore.persist.PersistenceException;
import de.fzj.unicore.persist.PersistenceFactory;
import de.fzj.unicore.persist.PersistenceProperties;
import de.fzj.unicore.wsrflite.messaging.IMessaging;
import de.fzj.unicore.wsrflite.messaging.IMessagingChannel;
import de.fzj.unicore.wsrflite.messaging.IMessagingProvider;
import de.fzj.unicore.wsrflite.messaging.Message;
import de.fzj.unicore.wsrflite.messaging.MessagingException;
import de.fzj.unicore.wsrflite.messaging.PullPoint;
import de.fzj.unicore.wsrflite.messaging.impl.MessageBean;
import eu.unicore.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class MessagingImpl
implements IMessaging {
    private static final Logger logger = Log.getLogger((String)"unicore.wsrflite", MessagingImpl.class);
    private final Persist<MessageBean> store;
    private final HashMap<String, IMessagingProvider> providers;
    private final PersistenceProperties persistenceProperties;

    public MessagingImpl(PersistenceProperties kernelCfg) throws MessagingException {
        this.persistenceProperties = kernelCfg;
        try {
            this.store = this.createStore();
        }
        catch (PersistenceException pe) {
            throw new MessagingException(pe);
        }
        this.providers = new HashMap();
    }

    protected Persist<MessageBean> createStore() throws PersistenceException {
        Persist res = PersistenceFactory.get((PersistenceProperties)this.persistenceProperties).getPersist(MessageBean.class);
        return res;
    }

    public int getStoredMessages() throws PersistenceException {
        return this.store.getRowCount();
    }

    @Override
    public void registerProvider(IMessagingProvider provider, String id) {
        if (provider != null && id != null) {
            if (this.providers.put(id, provider) == null) {
                logger.info((Object)("Registered new provider <" + provider.getClass().getName() + "> as <" + id + ">"));
            }
        } else {
            logger.warn((Object)"Null provider or id, continuing.");
        }
    }

    @Override
    public boolean hasMessages(String destination) {
        try {
            return this.store.getRowCount("destination", (Object)destination) > 0;
        }
        catch (PersistenceException ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PullPoint getPullPoint(final String destination) throws MessagingException {
        final ArrayList<Message> messages = new ArrayList<Message>();
        Persist<MessageBean> persist = this.store;
        synchronized (persist) {
            try {
                for (String messageID : this.store.getIDs("destination", (Object)destination)) {
                    messages.add(((MessageBean)this.store.read((String)messageID)).message);
                    this.store.remove(messageID);
                }
            }
            catch (Exception ex) {
                throw new MessagingException(ex);
            }
        }
        return new PullPoint(){
            Iterator<Message> messageIterator;
            {
                this.messageIterator = messages.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.messageIterator.hasNext();
            }

            @Override
            public Message next() {
                Message m = this.messageIterator.next();
                this.messageIterator.remove();
                return m;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void dispose() {
                Persist persist = MessagingImpl.this.store;
                synchronized (persist) {
                    while (this.hasNext()) {
                        Message next = this.next();
                        try {
                            MessagingImpl.this.store.write((Object)new MessageBean(next.getMessageId(), destination, next));
                        }
                        catch (PersistenceException pe) {
                            logger.warn((Object)"Could not write message.");
                        }
                    }
                    return;
                }
            }
        };
    }

    @Override
    public IMessagingChannel getQueue(String name) throws MessagingException {
        return this.getChannel(name);
    }

    @Override
    public IMessagingChannel getChannel(final String name) throws MessagingException {
        IMessagingProvider provider = this.providers.get(name);
        if (provider != null) {
            return provider.getChannel();
        }
        return new IMessagingChannel(){

            @Override
            public void publish(Message message) throws MessagingException {
                try {
                    MessagingImpl.this.store.write((Object)new MessageBean(message.getMessageId(), name, message));
                }
                catch (Exception ex) {
                    throw new MessagingException(ex);
                }
            }
        };
    }

    public void cleanup() throws PersistenceException {
        this.store.removeAll();
    }
}

