/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.impl;

import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.persistence.Persist;
import de.fzj.unicore.wsrflite.security.VODescription;
import de.fzj.unicore.wsrflite.security.util.AuthZAttributeStore;
import eu.emi.security.authn.x509.X509Credential;
import eu.unicore.security.Client;
import eu.unicore.security.OperationType;
import eu.unicore.security.SecurityTokens;
import eu.unicore.util.Log;
import java.io.Serializable;
import java.security.cert.CertPath;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Logger;

public abstract class SecuredResourceImpl
implements Resource {
    private static final Logger logger = Log.getLogger((String)"unicore.wsrflite", SecuredResourceImpl.class);
    @Persist
    private X500Principal owner;
    @Persist
    protected Map<VODescription, Set<OperationType>> voMembership = new HashMap<VODescription, Set<OperationType>>();

    @Override
    public void initialise(String serviceName, Map<String, Object> initParams) throws Exception {
        this.setDefaultOwner();
    }

    @Override
    public Map<String, Serializable> passivate() {
        return new HashMap<String, Serializable>();
    }

    public void updateSecurityTokensBeforeAIP(SecurityTokens securityTokens) {
    }

    protected void setDefaultOwner() {
        X500Principal p;
        SecurityTokens tokens = this.getSecurityTokens();
        if (tokens != null && (p = tokens.getEffectiveUserName()) != null) {
            this.setOwner(p);
        }
        if (logger.isDebugEnabled()) {
            if (this.owner != null) {
                logger.debug((Object)("Owner: " + this.getOwner().getName()));
            } else {
                logger.debug((Object)"Owner could not be assigned.");
            }
        }
    }

    public SecurityTokens getSecurityTokens() {
        return AuthZAttributeStore.getTokens();
    }

    public synchronized Client getClient() {
        return AuthZAttributeStore.getClient();
    }

    public void setOwner(CertPath owner) {
        this.owner = ((X509Certificate)owner.getCertificates().get(0)).getSubjectX500Principal();
    }

    public void setOwner(X509Certificate owner) {
        this.owner = owner.getSubjectX500Principal();
    }

    public void setOwner(X500Principal owner) {
        this.owner = owner;
    }

    public void setOwner(String owner) {
        this.owner = new X500Principal(owner);
    }

    public X500Principal getOwner() {
        if (this.owner != null) {
            return this.owner;
        }
        X509Credential kernelIdentity = this.getKernel().getContainerSecurityConfiguration().getCredential();
        if (kernelIdentity != null) {
            this.owner = kernelIdentity.getCertificateChain()[0].getSubjectX500Principal();
            logger.debug((Object)("Setting server as owner of " + this.getServiceName() + "<" + this.getUniqueID() + ">"));
            return this.owner;
        }
        return new X500Principal("CN=ANONYMOUS,O=UNKNOWN,OU=UNKNOWN");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<VODescription, Set<OperationType>> getExtendedVOMembership() {
        Map<VODescription, Set<OperationType>> map = this.voMembership;
        synchronized (map) {
            return this.voMembership;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Set<OperationType>> getVOMembership() {
        Map<VODescription, Set<OperationType>> map = this.voMembership;
        synchronized (map) {
            HashMap<String, Set<OperationType>> ops = new HashMap<String, Set<OperationType>>();
            for (VODescription key : this.voMembership.keySet()) {
                ops.put(key.getVoName(), this.voMembership.get(key));
            }
            return ops;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setVOMembership(Map<? extends VODescription, Set<OperationType>> newMembership) {
        Map<VODescription, Set<OperationType>> map = this.voMembership;
        synchronized (map) {
            this.voMembership = Collections.unmodifiableMap(newMembership);
        }
    }

    public void updateVoMembership(Map<? extends VODescription, Set<OperationType>> addedVos, Map<? extends VODescription, Set<OperationType>> modifiedVos, Map<? extends VODescription, Set<OperationType>> removedVos, Map<? extends VODescription, Set<OperationType>> newVoMembership) throws Exception {
    }

    public boolean isRecursiveVOMembershipChangeHonored() {
        return true;
    }
}

