/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.impl;

import de.fzj.unicore.persist.PersistenceException;
import de.fzj.unicore.wsrflite.Home;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.Node;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.exceptions.ResourceUnknownException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class NodeHelper
implements Node {
    private static final long serialVersionUID = 1L;
    private final String uid;
    private final String serviceName;
    private final Set<Node> children = new HashSet<Node>();
    private final String parentUID;
    private final String parentServiceName;

    public NodeHelper(String uid, String serviceName, Node parent) {
        this.uid = uid;
        this.serviceName = serviceName;
        if (parent != null) {
            this.parentUID = parent.getUniqueID();
            this.parentServiceName = parent.getServiceName();
            parent.addChild(this);
        } else {
            this.parentUID = null;
            this.parentServiceName = null;
        }
    }

    @Override
    public String getUniqueID() {
        return this.uid;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public String getParentUID() {
        return this.parentUID;
    }

    @Override
    public String getParentServiceName() {
        return this.parentServiceName;
    }

    public Resource getParent(Kernel kernel) throws ResourceUnknownException, PersistenceException {
        Resource res = null;
        if (this.parentServiceName != null && this.parentUID != null) {
            Home home = kernel.getHome(this.parentServiceName);
            if (home == null) {
                throw new ResourceUnknownException("Service '" + this.parentServiceName + "' is not deployed.");
            }
            res = home.get(this.parentUID);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Node> getChildren() {
        Set<Node> set = this.children;
        synchronized (set) {
            HashSet<Node> ret = new HashSet<Node>();
            ret.addAll(this.children);
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChild(Node child) {
        Set<Node> set = this.children;
        synchronized (set) {
            this.children.add(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeChild(Node child) {
        Set<Node> set = this.children;
        synchronized (set) {
            return this.children.remove(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllChildren() {
        Set<Node> set = this.children;
        synchronized (set) {
            this.children.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeChild(String uid) {
        Set<Node> set = this.children;
        synchronized (set) {
            Iterator<Node> iterator = this.children.iterator();
            while (iterator.hasNext()) {
                Node child = iterator.next();
                if (!uid.equals(child.getUniqueID())) continue;
                iterator.remove();
                return true;
            }
            return false;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.serviceName == null ? 0 : this.serviceName.hashCode());
        result = 31 * result + (this.uid == null ? 0 : this.uid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeHelper other = (NodeHelper)obj;
        if (this.serviceName == null ? other.serviceName != null : !this.serviceName.equals(other.serviceName)) {
            return false;
        }
        return !(this.uid == null ? other.uid != null : !this.uid.equals(other.uid));
    }
}

