/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.impl;

import de.fzj.unicore.persist.PersistenceException;
import de.fzj.unicore.wsrflite.Home;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.ThreadingServices;
import de.fzj.unicore.wsrflite.exceptions.ResourceNotCreatedException;
import de.fzj.unicore.wsrflite.exceptions.ResourceUnavailableException;
import de.fzj.unicore.wsrflite.exceptions.ResourceUnknownException;
import de.fzj.unicore.wsrflite.exceptions.TerminationTimeChangeRejectedException;
import de.fzj.unicore.wsrflite.exceptions.UnableToSetTerminationTimeException;
import de.fzj.unicore.wsrflite.impl.ExpiryChecker;
import de.fzj.unicore.wsrflite.impl.InstanceChecker;
import de.fzj.unicore.wsrflite.impl.InstanceChecking;
import de.fzj.unicore.wsrflite.impl.ResourceImpl;
import de.fzj.unicore.wsrflite.messaging.MessagingException;
import de.fzj.unicore.wsrflite.persistence.Store;
import de.fzj.unicore.wsrflite.security.util.AuthZAttributeStore;
import eu.unicore.security.SecurityTokens;
import eu.unicore.util.Log;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public abstract class DefaultHome
implements Home {
    protected static final Logger logger = Log.getLogger((String)"unicore.wsrflite", DefaultHome.class);
    protected Store serviceInstances;
    protected String serviceName;
    protected static Map<String, Calendar> terminationTimes = new HashMap<String, Calendar>();
    private static long lastAccessed;
    private static long tt_update_interval;
    private Kernel kernel;
    protected final Map<String, AtomicInteger> instancesPerUser = new ConcurrentHashMap<String, AtomicInteger>();
    private volatile boolean isShuttingDown = false;
    protected InstanceChecking instanceChecking;
    protected InstanceChecker expiryChecker;
    protected boolean supportsNotification = false;
    private long lastRefreshNotificationInstant = System.currentTimeMillis();

    public DefaultHome() {
        this.instanceChecking = new InstanceChecking(this, new String[0]);
        this.expiryChecker = new ExpiryChecker();
        this.instanceChecking.addChecker(this.expiryChecker);
    }

    @Override
    public void activateHome(String serviceName) throws Exception {
        if (serviceName == null || "".equals(serviceName)) {
            throw new IllegalArgumentException("Must specify a service name.");
        }
        if (this.kernel == null) {
            throw new IllegalStateException("The kernel field has not been initialized");
        }
        this.serviceName = serviceName;
        if (this.serviceInstances == null) {
            this.serviceInstances = this.kernel.getPersistenceManager().getPersist(serviceName);
        }
        this.initExpiryCheck();
        this.initNotification();
    }

    protected void initExpiryCheck() throws Exception {
        Set<String> uniqueIDs = this.serviceInstances.getUniqueIDs();
        logger.info((Object)("[" + this.serviceName + "] Have " + uniqueIDs.size() + " instances from permanent storage"));
        this.instanceChecking.addAll(uniqueIDs.toArray(new String[uniqueIDs.size()]));
        int initial = this.kernel.getContainerProperties().getSubkeyIntValue("wsrf.expirycheck.initial", this.serviceName);
        int period = this.kernel.getContainerProperties().getSubkeyIntValue("wsrf.expirycheck.period", this.serviceName);
        logger.debug((Object)("[" + this.serviceName + "] Expiry thread scheduled at a period of " + period + " secs."));
        ThreadingServices ts = this.kernel.getContainerProperties().getThreadingServices();
        ts.getScheduledExecutorService().scheduleWithFixedDelay(this.instanceChecking, initial, period, TimeUnit.SECONDS);
    }

    public void runExpiryCheckNow() {
        try {
            this.instanceChecking.run();
        }
        catch (Exception e) {
            logger.warn((Object)("[" + this.serviceName + "] Uncaught exception occured while running expiry check"), (Throwable)e);
        }
    }

    @Override
    public void stopExpiryCheckNow() {
        try {
            this.instanceChecking.removeChecker(this.expiryChecker);
        }
        catch (Exception e) {
            logger.warn((Object)("[" + this.serviceName + "] Uncaught exception occured while stopping expiry check"), (Throwable)e);
        }
    }

    @Override
    public void passivateHome() {
        logger.info((Object)("[" + this.serviceName + "] Shutting down."));
        this.isShuttingDown = true;
        if (this.serviceInstances != null) {
            this.serviceInstances.shutdown();
        }
    }

    @Override
    public void notifyConfigurationRefresh() {
        this.lastRefreshNotificationInstant = System.currentTimeMillis();
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @Override
    public Resource get(String id) throws ResourceUnknownException, PersistenceException {
        Resource wsrfInstance = this.serviceInstances.read(id);
        if (wsrfInstance == null) {
            throw new ResourceUnknownException("Instance with ID <" + id + "> does not exist");
        }
        wsrfInstance.setHome(this);
        wsrfInstance.setKernel(this.getKernel());
        return wsrfInstance;
    }

    @Override
    public Resource getForUpdate(String id) throws ResourceUnknownException, ResourceUnavailableException {
        try {
            Resource wsrfInstance = this.serviceInstances.getForUpdate(id, 10000L, TimeUnit.MILLISECONDS);
            if (wsrfInstance == null) {
                throw new ResourceUnknownException("Instance with ID <" + id + "> does not exist");
            }
            wsrfInstance.setHome(this);
            wsrfInstance.setKernel(this.getKernel());
            if (wsrfInstance instanceof ResourceImpl) {
                ResourceImpl r = (ResourceImpl)wsrfInstance;
                if (this.lastRefreshNotificationInstant > r.lastRefreshNotificationInstant) {
                    r.lastRefreshNotificationInstant = this.lastRefreshNotificationInstant;
                    r.processConfigurationChange();
                }
            }
            return wsrfInstance;
        }
        catch (PersistenceException pe) {
            throw new ResourceUnavailableException("Instance with ID <" + this.buildFullServiceID(id) + "> cannot be accessed", pe);
        }
        catch (TimeoutException te) {
            throw new ResourceUnavailableException("Instance with ID <" + this.buildFullServiceID(id) + "> is not available.");
        }
    }

    private String buildFullServiceID(String resourceID) {
        return this.kernel.getContainerProperties().getBaseUrl() + "/" + this.serviceName + "?res=" + resourceID;
    }

    @Override
    public String createWSRFServiceInstance(Map<String, Object> initObjs) throws ResourceNotCreatedException {
        this.checkLimits();
        try {
            Resource newInstance = this.doCreateInstance(initObjs);
            newInstance.setHome(this);
            newInstance.setKernel(this.kernel);
            if (initObjs == null) {
                initObjs = new HashMap<String, Object>();
            }
            newInstance.initialise(this.serviceName, initObjs);
            this.postInitialise(newInstance);
            this.storeNewInstance(newInstance);
            this.instanceChecking.add(newInstance.getUniqueID());
            return newInstance.getUniqueID();
        }
        catch (Exception e) {
            String msg = Log.createFaultMessage((String)"Resource not created.", (Throwable)e);
            throw new ResourceNotCreatedException(msg, e);
        }
    }

    protected void postInitialise(Resource instance) {
    }

    @Override
    public void persist(Resource instance) throws Exception {
        this.serviceInstances.persist(instance);
    }

    @Override
    public Calendar getTerminationTime(String uniqueID) throws PersistenceException {
        this.updateTT();
        return terminationTimes.get(uniqueID);
    }

    protected void updateTT() throws PersistenceException {
        if (System.currentTimeMillis() - lastAccessed < tt_update_interval) {
            return;
        }
        terminationTimes = this.serviceInstances.getTerminationTimes();
        lastAccessed = System.currentTimeMillis();
    }

    @Override
    public void setTerminationTime(String uniqueID, Calendar c) throws TerminationTimeChangeRejectedException, UnableToSetTerminationTimeException {
        try {
            if (this.serviceInstances != null) {
                this.serviceInstances.setTerminationTime(uniqueID, c);
                if (c != null) {
                    terminationTimes.put(uniqueID, c);
                } else {
                    terminationTimes.remove(uniqueID);
                }
            }
        }
        catch (Exception e) {
            throw new UnableToSetTerminationTimeException(e);
        }
    }

    protected abstract Resource doCreateInstance() throws Exception;

    protected Resource doCreateInstance(Map<String, Object> initObjs) throws Exception {
        return this.doCreateInstance();
    }

    protected void storeNewInstance(Resource newInstance) throws PersistenceException {
        this.serviceInstances.persist(newInstance);
    }

    public void removeFromStorage(String resourceId) throws Exception {
        this.serviceInstances.remove(resourceId);
        terminationTimes.remove(resourceId);
    }

    @Override
    public void destroyWSRFServiceInstance(String resourceId) throws Exception {
        this.removeFromStorage(resourceId);
        this.instanceChecking.remove(resourceId);
    }

    @Override
    public long getNumberOfInstances() throws PersistenceException {
        return this.serviceInstances.size();
    }

    @Override
    public Store getStore() {
        return this.serviceInstances;
    }

    public void setStore(Store serviceInstances) {
        this.serviceInstances = serviceInstances;
    }

    @Override
    public boolean isShuttingDown() {
        return this.isShuttingDown;
    }

    @Override
    public boolean supportsNotification() {
        return this.supportsNotification;
    }

    protected void initNotification() throws MessagingException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkLimits() throws ResourceNotCreatedException {
        String owner = null;
        try {
            SecurityTokens tokens = AuthZAttributeStore.getTokens();
            if (tokens != null && tokens.getEffectiveUserName() != null) {
                owner = tokens.getEffectiveUserName().toString();
            } else {
                logger.debug((Object)"No security information available.");
            }
        }
        catch (Exception ex) {
            Log.logException((String)"Error processing security information.", (Throwable)ex, (Logger)logger);
        }
        if (owner != null) {
            AtomicInteger num = null;
            Map<String, AtomicInteger> map = this.instancesPerUser;
            synchronized (map) {
                num = this.instancesPerUser.get(owner);
                if (num == null) {
                    num = new AtomicInteger(0);
                    this.instancesPerUser.put(owner, num);
                }
            }
            if (num.incrementAndGet() > this.getInstanceLimit(owner)) {
                int current = num.decrementAndGet();
                ResourceNotCreatedException rnc = new ResourceNotCreatedException("Limit of <" + current + "> instances of <" + this.serviceName + "> for <" + owner + "> has been reached.");
                rnc.setErrorCode(1001);
                throw rnc;
            }
        }
    }

    protected int getInstanceLimit(String owner) {
        return this.kernel.getContainerProperties().getSubkeyIntValue("wsrf.maxInstancesPerUser", this.serviceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void instanceDestroyed(String owner) {
        if (owner != null) {
            AtomicInteger num = null;
            Map<String, AtomicInteger> map = this.instancesPerUser;
            synchronized (map) {
                num = this.instancesPerUser.get(owner);
                if (num == null) {
                    num = new AtomicInteger(1);
                    this.instancesPerUser.put(owner, num);
                }
            }
            if (num.intValue() > 0) {
                num.decrementAndGet();
            }
        }
    }

    public long getLastRefreshInstant() {
        return this.lastRefreshNotificationInstant;
    }

    @Override
    public void run() {
    }

    @Override
    public Kernel getKernel() {
        return this.kernel;
    }

    @Override
    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }

    public Map<String, AtomicInteger> getInstancesPerUser() {
        return Collections.unmodifiableMap(this.instancesPerUser);
    }

    static {
        tt_update_interval = 10000L;
    }
}

