/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.admin;

import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.admin.USEAdminMBean;
import eu.unicore.util.Log;
import java.security.cert.X509Certificate;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class USEAdmin
implements USEAdminMBean {
    private static final Logger logger = Log.getLogger((String)"unicore", USEAdmin.class);
    private final Kernel useKernel;

    public USEAdmin(Kernel useKernel) {
        this.useKernel = useKernel;
    }

    @Override
    public String getSiteName() {
        return this.useKernel.getContainerProperties().getValue("sitename");
    }

    @Override
    public String getProxyCertificateSupportEnabled() {
        return this.useKernel.getContainerSecurityConfiguration().getValidator().getProxySupport().toString();
    }

    @Override
    public String getAccessControlEnabled() {
        return this.useKernel.getContainerSecurityConfiguration().isAccessControlEnabled() + "";
    }

    @Override
    public String getRequireSignatureEnabled() {
        return this.useKernel.getContainerSecurityConfiguration().isSigningRequired() + "";
    }

    @Override
    public String getBaseURL() {
        return this.useKernel.getContainerProperties().getValue("baseurl");
    }

    @Override
    public String getGatewayIdentity() {
        String id = "<n/a>";
        X509Certificate c = this.useKernel.getContainerSecurityConfiguration().getGatewayCertificate();
        if (c != null) {
            id = c.getSubjectX500Principal().getName();
        }
        return id;
    }

    @Override
    public String setLogLevel(String log, String level) {
        Level l = Level.toLevel((String)level);
        LogManager.getLogger((String)log).setLevel(l);
        logger.info((Object)("JMX ACTION: level for logger <" + log + "> changed to <" + l.toString() + ">"));
        return "Level set to " + l.toString();
    }

    @Override
    public String getGatewayConnectionStatus() {
        return this.useKernel.getGatewayHandler().getConnectionStatusMessage();
    }

    @Override
    public String getAttributeSourcesStatus() {
        try {
            return this.useKernel.getContainerSecurityConfiguration().getAip().getStatusDescription();
        }
        catch (Exception ex) {
            return "ERROR: " + ex.toString();
        }
    }
}

