/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite;

import de.fzj.unicore.wsrflite.ContainerProperties;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ThreadingServices {
    private final ContainerProperties kernelCfg;
    private ScheduledThreadPoolExecutor scheduler;
    private ThreadPoolExecutor executor;

    protected ThreadingServices(ContainerProperties kernelCfg) {
        this.kernelCfg = kernelCfg;
        this.configure();
    }

    public synchronized ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduler;
    }

    public ExecutorService getExecutorService() {
        return this.executor;
    }

    public synchronized <V> CompletionService<V> getCompletionService() {
        return new ExecutorCompletionService(this.getExecutorService());
    }

    protected void configure() {
        this.configureScheduler();
        this.configureExecutor();
    }

    protected void configureScheduler() {
        int core = this.kernelCfg.getIntValue("resources.scheduled.size");
        this.scheduler = new ScheduledThreadPoolExecutor(core);
        int idle = this.kernelCfg.getIntValue("resources.scheduled.idletime");
        this.scheduler.setKeepAliveTime(idle, TimeUnit.MILLISECONDS);
        this.scheduler.setThreadFactory(new ThreadFactory(){
            final AtomicInteger threadNumber = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("wsrflite-sched-" + this.threadNumber.getAndIncrement());
                return t;
            }
        });
    }

    protected void configureExecutor() {
        int min = this.kernelCfg.getIntValue("resources.executor.minsize");
        int max = this.kernelCfg.getIntValue("resources.executor.maxsize");
        int idle = this.kernelCfg.getIntValue("resources.executor.idletime");
        this.executor = new ThreadPoolExecutor(min, max, (long)idle, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
            final AtomicInteger threadNumber = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("wsrflite-executor-" + this.threadNumber.getAndIncrement());
                return t;
            }
        });
    }

    public int getScheduledExecutorCorePoolSize() {
        return this.scheduler.getCorePoolSize();
    }

    public int getScheduledExecutorMaxPoolSize() {
        return this.scheduler.getMaximumPoolSize();
    }

    public int getScheduledExecutorActiveThreadCount() {
        return this.scheduler.getActiveCount();
    }

    public int getExecutorCorePoolSize() {
        return this.executor.getCorePoolSize();
    }

    public int getExecutorMaxPoolSize() {
        return this.executor.getMaximumPoolSize();
    }

    public int getExecutorActiveThreadCount() {
        return this.executor.getActiveCount();
    }
}

