/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite;

import de.fzj.unicore.metrix.IMetric;
import de.fzj.unicore.metrix.MetricRegistry;
import de.fzj.unicore.persist.PersistenceProperties;
import de.fzj.unicore.wsrflite.ContainerProperties;
import de.fzj.unicore.wsrflite.DeploymentManager;
import de.fzj.unicore.wsrflite.GatewayHandler;
import de.fzj.unicore.wsrflite.Home;
import de.fzj.unicore.wsrflite.KernelInjectable;
import de.fzj.unicore.wsrflite.Service;
import de.fzj.unicore.wsrflite.ServiceFactory;
import de.fzj.unicore.wsrflite.StartupTask;
import de.fzj.unicore.wsrflite.StartupTasksRunner;
import de.fzj.unicore.wsrflite.USEClientProperties;
import de.fzj.unicore.wsrflite.USEPropertyChecker;
import de.fzj.unicore.wsrflite.admin.AdminAction;
import de.fzj.unicore.wsrflite.admin.AdminActionLoader;
import de.fzj.unicore.wsrflite.admin.USEAdmin;
import de.fzj.unicore.wsrflite.events.PropertyFileChangeEvent;
import de.fzj.unicore.wsrflite.messaging.IMessaging;
import de.fzj.unicore.wsrflite.messaging.MessagingException;
import de.fzj.unicore.wsrflite.messaging.MessagingImpl;
import de.fzj.unicore.wsrflite.persistence.PersistenceManager;
import de.fzj.unicore.wsrflite.security.CertificateInfoMetric;
import de.fzj.unicore.wsrflite.security.ContainerSecurityProperties;
import de.fzj.unicore.wsrflite.security.IContainerSecurityConfiguration;
import de.fzj.unicore.wsrflite.security.SecurityManager;
import de.fzj.unicore.wsrflite.server.ContainerHttpServerProperties;
import de.fzj.unicore.wsrflite.server.JettyServer;
import de.fzj.unicore.wsrflite.utils.FileWatcher;
import de.fzj.unicore.wsrflite.utils.deployment.IServiceConfigurator;
import de.fzj.unicore.wsrflite.utils.deployment.NullServiceConfigurator;
import de.fzj.unicore.wsrflite.utils.deployment.PropertyChecker;
import de.fzj.unicore.wsrflite.utils.deployment.ServiceConfigReader;
import eu.unicore.util.Log;
import eu.unicore.util.configuration.ConfigurationException;
import eu.unicore.util.configuration.UpdateableConfiguration;
import eu.unicore.util.httpclient.IClientConfiguration;
import eu.unicore.util.jetty.HttpServerProperties;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.concurrent.TimeUnit;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class Kernel
extends Observable
implements Observer {
    public static final String VERSION = Kernel.class.getPackage().getImplementationVersion() != null ? Kernel.class.getPackage().getImplementationVersion() : "DEVELOPMENT";
    private static final Logger logger = Log.getLogger((String)"unicore.wsrflite", Kernel.class);
    private IMessaging msg;
    private JettyServer jetty;
    private SecurityManager securityManager;
    private PersistenceManager persistenceManager;
    private final List<String> monitorMetrics = new ArrayList<String>();
    private final Map<String, Service> services = Collections.synchronizedMap(new HashMap());
    private final Map<String, ServiceFactory> serviceFactories = Collections.synchronizedMap(new HashMap());
    private GatewayHandler gwHandler;
    private long lastPropertyChangeInstant = System.currentTimeMillis();
    private List<PropertyChecker> propertyCheckers = new ArrayList<PropertyChecker>();
    private ContainerProperties containerConfiguration;
    private ContainerSecurityProperties containerSecurityConfiguration;
    private USEClientProperties clientConfiguration;
    private HttpServerProperties jettyConfiguration;
    private PersistenceProperties persistenceProperties;
    private IServiceConfigurator serviceConfigurator;
    private Map<String, AdminAction> adminActions;
    private List<Runnable> startupTasks;
    private Collection<UpdateableConfiguration> configurations;
    private DeploymentManager deploymentManager;
    private volatile boolean isShutdown = false;
    private Calendar upSince;
    private final Map<Class<?>, Object> attributes = new HashMap();
    private final USEAdmin jmxBean;

    public Kernel(Properties extraProperties) throws Exception {
        this(null, extraProperties);
    }

    public Kernel(String configurationFile) throws Exception {
        this(configurationFile, null);
    }

    public Kernel(String configurationFile, Properties extraProperties) throws Exception {
        this.addObserver(this);
        this.configurations = new HashSet<UpdateableConfiguration>();
        this.upSince = Calendar.getInstance();
        this.registerDefaultFactories();
        this.prepare(configurationFile, extraProperties);
        this.jmxBean = new USEAdmin(this);
        Kernel.addMBean(this.jmxBean, "UNICORE Services Environment " + this.hashCode());
    }

    public static final String getVersion() {
        String ver = VERSION != null ? VERSION : "DEVELOPMENT";
        return ver;
    }

    public final String getHeader() {
        String lineSep = System.getProperty("line.separator");
        String s = lineSep + " _    _ _   _ _____ _____ ____  _____  ______" + lineSep + "| |  | | \\ | |_   _/ ____/ __ \\|  __ \\|  ____|" + lineSep + "| |  | |  \\| | | || |   | |  | | |__) | |__" + lineSep + "| |  | | . ` | | || |   | |  | |  _  /|  __|" + lineSep + "| |__| | |\\  |_| |_ |____ |__| | | \\ \\| |____" + lineSep + " \\____/|_| \\_|_____\\_____\\____/|_|  \\_\\______|" + lineSep + "UNICORE Services Environment" + lineSep + "Version " + Kernel.getVersion() + ", http://www.unicore.eu";
        return s;
    }

    public String getConnectionStatus() {
        StringBuilder report = new StringBuilder();
        String newline = System.getProperty("line.separator");
        report.append("Gateway connection: ");
        report.append(this.jmxBean.getGatewayConnectionStatus());
        report.append(newline);
        report.append("User attribute sources: ");
        report.append(this.jmxBean.getAttributeSourcesStatus());
        report.append(newline);
        return report.toString();
    }

    public Calendar getUpSince() {
        return this.upSince;
    }

    public synchronized void shutdown() {
        if (this.isShutdown) {
            return;
        }
        this.isShutdown = true;
        try {
            if (this.getServer() != null) {
                this.getServer().stop();
            }
        }
        catch (Exception e) {
            Log.logException((String)"Problem shutting down the Jetty server", (Throwable)e, (Logger)logger);
        }
        for (Service s : this.services.values()) {
            try {
                s.stop();
            }
            catch (Throwable t) {
                logger.error((Object)("Error during shutdown of service <" + s.getName() + ">"), t);
            }
        }
    }

    public JettyServer getServer() {
        return this.jetty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChecker(PropertyChecker checker) {
        List<PropertyChecker> list = this.propertyCheckers;
        synchronized (list) {
            this.propertyCheckers.add(checker);
        }
    }

    public static void addMBean(Object mbean, String name) {
        try {
            MBeanServer mbs = null;
            mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName adminName = null;
            adminName = new ObjectName("USE:name=" + name);
            mbs.registerMBean(mbean, adminName);
        }
        catch (InstanceAlreadyExistsException iae) {
            logger.debug((Object)("Instance already exists: " + name));
        }
        catch (Exception ex) {
            Log.logException((String)"Error registering mbean.", (Throwable)ex, (Logger)logger);
        }
    }

    public Service addService(Service service) {
        return this.services.put(service.getName(), service);
    }

    public Service removeService(String serviceName) {
        return this.services.remove(serviceName);
    }

    public <T> T getAttribute(Class<T> key) {
        Object o = this.attributes.get(key);
        return key.cast(o);
    }

    public <T> void setAttribute(Class<T> key, T value) {
        this.attributes.put(key, value);
    }

    public <T> void addConfigurationHandler(Class<T> key, UpdateableConfiguration value) {
        this.attributes.put(key, value);
        this.configurations.add(value);
    }

    public Service getService(String name) {
        return this.services.get(name);
    }

    public ServiceFactory getServiceFactory(String type) {
        return this.serviceFactories.get(type);
    }

    public void registerServiceFactory(ServiceFactory factory) {
        ServiceFactory old = this.serviceFactories.put(factory.getType(), factory);
        if (old == null || old.getClass().equals(factory.getClass())) {
            logger.info((Object)("Registered '" + factory.getClass().getName() + "'" + " for service type '" + factory.getType() + "'"));
        }
    }

    public Collection<ServiceFactory> getServiceFactories() {
        return Collections.unmodifiableCollection(this.serviceFactories.values());
    }

    public Collection<Service> getServices() {
        return Collections.unmodifiableCollection(this.services.values());
    }

    public Home getHome(String serviceName) {
        Service s = this.services.get(serviceName);
        return s != null ? s.getHome() : null;
    }

    public IContainerSecurityConfiguration getContainerSecurityConfiguration() {
        return this.containerSecurityConfiguration;
    }

    public USEClientProperties getClientConfiguration() {
        return this.clientConfiguration;
    }

    public ContainerProperties getContainerProperties() {
        return this.containerConfiguration;
    }

    public HttpServerProperties getJettyProperties() {
        return this.jettyConfiguration;
    }

    public PersistenceProperties getPersistenceProperties() {
        return this.persistenceProperties;
    }

    public IMessaging getMessaging() throws MessagingException {
        return this.msg;
    }

    public SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    public PersistenceManager getPersistenceManager() {
        return this.persistenceManager;
    }

    public List<IMetric<?>> getMonitorMetrics() {
        ArrayList res = new ArrayList();
        for (String name : this.monitorMetrics) {
            IMetric m = MetricRegistry.getInstance().getMetric(name);
            if (m == null) continue;
            res.add(m);
        }
        return res;
    }

    public void registerMonitorMetric(String name) {
        this.monitorMetrics.add(name);
    }

    public synchronized long getLastConfigFileChangeTime() {
        return Math.max(this.serviceConfigurator.getLastConfigFileUpdateTime(), this.lastPropertyChangeInstant);
    }

    @Override
    public void notifyObservers() {
        this.notifyObservers(null);
    }

    @Override
    public void notifyObservers(Object event) {
        this.setChanged();
        super.notifyObservers(event);
    }

    public final GatewayHandler getGatewayHandler() {
        return this.gwHandler;
    }

    public synchronized DeploymentManager getDeploymentManager() {
        return this.deploymentManager;
    }

    public synchronized Map<String, AdminAction> getAdminActions() {
        return this.adminActions;
    }

    protected void initializeConfiguration(Properties properties) throws ConfigurationException {
        for (PropertyChecker checker : this.propertyCheckers) {
            checker.checkProperties(properties, logger);
        }
        this.containerSecurityConfiguration = new ContainerSecurityProperties(properties);
        this.containerConfiguration = new ContainerProperties(properties, this.containerSecurityConfiguration.isSslEnabled());
        this.jettyConfiguration = new ContainerHttpServerProperties(properties);
        this.clientConfiguration = new USEClientProperties(properties, this.containerSecurityConfiguration);
        this.persistenceProperties = new PersistenceProperties(properties);
        try {
            String pdpConfig = this.containerSecurityConfiguration.getPdpConfigurationFile();
            if (pdpConfig != null) {
                logger.info((Object)("Using PDP configuration file <" + pdpConfig + ">"));
            }
            this.containerSecurityConfiguration.getPdp().initialize(pdpConfig, this.containerConfiguration, this.containerSecurityConfiguration, (IClientConfiguration)this.clientConfiguration);
        }
        catch (Exception e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateConfiguration(Properties properties) throws ConfigurationException {
        List<PropertyChecker> list = this.propertyCheckers;
        synchronized (list) {
            for (PropertyChecker checker : this.propertyCheckers) {
                checker.checkProperties(properties, logger);
            }
        }
        this.containerSecurityConfiguration.updateProperties(properties);
        USEClientProperties clientConfiguration = new USEClientProperties(properties, this.containerSecurityConfiguration);
        this.containerConfiguration.setProperties(properties);
        this.jettyConfiguration.setProperties(properties);
        Kernel kernel = this;
        synchronized (kernel) {
            this.clientConfiguration = clientConfiguration;
            this.lastPropertyChangeInstant = System.currentTimeMillis();
        }
    }

    private void initializeBuddies() throws Exception {
        this.msg = new MessagingImpl(this.getPersistenceProperties());
        this.persistenceManager = new PersistenceManager(this);
        this.deploymentManager = new DeploymentManager(this);
        this.jetty = new JettyServer(this, this.jettyConfiguration);
        this.securityManager = new SecurityManager(this.getContainerSecurityConfiguration());
        MetricRegistry.getInstance().registerMetric((IMetric)new CertificateInfoMetric(this.securityManager));
        this.adminActions = AdminActionLoader.load();
        this.gwHandler = new GatewayHandler(this.getContainerProperties(), (IClientConfiguration)this.getClientConfiguration(), this.containerSecurityConfiguration);
    }

    protected void prepare(String conf, Properties extraSettings) throws Exception {
        if (conf != null) {
            File file = new File(conf);
            this.serviceConfigurator = new ServiceConfigReader(this, file);
        } else {
            this.serviceConfigurator = new NullServiceConfigurator();
        }
        this.addPropertyChecker(new USEPropertyChecker());
        Properties p = this.serviceConfigurator.loadProperties();
        if (extraSettings != null) {
            p.putAll((Map<?, ?>)extraSettings);
        }
        this.initializeConfiguration(p);
        this.serviceConfigurator.startConfigMonitoring(this.getContainerProperties().getThreadingServices(), 5000L);
        this.initializeBuddies();
        this.initGateway();
        this.startupTasks = this.deployServices();
        try {
            this.containerSecurityConfiguration.getAip().start(this);
            this.containerSecurityConfiguration.getDap().start(this);
        }
        catch (Exception e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)e);
        }
    }

    public void start() throws Exception {
        this.isShutdown = false;
        this.jetty.start();
        ServiceLoader<StartupTask> sl = ServiceLoader.load(StartupTask.class);
        new StartupTasksRunner().runStartupTasks(this, sl);
        for (Service s : this.services.values()) {
            Home h = s.getHome();
            if (h == null) continue;
            h.run();
        }
        if (this.startupTasks != null) {
            for (Runnable r : this.startupTasks) {
                logger.info((Object)("Running startup task <" + r + ">"));
                r.run();
            }
        }
        this.startLogConfigWatcher();
        this.addShutDownHook();
    }

    public void startAsync() throws Exception {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Kernel.this.startSynchronous();
                }
                catch (Throwable e) {
                    Log.logException((String)"Error during server start.", (Throwable)e, (Logger)logger);
                    System.err.println("ERROR DURING SERVER STARTUP!");
                    e.printStackTrace();
                    System.exit(1);
                }
            }
        });
        t.setName("UNICORE/X-Startup");
        t.start();
    }

    public void startSynchronous() throws Exception {
        long start = System.currentTimeMillis();
        this.printHeader();
        this.start();
        logger.info((Object)("Startup time: " + (System.currentTimeMillis() - start) + " ms."));
        logger.info((Object)"***** Server started. *****");
        System.out.println("***** Server started. *****");
        System.out.println("Send TERM signal to shutdown gracefully.");
    }

    public static void main(String[] args) throws Exception {
        String conf = new File("conf", "wsrflite.xml").getAbsolutePath();
        try {
            conf = args[0];
        }
        catch (Exception e) {
            // empty catch block
        }
        System.out.println("Reading configuration from file " + conf);
        try {
            Kernel kernel = new Kernel(conf);
            kernel.startSynchronous();
        }
        catch (Throwable e) {
            Log.logException((String)"Error during server start.", (Throwable)e, (Logger)logger);
            System.err.println("ERROR DURING SERVER STARTUP!");
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void printHeader() {
        String header = this.getHeader();
        System.out.println(header);
        logger.info((Object)header);
    }

    private void registerDefaultFactories() {
        String[] factoryClasses;
        for (String clazz : factoryClasses = new String[]{"de.fzj.unicore.wsrflite.xfire.XFireServiceFactory", "eu.unicore.services.ws.cxf.CXFServiceFactory"}) {
            try {
                Class<?> c = Class.forName(clazz);
                ServiceFactory f = (ServiceFactory)c.newInstance();
                this.registerServiceFactory(f);
            }
            catch (ClassNotFoundException cnfe) {
                logger.debug((Object)("Service factory '" + clazz + "' is not available (class not found)."));
            }
            catch (Exception e) {
                logger.error((Object)("Can't register service factory " + clazz), (Throwable)e);
            }
        }
    }

    private void addShutDownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread("UNICORE/X-Shutdown"){

            @Override
            public void run() {
                try {
                    Kernel.this.shutdown();
                }
                catch (Exception e) {
                    Log.logException((String)"Error during shutdown", (Throwable)e, (Logger)logger);
                }
            }
        });
    }

    private List<Runnable> deployServices() throws Exception {
        ArrayList<Runnable> tasks = null;
        Runnable serviceJarsDeployer = this.getDeploymentManager().getStartupServicejarDeployer();
        if (serviceJarsDeployer != null) {
            tasks = new ArrayList<Runnable>();
            tasks.add(serviceJarsDeployer);
            return tasks;
        }
        this.serviceConfigurator.configureServices();
        tasks = this.serviceConfigurator.getInitTasks();
        return tasks;
    }

    private void initGateway() throws Exception {
        this.gwHandler.waitForGateway();
        this.gwHandler.enableGatewayRegistration();
    }

    private void startLogConfigWatcher() {
        final String logConfig = System.getProperty("log4j.configuration");
        if (logConfig == null) {
            logger.debug((Object)"No logger configuration found.");
            return;
        }
        try {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        Kernel.reConfigureLog4j(logConfig);
                    }
                    catch (MalformedURLException me) {
                        throw new RuntimeException(me);
                    }
                }
            };
            File logProperties = logConfig.startsWith("file:") ? new File(new URI(logConfig)) : new File(logConfig);
            FileWatcher fw = new FileWatcher(logProperties, r);
            this.containerConfiguration.getThreadingServices().getScheduledExecutorService().scheduleWithFixedDelay(fw, 5L, 5L, TimeUnit.SECONDS);
        }
        catch (FileNotFoundException fex) {
            logger.warn((Object)("Log configuration file <" + logConfig + "> not found."));
        }
        catch (URISyntaxException use) {
            logger.warn((Object)("Location of log configuration is not an URI: <" + logConfig + ">"));
        }
    }

    public static void reConfigureLog4j(String logConfig) throws MalformedURLException {
        logger.info((Object)"LOG CONFIG MODIFIED, re-configuring.");
        if (logConfig.startsWith("file:")) {
            PropertyConfigurator.configure((URL)new URL(logConfig));
        } else {
            PropertyConfigurator.configure((String)logConfig);
        }
    }

    public <T> T load(Class<T> clazz) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException {
        T o = null;
        Constructor<T> con = null;
        for (Constructor<?> c : clazz.getConstructors()) {
            Class<?>[] params = c.getParameterTypes();
            if (params == null || params.length != 1 || !params[0].isAssignableFrom(Kernel.class)) continue;
            con = clazz.getConstructor(Kernel.class);
        }
        if (con != null) {
            o = con.newInstance(this);
        } else {
            o = clazz.newInstance();
            if (o instanceof KernelInjectable) {
                ((KernelInjectable)o).setKernel(this);
            }
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Observable o, Object arg) {
        if (arg instanceof PropertyFileChangeEvent) {
            PropertyFileChangeEvent event = (PropertyFileChangeEvent)arg;
            this.updateConfiguration(event.getProperties());
            Collection<UpdateableConfiguration> collection = this.configurations;
            synchronized (collection) {
                for (UpdateableConfiguration cfg : this.configurations) {
                    try {
                        cfg.setProperties(event.getProperties());
                    }
                    catch (ConfigurationException e) {
                        logger.error((Object)("Can't update configuration of " + cfg.getClass().getSimpleName() + ": " + e.getMessage()));
                    }
                }
            }
        }
    }
}

