/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite;

import de.fzj.unicore.wsrflite.ContainerProperties;
import de.fzj.unicore.wsrflite.ExternalSystemConnector;
import de.fzj.unicore.wsrflite.ThreadingServices;
import de.fzj.unicore.wsrflite.security.DefaultContainerSecurityConfiguration;
import de.fzj.unicore.wsrflite.utils.TimeoutRunner;
import de.fzj.unicore.wsrflite.utils.Utilities;
import eu.emi.security.authn.x509.impl.X500NameUtils;
import eu.unicore.security.canl.IAuthnAndTrustConfiguration;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.ConnectionUtil;
import eu.unicore.util.httpclient.HttpUtils;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.cert.X509Certificate;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.log4j.Logger;

public class GatewayHandler
implements ExternalSystemConnector {
    private static final Logger logger = Log.getLogger((String)"unicore", GatewayHandler.class);
    private final ContainerProperties containerConfiguration;
    private final IClientConfiguration clientConfiguration;
    private final DefaultContainerSecurityConfiguration secConfiguration;
    private final ThreadingServices threadingSrv;
    private ExternalSystemConnector.Status status = ExternalSystemConnector.Status.UNKNOWN;
    private String statusMessage;
    private long lastChecked;

    public GatewayHandler(ContainerProperties containerConfiguration, IClientConfiguration clientConfiguration, DefaultContainerSecurityConfiguration secConfiguration) {
        this.containerConfiguration = containerConfiguration;
        this.clientConfiguration = clientConfiguration;
        this.secConfiguration = secConfiguration;
        this.threadingSrv = containerConfiguration.getThreadingServices();
    }

    public void waitForGateway() throws Exception {
        if (!this.secConfiguration.isGatewayWaitingEnabled()) {
            return;
        }
        Integer timeout = this.secConfiguration.getGatewayWaitTime();
        timeout = timeout * 1000;
        long start = System.currentTimeMillis();
        String gwUrl = this.containerConfiguration.getValue("baseurl");
        while (true) {
            try {
                X509Certificate[] cert = ConnectionUtil.getPeerCertificate((IAuthnAndTrustConfiguration)this.clientConfiguration, (String)gwUrl, (int)((int)((long)timeout.intValue() - (System.currentTimeMillis() - start))), (Logger)logger);
                logger.info((Object)("Successfully connected to gateway at " + gwUrl));
                if (this.secConfiguration.isGatewaySignatureCheckingEnabled() && this.secConfiguration.getGatewayCertificate() == null) {
                    this.secConfiguration.setGatewayCertificate(cert[0]);
                    logger.info((Object)("Gateway's DN was autodetected and will be used for signature checking: " + X500NameUtils.getReadableForm((X500Principal)this.secConfiguration.getGatewayCertificate().getSubjectX500Principal())));
                }
                return;
            }
            catch (Exception e1) {
                logger.info((Object)"Waiting for gateway...");
                if ((long)timeout.intValue() >= System.currentTimeMillis() - start) {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (Exception e) {}
                    continue;
                }
                throw new Exception("The Gateway is not available and the server is configured to wait for it (the property 'container.security.gateway.waitOnStartup')");
            }
            break;
        }
    }

    @Override
    public String getConnectionStatusMessage() {
        this.checkConnection();
        return this.statusMessage;
    }

    @Override
    public ExternalSystemConnector.Status getConnectionStatus() {
        this.checkConnection();
        return this.status;
    }

    private void checkConnection() {
        if (this.lastChecked + 2000L > System.currentTimeMillis()) {
            return;
        }
        String url = this.containerConfiguration.getValue("baseurl");
        String myHost = this.containerConfiguration.getValue("host") + ":" + this.containerConfiguration.getValue("port");
        boolean secure = this.clientConfiguration.isSslEnabled();
        if (url.contains(myHost)) {
            this.status = ExternalSystemConnector.Status.NOT_APPLICABLE;
            this.statusMessage = "N/A (no gateway used)";
        } else if (TimeoutRunner.compute(this.getCheckConnectionTask(url, secure), this.threadingSrv, 2000) != null) {
            this.status = ExternalSystemConnector.Status.OK;
            this.statusMessage = "OK [connected to " + url + "]";
        } else {
            this.status = ExternalSystemConnector.Status.DOWN;
            this.statusMessage = "CAN'T CONNECT TO GATEWAY " + url;
        }
        this.lastChecked = System.currentTimeMillis();
    }

    public void enableGatewayRegistration() throws Exception {
        if (!this.secConfiguration.isGatewayRegistrationEnabled()) {
            return;
        }
        Integer update = this.secConfiguration.getGatewayRegistrationUpdateInterval();
        logger.info((Object)("Enabling dynamic registration at the Gateway at " + Utilities.getGatewayAddress(this.containerConfiguration) + " updated every " + update + " seconds."));
        new GatewayRegistration(this.containerConfiguration, update);
    }

    private Callable<Boolean> getCheckConnectionTask(final String url, final boolean secure) {
        Callable<Boolean> getCert = new Callable<Boolean>(){

            @Override
            public Boolean call() {
                try {
                    if (!secure) {
                        throw new RuntimeException("Insecure Gw communication is not yet implemented");
                    }
                    ConnectionUtil.getPeerCertificate((IAuthnAndTrustConfiguration)GatewayHandler.this.clientConfiguration, (String)url, (int)2000, (Logger)logger);
                    return true;
                }
                catch (UnknownHostException e) {
                    logger.warn((Object)("Gateway host is unknown: " + e));
                    return false;
                }
                catch (IOException e) {
                    logger.warn((Object)("Can't contact gateway: " + e));
                    return false;
                }
            }
        };
        return getCert;
    }

    public class GatewayRegistration
    implements Runnable {
        private HttpClient client;
        private final String gwAddress;
        private final ContainerProperties containerConfiguration;

        public GatewayRegistration(ContainerProperties containerConfiguration) throws Exception {
            this(containerConfiguration, 60);
        }

        public GatewayRegistration(ContainerProperties containerConfiguration, int updateInterval) throws Exception {
            this.containerConfiguration = containerConfiguration;
            this.gwAddress = this.extractGWAddress(containerConfiguration.getValue("baseurl")) + "/VSITE_REGISTRATION_REQUEST";
            this.client = HttpUtils.createClient((String)this.gwAddress, (IClientConfiguration)GatewayHandler.this.clientConfiguration);
            GatewayHandler.this.threadingSrv.getScheduledExecutorService().scheduleWithFixedDelay(this, 0L, 1000 * updateInterval, TimeUnit.MILLISECONDS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            PostMethod post = new PostMethod(this.gwAddress);
            try {
                post.addParameter("name", this.containerConfiguration.getValue("sitename"));
                String physAddr = Utilities.getPhysicalServerAddress(this.containerConfiguration, GatewayHandler.this.clientConfiguration.isSslEnabled());
                post.addParameter("address", physAddr);
                this.client.executeMethod((HttpMethod)post);
                if (post.getStatusCode() != 201) {
                    logger.warn((Object)("Could not register with gateway at " + this.gwAddress + ", will try again!"));
                }
                InputStream is = post.getResponseBodyAsStream();
                while (is.read() != -1) {
                }
                logger.debug((Object)("(Re-)registered with gateway at " + this.gwAddress + "."));
            }
            catch (Exception e) {
                Log.logException((String)("Could not contact gateway at " + this.gwAddress), (Throwable)e, (Logger)logger);
            }
            finally {
                post.releaseConnection();
            }
        }

        private String extractGWAddress(String base) throws MalformedURLException {
            URL u = new URL(base);
            return u.toString().split(u.getPath())[0];
        }
    }
}

