/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite;

import de.fzj.unicore.metrix.MetricRegistry;
import de.fzj.unicore.wsrflite.Home;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.Service;
import de.fzj.unicore.wsrflite.ServiceConfiguration;
import de.fzj.unicore.wsrflite.ServiceFactory;
import de.fzj.unicore.wsrflite.ThreadingServices;
import de.fzj.unicore.wsrflite.exceptions.ServiceDeploymentException;
import de.fzj.unicore.wsrflite.exceptions.ServiceUndeploymentException;
import de.fzj.unicore.wsrflite.persistence.Store;
import de.fzj.unicore.wsrflite.utils.deployment.DeploymentDescriptorImpl;
import de.fzj.unicore.wsrflite.utils.deployment.DeploymentUtils;
import de.fzj.unicore.wsrflite.utils.deployment.ListFilesByExtensionFilter;
import de.fzj.unicore.wsrflite.utils.deployment.ServiceClassLoader;
import eu.unicore.util.Log;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.log4j.Logger;

public class DeploymentManager {
    private static final Logger logger = Log.getLogger((String)"unicore.wsrflite", DeploymentManager.class);
    private boolean serviceJarsDeployed = false;
    private final Map<String, File> serviceJars = Collections.synchronizedMap(new HashMap());
    private final Kernel kernel;

    public DeploymentManager(Kernel kernel) {
        this.kernel = kernel;
        this.init();
    }

    private void init() {
        if (this.dynamicDeploymentActivated()) {
            try {
                DeploymentUtils.createDirectory(this.pathToServiceJars());
            }
            catch (IOException ex) {
                logger.error((Object)"Error setting up directory for dynamic deployment, deactivating!", (Throwable)ex);
            }
        }
        if (!this.dynamicDeploymentActivated()) {
            logger.info((Object)"Dynamic service deployment deactivated.");
        } else {
            logger.info((Object)("Dynamic deployment of service jars activated. Directory for service jars: " + new File(this.pathToServiceJars()).getAbsolutePath()));
        }
    }

    public synchronized void deployService(Service service) throws ServiceDeploymentException {
        this.kernel.addService(service);
        try {
            service.start();
            logger.info((Object)("Service <" + service.getName() + "> successfully deployed."));
        }
        catch (Throwable ex) {
            throw new ServiceDeploymentException("Can't start service <" + service.getName() + ">", ex);
        }
    }

    public synchronized void deployService(String serviceName, DeploymentDescriptorImpl info, ClassLoader classLoader) throws ServiceDeploymentException, ClassNotFoundException {
        ServiceConfiguration sc = new ServiceConfiguration(this.kernel, serviceName);
        if (classLoader == null) {
            classLoader = new ServiceClassLoader();
        }
        sc.setClassLoader(classLoader);
        try {
            String type = info.type();
            sc.setInterfaceClass(info.iFace());
            sc.setImplementationClass(info.impl());
            String initTaskName = info.initTask();
            Class<?> initTask = null;
            if (initTaskName != null && !"".equals(initTaskName)) {
                initTask = Class.forName(initTaskName, true, classLoader);
            }
            boolean isPersistent = info.isPersistent();
            sc.setPersistent(isPersistent);
            ServiceFactory sf = this.kernel.getServiceFactory(type);
            Service s = sf.build(sc);
            this.kernel.addService(s);
            s.start();
            if (initTask != null) {
                ThreadingServices ts = this.kernel.getContainerProperties().getThreadingServices();
                ts.getExecutorService().execute((Runnable)initTask.newInstance());
            }
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceDeploymentException(e);
        }
    }

    public synchronized void deployService(String serviceName, byte[] jarAsBytes, boolean isPersistent) throws ServiceDeploymentException {
        DeploymentDescriptorImpl info = null;
        if (this.dynamicDeploymentActivated()) {
            if (this.kernel.getService(serviceName) != null) {
                throw new ServiceDeploymentException("Service <" + serviceName + "> already exists.");
            }
            File jarFile = null;
            try {
                String pathToJarFile = this.pathToServiceJars() + File.separator + serviceName + ".jar";
                jarFile = DeploymentUtils.createJar(pathToJarFile, jarAsBytes);
                info = DeploymentUtils.extractDeploymentMetadata(jarFile);
                info = new DeploymentDescriptorImpl(info.iFace(), info.impl(), isPersistent, info.initTask());
                ClassLoader cl = this.getClassLoader(jarFile, serviceName);
                this.deployService(serviceName, info, cl);
            }
            catch (Exception e) {
                try {
                    this.unregisterService(serviceName);
                }
                catch (Exception ex) {
                    logger.error((Object)"Error unregistering service", (Throwable)ex);
                }
                Log.logException((String)("Deployment for service '" + serviceName + "' aborted. Reason: " + e.getMessage()), (Throwable)e, (Logger)logger);
                throw new ServiceDeploymentException(e);
            }
        }
        throw new ServiceDeploymentException(serviceName + " couldn't be deployed since dynamic deployment is deactivated.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void undeployService(String serviceName) throws IOException, ServiceUndeploymentException {
        if (this.dynamicDeploymentActivated()) {
            if (this.kernel.getService(serviceName) == null) {
                throw new ServiceUndeploymentException("Service <" + serviceName + "> does not exist.");
            }
            try {
                try {
                    this.unregisterService(serviceName);
                }
                catch (Exception ex) {
                    throw new ServiceUndeploymentException("Error unregistering service <" + serviceName + ">", ex);
                }
            }
            finally {
                File jar = this.serviceJars.remove(serviceName);
                if (!jar.delete()) {
                    logger.warn((Object)("JAR file removal failed: " + jar.getAbsolutePath()));
                }
                this.unregisterMetricsForService(serviceName);
            }
        }
    }

    public Home getServiceHome(String serviceName) {
        return this.kernel.getService(serviceName).getHome();
    }

    ClassLoader getClassLoader(File jarFile, String serviceName) throws Exception, IOException, ClassNotFoundException {
        if (serviceName == null) {
            serviceName = DeploymentUtils.extractServiceNameFromJarFile(jarFile);
        }
        File tmpCopy = new File(this.pathToServiceJars() + File.separator + "tmp" + File.separator + UUID.randomUUID() + ".jar");
        DeploymentUtils.copyFile(jarFile, tmpCopy);
        this.serviceJars.put(serviceName, jarFile);
        URL url = tmpCopy.toURI().toURL();
        URLClassLoader cl = new URLClassLoader(new URL[]{url});
        return cl;
    }

    void unregisterService(String serviceName) throws Exception {
        Service s = this.kernel.removeService(serviceName);
        if (s != null) {
            Store store;
            if (s.getHome() != null && (store = this.kernel.getPersistenceManager().getPersist(serviceName)) != null) {
                store.purgePersistentData();
                store.shutdown();
                this.kernel.getPersistenceManager().removePersist(serviceName);
            }
            s.stopAndCleanup();
            s.setClassLoader(null);
        }
    }

    private void unregisterMetricsForService(String serviceName) {
        String[] metricCategories;
        String[] metrics;
        for (String metric : metrics = MetricRegistry.getInstance().getMetricIDs()) {
            if (!metric.contains(serviceName)) continue;
            MetricRegistry.getInstance().unregisterMetric(metric);
        }
        for (String cat : metricCategories = MetricRegistry.getInstance().getMetricCategories()) {
            if (!cat.endsWith("." + serviceName)) continue;
            MetricRegistry.getInstance().unregisterCategory(cat);
        }
    }

    public Runnable getStartupServicejarDeployer() {
        if (!this.dynamicDeploymentActivated()) {
            return null;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                if (!DeploymentManager.this.serviceJarsDeployed && DeploymentManager.this.kernel.getServer().getServer().isStarted()) {
                    File[] jars;
                    File dir = new File(DeploymentManager.this.pathToServiceJars());
                    for (File jar : jars = dir.listFiles(new ListFilesByExtensionFilter("jar"))) {
                        try {
                            String serviceName = jar.getName().replace(".jar", "");
                            DeploymentDescriptorImpl info = DeploymentUtils.extractDeploymentMetadata(jar);
                            DeploymentManager.this.deployService(serviceName, info, DeploymentManager.this.getClassLoader(jar, serviceName));
                        }
                        catch (Exception e) {
                            logger.error((Object)("Couldn't deploy service from " + jar), (Throwable)e);
                        }
                    }
                    DeploymentManager.this.serviceJarsDeployed = true;
                }
            }

            public String toString() {
                return "Startup Service Jars Deployer";
            }
        };
        return r;
    }

    public final Kernel getKernel() {
        return this.kernel;
    }

    public boolean dynamicDeploymentActivated() {
        return this.kernel.getContainerProperties().getBooleanValue("deployment.dynamic") != false && this.pathToServiceJars() != null;
    }

    public String pathToServiceJars() {
        return this.kernel.getContainerProperties().getFileValueAsString("deployment.dynamic.jarDirectory", true);
    }
}

