/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite;

import de.fzj.unicore.wsrflite.ThreadingServices;
import de.fzj.unicore.wsrflite.persistence.InMemory;
import de.fzj.unicore.wsrflite.persistence.Persistence;
import eu.unicore.util.Log;
import eu.unicore.util.configuration.ConfigurationException;
import eu.unicore.util.configuration.DocumentationReferenceMeta;
import eu.unicore.util.configuration.DocumentationReferencePrefix;
import eu.unicore.util.configuration.PropertiesHelper;
import eu.unicore.util.configuration.PropertyMD;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ContainerProperties
extends PropertiesHelper {
    private static final Logger log = Log.getLogger((String)"unicore.configuration", ContainerProperties.class);
    @DocumentationReferencePrefix
    public static final String PREFIX = "container.";
    public static final String CONFIG_FILE = "configfile";
    public static final String WSRF_BASEURL = "baseurl";
    public static final String WSRF_HOST = "host";
    public static final String WSRF_PORT = "port";
    public static final String WSRF_SERVLETPATH = "servletpath";
    public static final String ON_STARTUP_KEY = "onstartup";
    public static final String ON_STARTUP_LIST_KEY = "onstartup.";
    public static final String ON_STARTUP_SELFTEST = "onstartupSelftest";
    public static final String VSITE_NAME_PROPERTY = "sitename";
    public static final String CORE_POOL_SIZE = "resources.scheduled.size";
    public static final String POOL_TIMEOUT = "resources.scheduled.idletime";
    public static final String EXEC_CORE_POOL_SIZE = "resources.executor.minsize";
    public static final String EXEC_MAX_POOL_SIZE = "resources.executor.maxsize";
    public static final String EXEC_POOL_TIMEOUT = "resources.executor.idletime";
    public static final String WSRF_DEPLOYMENT_DYNAMIC = "deployment.dynamic";
    public static final String WSRF_DEPLOYMENT_DYNAMIC_PLUGINSERVICES_JARS = "deployment.dynamic.jarDirectory";
    public static final String WSRF_PERSIST_CLASSNAME = "wsrf.persistence.persist";
    public static final String PERSISTENT = "unicore.wsrflite.isPersistent";
    public static final String MAX_INSTANCES = "wsrf.maxInstancesPerUser";
    public static final String EXPIRYCHECK_INITIAL = "wsrf.expirycheck.initial";
    public static final String EXPIRYCHECK_PERIOD = "wsrf.expirycheck.period";
    public static final String DEFAULT_LIFETIME = "wsrf.lifetime.default";
    public static final String MAXIMUM_LIFETIME = "wsrf.lifetime.maximum";
    public static final String WSRF_SGENTRY_TERMINATION_TIME = "wsrf.sg.defaulttermtime";
    public static final String GLOBAL_REGISTRY_ADVERTISE = "registry.globalAdvertise";
    public static final String EXTERNAL_REGISTRY_USE = "externalregistry.use";
    public static final String REGISTRY_AUTODISCOVER = "externalregistry.autodiscover";
    public static final String EXTERNAL_REGISTRY_KEY = "externalregistry.url";
    @DocumentationReferenceMeta
    public static final Map<String, PropertyMD> META = new HashMap<String, PropertyMD>();
    protected ThreadingServices threadingServices;

    public ContainerProperties(Properties properties, boolean sslMode) throws ConfigurationException {
        super(PREFIX, properties, META, log);
        this.updatePropertiesInternal(sslMode);
        this.threadingServices = new ThreadingServices(this);
    }

    public ThreadingServices getThreadingServices() {
        return this.threadingServices;
    }

    public void updateProperties(Properties properties, boolean sslMode) {
        super.setProperties(properties);
        this.updatePropertiesInternal(sslMode);
    }

    private void updatePropertiesInternal(boolean sslMode) {
        String clazz;
        String baseUrl;
        if (!this.isSet(WSRF_HOST)) {
            try {
                InetAddress p = InetAddress.getLocalHost();
                this.setProperty(WSRF_HOST, p.getCanonicalHostName());
            }
            catch (Exception e) {
                Log.logException((String)"Could not determine hostname. Fallback to localhost", (Throwable)e, (Logger)log);
                this.setProperty(WSRF_HOST, "localhost");
            }
        }
        if (!this.isSet(WSRF_BASEURL)) {
            String host = this.getValue(WSRF_HOST);
            String port = this.getValue(WSRF_PORT);
            String path = this.getValue(WSRF_SERVLETPATH);
            String protocol = sslMode ? "https" : "http";
            String baseUrl2 = protocol + "://" + host + ":" + port + path;
            this.setProperty(WSRF_BASEURL, baseUrl2);
            log.info((Object)("Using an autogenerated baseurl = " + baseUrl2));
        }
        if ((baseUrl = this.getValue(WSRF_BASEURL)).endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
            this.setProperty(WSRF_BASEURL, baseUrl);
            log.warn((Object)"Removed trailing '/' from value of container.baseurl");
        }
        if ("de.fzj.unicore.wsrflite.persistence.HsqldbPersist".equalsIgnoreCase(clazz = this.getValue(WSRF_PERSIST_CLASSNAME))) {
            log.warn((Object)("Persistence configuration uses old class name 'HsqldbPersist', should use <" + Persistence.class.getName() + "> instead."));
            this.setProperty(WSRF_PERSIST_CLASSNAME, Persistence.class.getName());
        }
    }

    public Properties getRawProperties() {
        return this.properties;
    }

    public String getBaseUrl() {
        return this.getValue(WSRF_BASEURL);
    }

    static {
        META.put(CONFIG_FILE, new PropertyMD().setPath().setDescription("Allows to specify the location of XML configuration file of the USE container. Useful only in properties file."));
        META.put(ON_STARTUP_SELFTEST, new PropertyMD("true").setDescription("Controls whether to run tests of connections to external services on startup."));
        META.put(VSITE_NAME_PROPERTY, new PropertyMD("DEMO-SITE").setDescription("Short, human friendly, name of the target system, should be unique in the grid."));
        META.put(WSRF_SERVLETPATH, new PropertyMD("/services").setDescription("Servlet context path. In most cases shouldn't be changed."));
        META.put(WSRF_BASEURL, new PropertyMD().setDescription("Server URL as visible from the outside, usually the gateway's address."));
        META.put(WSRF_HOST, new PropertyMD("localhost").setDescription("Server interface to listen on."));
        META.put(WSRF_PORT, new PropertyMD("7777").setBounds(0L, 65535L).setDescription("Server listen port."));
        META.put(CORE_POOL_SIZE, new PropertyMD("3").setPositive().setDescription("Defines the thread pool size for the execution of scheduled services."));
        META.put(POOL_TIMEOUT, new PropertyMD("60000").setDescription("Timeout in millis for removing idle threads."));
        META.put(EXEC_CORE_POOL_SIZE, new PropertyMD("10").setDescription("The minimum thread pool size for the scheduled execution service"));
        META.put(EXEC_MAX_POOL_SIZE, new PropertyMD("32").setDescription("The maximum thread pool size for the scheduled execution service"));
        META.put(EXEC_POOL_TIMEOUT, new PropertyMD("60000").setDescription("The timeout in millis for removing idle threads."));
        META.put(WSRF_DEPLOYMENT_DYNAMIC, new PropertyMD("false").setDescription("Controls whether dynamic deployment (at runtime) of services is enabled."));
        META.put(WSRF_DEPLOYMENT_DYNAMIC_PLUGINSERVICES_JARS, new PropertyMD().setPath().setDescription("Directory with Jar files for dynamic deployment."));
        META.put(PERSISTENT, new PropertyMD("false").setCanHaveSubkeys().setDescription("Global setting controlling persistence of WS-resources state. Additionally it can be used as a per-service setting, after appending a dot and service name to the property key."));
        META.put(WSRF_PERSIST_CLASSNAME, new PropertyMD(InMemory.class.getName()).setDescription("Implementation used to maintain the persistence of WS-resources state."));
        META.put(EXPIRYCHECK_INITIAL, new PropertyMD("120").setCanHaveSubkeys().setDescription("The initial delay for WS-resource expiry checking (seconds). Additionally it can be used as a per-service setting, after appending a dot and service name to the property key."));
        META.put(EXPIRYCHECK_PERIOD, new PropertyMD("60").setCanHaveSubkeys().setDescription("The interval for WS-resource expiry checking (seconds).  Additionally it can be used as a per-service setting, after appending a dot and service name to the property key."));
        META.put(DEFAULT_LIFETIME, new PropertyMD("86400").setPositive().setCanHaveSubkeys().setDescription("Default lifetime of WS-resources (in seconds).  Add dot and service name as a suffix of this property to set a default per particular service type."));
        META.put(MAXIMUM_LIFETIME, new PropertyMD().setInt().setPositive().setCanHaveSubkeys().setDescription("Maximum lifetime of WS-resources (in seconds).  Add dot and service name as a suffix of this property to set a limit per particular service type."));
        META.put(MAX_INSTANCES, new PropertyMD("2147483647").setPositive().setCanHaveSubkeys().setDescription("Maximum number per user of WS-resource instances. Add dot and service name as a suffix of this property to set a limit per particular service type."));
        META.put(WSRF_SGENTRY_TERMINATION_TIME, new PropertyMD("1800").setPositive().setDescription("The default termination time of service group entries in seconds."));
        META.put(ON_STARTUP_KEY, new PropertyMD().setDescription("Space separated list of runnables to be executed on server startup. It is preferred to use onstartup."));
        META.put(ON_STARTUP_LIST_KEY, new PropertyMD().setList(true).setDescription("List of runnables to be executed on server startup."));
        META.put(GLOBAL_REGISTRY_ADVERTISE, new PropertyMD("false").setDescription("If this server runs a global registry, this setting controls whether it is advertised using multicast."));
        META.put(EXTERNAL_REGISTRY_USE, new PropertyMD("false").setUpdateable().setDescription("Whether the service should register itself in external registry(-ies), defined separately."));
        META.put(EXTERNAL_REGISTRY_KEY, new PropertyMD().setList(false).setUpdateable().setDescription("List of external registry URLs to register local services."));
        META.put(REGISTRY_AUTODISCOVER, new PropertyMD("false").setUpdateable().setDescription("Whether to autodiscover registries using multicast"));
        META.put("security.", new PropertyMD().setCanHaveSubkeys().setDescription("Properties with this prefix are used to configure container's security. See separate documentation for details."));
        META.put("client.", new PropertyMD().setCanHaveSubkeys().setDescription("Properties with this prefix are used to configure clients created by the container. See separate documentation for details."));
        META.put("httpServer.", new PropertyMD().setCanHaveSubkeys().setDescription("Properties with this prefix are used to configure container's Jetty HTTP server. See separate documentation for details."));
        META.put("persistence.", new PropertyMD().setCanHaveSubkeys().setDescription("Properties with this prefix are used to configure container's persistence layer. See separate documentation for details."));
    }
}

