/*
 * Decompiled with CFR 0.152.
 */
package de.pc2.unicore.edgi.xnjs.io.passthrough;

import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.io.IFileTransfer;
import de.fzj.unicore.xnjs.io.IStorageAdapter;
import de.fzj.unicore.xnjs.io.OptionNotSupportedException;
import de.fzj.unicore.xnjs.tsi.TSI;
import eu.unicore.security.Client;
import java.io.Serializable;
import java.util.Map;
import java.util.UUID;

public abstract class PassthroughTransferBase
implements IFileTransfer {
    protected IFileTransfer.Status status;
    protected String statusMessage = null;
    protected Configuration configuration;
    protected final Client client;
    protected final String uuid;
    protected IFileTransfer.OverwritePolicy overwrite;
    private String parentActionID;
    protected volatile boolean aborted = false;

    public PassthroughTransferBase(Configuration configuration, Client client) {
        this.configuration = configuration;
        this.client = client;
        this.uuid = UUID.randomUUID().toString();
        this.status = IFileTransfer.Status.CREATED;
    }

    public boolean abort() {
        this.aborted = true;
        return true;
    }

    public String getParentActionID() {
        return this.parentActionID;
    }

    public IFileTransfer.Status getStatus() {
        return this.status;
    }

    public String getStatusMessage() {
        return this.statusMessage != null ? this.statusMessage : this.status.toString();
    }

    public String getUniqueId() {
        return this.uuid;
    }

    public boolean isStreaming() {
        return false;
    }

    public Map<String, Serializable> pause() {
        return null;
    }

    public void resume(Map<String, Serializable> status) {
    }

    protected void ensureDirectoriesExist(String path) throws Exception {
        String dir = path.substring(0, path.lastIndexOf("/"));
        TSI tsi = this.configuration.getTargetSystemInterface(this.client);
        tsi.mkdir(dir);
    }

    protected StorageClient createStorageClient() throws Exception {
        return null;
    }

    public void setOverwritePolicy(IFileTransfer.OverwritePolicy overwrite) throws OptionNotSupportedException {
        this.overwrite = overwrite;
    }

    public void setParentActionID(String actionID) {
        this.parentActionID = actionID;
    }

    public void setStorageAdapter(IStorageAdapter adapter) {
    }

    public String getProtocol() {
        return "bypass";
    }
}

