/*
 * Decompiled with CFR 0.152.
 */
package de.pc2.unicore.edgi.xnjs.io.passthrough;

import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.ems.Action;
import de.fzj.unicore.xnjs.io.DataStagingCredentials;
import de.fzj.unicore.xnjs.io.IFileTransfer;
import de.fzj.unicore.xnjs.io.IFileTransferCreator;
import de.pc2.unicore.edgi.xnjs.io.passthrough.PassthroughCapabilities;
import de.pc2.unicore.edgi.xnjs.io.passthrough.PassthroughDownload;
import de.pc2.unicore.edgi.xnjs.io.passthrough.PassthroughUpload;
import de.pc2.unicore.edgi.xnjs.io.passthrough.URIComposed;
import eu.unicore.security.Client;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.log4j.Logger;

public class PassthroughFileTransferCreator
implements IFileTransferCreator {
    private static final Logger logger = LogUtil.getLogger((String)"unicore.services", PassthroughFileTransferCreator.class);
    private Configuration configuration;

    public PassthroughFileTransferCreator(Configuration configuration) {
        this.configuration = configuration;
    }

    public IFileTransfer createFileExport(Client client, String workingDirectory, String source, URI target, DataStagingCredentials credentials) {
        if (PassthroughCapabilities.isValidUri(target)) {
            boolean invalidFormat = false;
            URIComposed uric = null;
            try {
                uric = URIComposed.fromOuterURI(target, false);
            }
            catch (NumberFormatException e1) {
                logger.error((Object)("passthrough invalid format: " + target), (Throwable)e1);
                invalidFormat = true;
            }
            catch (URISyntaxException e1) {
                logger.error((Object)("passthrough invalid format: " + target), (Throwable)e1);
                invalidFormat = true;
            }
            if (invalidFormat || !uric.hasMD5andSize()) {
                logger.info((Object)"passthrough deactivated because not enough parameter given. expected pass://URI=MD5=size. fallback: try to stage in from inner URI.");
                IFileTransfer ft = null;
                try {
                    ft = this.configuration.getFileTransferEngine().createFileExport(client, workingDirectory, source, uric.uri, IFileTransfer.OverwritePolicy.DONT_OVERWRITE, credentials);
                }
                catch (IOException e) {
                    logger.error((Object)("ignored execption while searching for file import for inner URI: " + uric.uri), (Throwable)e);
                }
                return ft;
            }
            logger.debug((Object)("detect passthrough url = " + uric.toString()));
            return new PassthroughUpload(this.configuration, client, source, target);
        }
        return null;
    }

    public IFileTransfer createFileImport(Client client, String workingDirectory, URI source, String target, DataStagingCredentials credentials) {
        if (PassthroughCapabilities.isValidUri(source)) {
            boolean invalidFormat = false;
            URIComposed uric = null;
            try {
                uric = URIComposed.fromOuterURI(source, false);
            }
            catch (NumberFormatException e1) {
                logger.error((Object)("passthrough invalid format: " + source), (Throwable)e1);
                invalidFormat = true;
            }
            catch (URISyntaxException e1) {
                logger.error((Object)("passthrough invalid format: " + source), (Throwable)e1);
                invalidFormat = true;
            }
            if (invalidFormat || !uric.hasMD5andSize()) {
                logger.info((Object)"passthrough deactivated because not enough parameter given. expected pass://URI=MD5=size. fallback: try to stage in from inner URI.");
                IFileTransfer ft = null;
                try {
                    ft = this.configuration.getFileTransferEngine().createFileImport(client, workingDirectory, uric.uri, target, IFileTransfer.OverwritePolicy.DONT_OVERWRITE, credentials);
                }
                catch (IOException e) {
                    logger.error((Object)("ignored execption while searching for file import for inner URI: " + uric.uri), (Throwable)e);
                }
                return ft;
            }
            logger.debug((Object)("detect passthrough url = " + uric.toString()));
            return new PassthroughDownload(this.configuration, client, source, target);
        }
        return null;
    }

    public IFileTransfer createFileTransfer(Action parent, URI source, URI target) {
        return null;
    }

    public String getProtocol() {
        return "bypass";
    }
}

